﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sale_analysis_jingyingqushi_byday.aspx.cs" Inherits="VA.Modules.JDingCYT.leaderquery.sale_jingyingqushi_byday" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/tabs.css" type="text/css" rel="Stylesheet" />
    <link href="/uicontrols/amcharts_v3.18.3/plugins/export/export.css" rel="stylesheet" type="text/css" >

    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->
    <script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.tabs.js"></script>
    <script type="text/javascript" src="/scripts/utils/dateutil.js"></script>    
    <script src="/uicontrols/amcharts_v3.18.3/amcharts.js" type="text/javascript"></script>
    <script src="/uicontrols/amcharts_v3.18.3/serial.js" type="text/javascript"></script>    
    <script src="/uicontrols/amcharts_v3.18.3/plugins/export/export.js" type="text/javascript"></script>

    <script type="text/javascript">

        //设置日期检索条件控件的行为；
        function setDateControlBehavior() {
            var $ddlDate = $("#ddlDateRule");
            if ($ddlDate.length == 0) {
                return;
            }

            if ($ddlDate.val() != "10") {
                $("#txtBeginDate").attr("disabled", "disabled");
                $("#txtEndDate").attr("disabled", "disabled");
            }
            $ddlDate.change(function () {
                var $txtBeginDate = $("#txtBeginDate");
                var $txtEndDate = $("#txtEndDate");

                $txtBeginDate.attr("disabled", "disabled");
                $txtEndDate.attr("disabled", "disabled");

                var beginDate = null;
                var endDate = null;
                var sBeginDate = null;
                var sEndDate = null;

                var myDate = new Date();

                var dateRule = $ddlDate.val();
                if (dateRule == "1") { //今天                    
                    beginDate = myDate;
                    endDate = myDate;
                }
                else if (dateRule == "2") { //昨天
                    beginDate = myDate.dateAdd("d", -1);
                    endDate = beginDate;
                }
                else if (dateRule == "3") { //前天
                    beginDate = myDate.dateAdd("d", -2);
                    endDate = beginDate;
                }
                else if (dateRule == "4") { //近两天
                    beginDate = myDate.dateAdd("d", -1);
                    endDate = myDate;
                }
                else if (dateRule == "5") { //近3天
                    beginDate = myDate.dateAdd("d", -2);
                    endDate = myDate;
                }
                else if (dateRule == "6") { //近1周
                    beginDate = myDate.dateAdd("w", -1);
                    endDate = myDate;
                }
                else if (dateRule == "7") { //近1月
                    beginDate = myDate.dateAdd("m", -1);
                    endDate = myDate;
                }
                else if (dateRule == "8") { //上月
                    var year = myDate.getFullYear(); //2015
                    var month = myDate.getMonth(); //
                    var day = 1;
                    var thisMonth_BeginDate = new Date(year, month, day);
                    var lastMonth_BeginDate = thisMonth_BeginDate.dateAdd("m", -1);
                    var lastMonth_EndDate = thisMonth_BeginDate.dateAdd("d", -1);

                    var date1 = new Date(2015, -1, 1);

                    beginDate = lastMonth_BeginDate;
                    endDate = lastMonth_EndDate;
                }
                else if (dateRule == "9") { //本月
                    var year = myDate.getFullYear(); //2015
                    var month = myDate.getMonth(); //
                    var day = 1;

                    beginDate = new Date(year, month, day);
                    endDate = myDate;
                }
                else if (dateRule == "10") { //自定义
                    beginDate = myDate;
                    endDate = myDate;
                    $("#txtBeginDate").removeAttr("disabled");
                    $("#txtEndDate").removeAttr("disabled");
                }

                sBeginDate = beginDate.format("yyyy-MM-dd");
                sEndDate = endDate.format("yyyy-MM-dd");

                $txtBeginDate.val(sBeginDate);
                $txtEndDate.val(sEndDate);

                $("#btnSearch").click();
            });
        }

        $(function () {
            JTongTabs_init();
            setDateControlBehavior();
        });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper">

<div class="centerFormTitle">
   <h1>营收趋势(按天)</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-bottom:-1px;">
<tr>
<td style="text-align:right;">

    <div style="height:1%;overflow:hidden;min-width:600px;">
        <div style="float:left">&nbsp;<span><%--门店：<% = base.ShopName %>--%></span></div>
        <div style="float:right">

        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>  
            
            <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
            <asp:ListItem Value="">统计期间</asp:ListItem>
            <asp:ListItem Value="1">今天</asp:ListItem>
            <asp:ListItem Value="2">昨天</asp:ListItem>
            <asp:ListItem Value="3">前天</asp:ListItem>
            <asp:ListItem Value="4">近两天</asp:ListItem>
            <asp:ListItem Value="5">近三天</asp:ListItem>
            <asp:ListItem Value="6" Selected="True">近一周</asp:ListItem>
            <asp:ListItem Value="7">近一月</asp:ListItem>
            <asp:ListItem Value="8">上月</asp:ListItem>
            <asp:ListItem Value="9">本月</asp:ListItem>
            <asp:ListItem Value="10">自定义</asp:ListItem>
            </asp:DropDownList>  

            <VACTL:TextBox ID="txtBeginDate" Runat="server"
                EnableViewState="False"
                CssClass="input"
                Width="80px"            
                onfocus="laydate()"
                MaxLength="20" />  
            -      
            <VACTL:TextBox ID="txtEndDate" Runat="server"
                EnableViewState="False"
                CssClass="input"
                Width="80px"            
                onfocus="laydate()"
                MaxLength="20" />      

            <asp:Button ID="btnSearch" runat="server" 
                 CssClass="simpleBtn"
                 Text="查询" 
                 Onclick="btnSearch_Click" />

         </ContentTemplate>
        </asp:UpdatePanel>

        </div>
    </div>
</td>
</tr>
</table>



<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td>
    <% if (base.dtbData != null && dtbData.Rows.Count > 0 && dtbData.Rows[0]["TotalCharges"] != DBNull.Value)
       {
           decimal totalCharges = 0.0m;
           foreach (System.Data.DataRow row in dtbData.Rows)
           {
               decimal charges = Convert.ToDecimal(row["TotalCharges"]);
               totalCharges += charges;
           }
           
           StringBuilder sb = new StringBuilder();
           sb.Append("营业额合计：" + totalCharges.ToString("F2"));
           Response.Write(sb.ToString());
       }
       else
       {
           Response.Write("暂无数据."); 
       }                
    %>
</td>
</tr>
</table>

<div id="divMemberInfoContaienr" style="margin-top:-1px;">
<div class="jtongui-tabs" fill="true">
	<ul class="header">
		<li class="tabheader-item-selected"><a>图表</a></li>        
		<li>明细数据</li>		        
	</ul>
	<div id="div_Chart" class="tabcontent tabcontent-selected">
	    <div id="chartdiv" style="width: 100%; height: 400px;"></div>
	</div>
	<div id="div_Detail" class="tabcontent">
        <div style="padding:3px;">
	    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
        <HeaderTemplate>    
        <table id="tableBody" cellpadding="3" cellspacing="0" class="listTable" style="margin-top:-1px;">
        <thead>
        <tr>
            <td style="width:40px;text-align:center;">日期</td>	            
            <td style="width:100px;text-align:center;">营业额</td>
            <td></td>
        </tr>    
        </thead>
        </HeaderTemplate>
        <ItemTemplate>
        <tr>
            <td align="center"><%# Eval("ChargeDate")%></td>            
            <td align="right"><%# Convert.ToDecimal(Eval("TotalCharges")).ToString("F2")%></td>
            <td></td>    	       	           
        </tr>
        </ItemTemplate>
        <FooterTemplate>
        </table>
        </FooterTemplate>
        </asp:Repeater>    
        <asp:Label ID="lblHidden" runat="server"></asp:Label>
        </div>
	</div>
</div>
</div>

<table id="Table2" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<tr>
<td class="footer"> 
    <input type="button" id="btnPrint" class="btn" style="width:80px" onclick="print()" value="打印" />    
    <%--<input type="button" id="btnExport" class="btn" style="width:80px" onclick="dataExport()" value="导出" />    --%>
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<script type="text/javascript">
    var chart;
    var legend;

    var chartData = null;

    <% if (base.dtbData != null && dtbData.Rows.Count > 0 && dtbData.Rows[0]["TotalCharges"] != DBNull.Value)
       {
           StringBuilder sb = new StringBuilder();           
           foreach (System.Data.DataRow row in dtbData.Rows)
           {
               string chargeDate = row["ChargeDate"].ToString();
               string totalCharges = Convert.ToDecimal(row["TotalCharges"]).ToString("f2");
               
               sb.Append(",{\"date\" : \""+ chargeDate +"\", \"value\":\"" + totalCharges + "\"}");                         
           }

           string dataString = sb.ToString();
           if (dataString.StartsWith(","))
           {
               dataString = dataString.Remove(0, 1); 
           }

           string chartData = "[" + dataString + "]";
           Response.Write("chartData = " + chartData + ";");                
       }                      
    %>

    //AmCharts.ready(function () {
    //    // SERIAL CHART
    //    chart = new AmCharts.AmSerialChart();

    //    chart.dataProvider = chartData;
    //    chart.dataDateFormat = "MM.DD";
    //    chart.categoryField = "date";


    //    // AXES
    //    // category
    //    var categoryAxis = chart.categoryAxis;
    //    categoryAxis.parseDates = true; // as our data is date-based, we set parseDates to true
    //    categoryAxis.minPeriod = "DD"; // our data is daily, so we set minPeriod to DD
    //    categoryAxis.gridAlpha = 0.1;
    //    categoryAxis.minorGridAlpha = 0.1;
    //    categoryAxis.axisAlpha = 0;
    //    categoryAxis.minorGridEnabled = true;
    //    categoryAxis.inside = true;

    //    // value
    //    var valueAxis = new AmCharts.ValueAxis();
    //    valueAxis.tickLength = 0;
    //    valueAxis.axisAlpha = 0;
    //    valueAxis.showFirstLabel = false;
    //    valueAxis.showLastLabel = false;
    //    chart.addValueAxis(valueAxis);

    //    // GRAPH
    //    var graph = new AmCharts.AmGraph();
    //    graph.dashLength = 3;
    //    graph.lineColor = "#00CC00";
    //    graph.valueField = "value";
    //    graph.dashLength = 3;
    //    graph.bullet = "round";
    //    graph.balloonText = "[[category]]<br><b><span style='font-size:14px;'>value:[[value]]</span></b>";
    //    chart.addGraph(graph);

    //    //// CURSOR
    //    //var chartCursor = new AmCharts.ChartCursor();
    //    //chartCursor.valueLineEnabled = true;
    //    //chartCursor.valueLineBalloonEnabled = true;
    //    //chart.addChartCursor(chartCursor);

    //    //// SCROLLBAR
    //    //var chartScrollbar = new AmCharts.ChartScrollbar();
    //    //chart.addChartScrollbar(chartScrollbar);

    //    // HORIZONTAL GREEN RANGE
    //    var guide = new AmCharts.Guide();
    //    guide.value = 10;
    //    guide.toValue = 20;
    //    guide.fillColor = "#00CC00";
    //    guide.inside = true;
    //    guide.fillAlpha = 0.2;
    //    guide.lineAlpha = 0;
    //    valueAxis.addGuide(guide);

    //    //// TREND LINES
    //    //// first trend line
    //    //var trendLine = new AmCharts.TrendLine();
    //    //// note,when creating date objects 0 month is January, as months are zero based in JavaScript.
    //    //trendLine.initialDate = new Date(2012, 0, 2, 12); // 12 is hour - to start trend line in the middle of the day
    //    //trendLine.finalDate = new Date(2012, 0, 11, 12);
    //    //trendLine.initialValue = 10;
    //    //trendLine.finalValue = 19;
    //    //trendLine.lineColor = "#CC0000";
    //    //chart.addTrendLine(trendLine);

    //    //// second trend line
    //    //trendLine = new AmCharts.TrendLine();
    //    //trendLine.initialDate = new Date(2012, 0, 17, 12);
    //    //trendLine.finalDate = new Date(2012, 0, 22, 12);
    //    //trendLine.initialValue = 16;
    //    //trendLine.finalValue = 10;
    //    //trendLine.lineColor = "#CC0000";
    //    //chart.addTrendLine(trendLine);

    //    // WRITE
    //    chart.write("chartdiv");
    //});

    AmCharts.ready(function () {
        // SERIAL CHART
        chart = new AmCharts.AmSerialChart();
        chart.dataProvider = chartData;
        chart.categoryField = "date";
        // the following two lines makes chart 3D
        chart.depth3D = 1;
        chart.angle = 30;
        chart.startDuration = 1;

        // AXES
        // category
        var categoryAxis = chart.categoryAxis;
        //categoryAxis.labelRotation = 90;
        categoryAxis.dashLength = 5;
        categoryAxis.gridPosition = "start";

        // value
        var valueAxis = new AmCharts.ValueAxis();
        valueAxis.title = "营业额(元)";
        valueAxis.dashLength = 5;
        chart.addValueAxis(valueAxis);

        // GRAPH
        var graph = new AmCharts.AmGraph();
        graph.valueField = "value";
        graph.colorField = "color";
        graph.balloonText = "<span style='font-size:14px'>[[category]]: <b>[[value]]</b></span>";
        graph.labelText = "[[value]] 元";
        graph.type = "column";
        graph.lineAlpha = 0;
        graph.fillAlphas = 1;
        graph.lineColor = "#3D96C9";
        chart.addGraph(graph);

        // CURSOR
        var chartCursor = new AmCharts.ChartCursor();
        chartCursor.cursorAlpha = 0;
        chartCursor.zoomable = false;
        chartCursor.categoryBalloonEnabled = false;
        chart.addChartCursor(chartCursor);

        chart.creditsPosition = "top-right";
        chart.export = {
            "enabled": true
        };

        // WRITE
        chart.write("chartdiv");
    });

    </script>

</form>
</body>
</html>

