﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="material_cost_list.aspx.cs" Inherits="VA.Modules.JDingCYT.leaderquery.material_cost_list" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>店长查询/配料消耗</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/editlist_s.aspx"--> 
    <script type="text/javascript">

        //消耗明细；
        function viewDetail(itemCode, itemName) {
            var $txtBeginDate = $("#txtBeginDate");
            var $txtEndDate = $("#txtEndDate");

            var beginDate = $txtBeginDate.val();
            var endDate = $txtEndDate.val();

            itemName = itemName.replace(/{单引号}/g, "'");
            itemName = itemName.replace(/{双引号}/g, "\"");
            openTopestWindow("配料消耗明细(" + itemName + ")", "/modules/cyt/leaderquery/material_cost_detail_list.aspx?searchfield=2&keywords=" + itemCode + "&begindate="+ beginDate +"&enddate="+ endDate + "&issearch=1");
        }

        //设置日期检索条件控件的行为；
        function setDateControlBehavior() {
            var $ddlDate = $("#ddlDateRule");
            if ($ddlDate.length == 0) {
                return;
            }

            if ($ddlDate.val() != "3") {
                $("#txtBeginDate").attr("disabled", "disabled");
                $("#txtEndDate").attr("disabled", "disabled");
            }
            $ddlDate.change(function () {
                var $txtBeginDate = $("#txtBeginDate");
                var $txtEndDate = $("#txtEndDate");
                var beginDate = null;
                var endDate = null;
                var sBeginDate = null;
                var sEndDate = null;

                var myDate = new Date();

                var dateRule = $ddlDate.val();
                if (dateRule == "1") { //上月          
                    var preMonth_today = myDate.dateAdd("m", -1);                    
                    var preMonth_year = preMonth_today.getFullYear();
                    var preMonth_month = preMonth_today.getMonth();                   
                    var thisMonth_today = myDate;
                    var thisMonth_year = myDate.getFullYear();
                    var thisMonth_month = myDate.getMonth();
                    var thisMonth_firstDay = new Date(thisMonth_year, thisMonth_month, 1);
                    beginDate = new Date(preMonth_year, preMonth_month, 1);
                    endDate = thisMonth_firstDay.dateAdd("d", -1); 
                }
                else if (dateRule == "2") { //本月          
                    var thisMonth_today = myDate;
                    var thisMonth_year = myDate.getFullYear();
                    var thisMonth_month = myDate.getMonth();
                    beginDate = new Date(thisMonth_year, thisMonth_month, 1);
                    endDate = myDate;
                }
                else if (dateRule == "3") { //自定义
                    beginDate = myDate;
                    endDate = myDate;
                    $("#txtBeginDate").removeAttr("disabled");
                    $("#txtEndDate").removeAttr("disabled");
                }

                sBeginDate = beginDate.format("yyyy-MM-dd");
                sEndDate = endDate.format("yyyy-MM-dd");

                $txtBeginDate.val(sBeginDate);
                $txtEndDate.val(sEndDate);

                if (dateRule == "3") { //自定义
                    //$("#txtBeginDate").val("");
                    $("#txtEndDate").val("");
                }

                $("#btnSearch").click();
            });
        }

        $(function () {
            initListPage();
            setDateControlBehavior();
        });

    </script>

</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">        
    
    <div id="toolBar">                          
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>                   
    </div><!--toolBar.END-->    

    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>        

        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="">统计期间</asp:ListItem>
        <asp:ListItem Value="1">上月</asp:ListItem>
        <asp:ListItem Value="2" Selected="True">本月</asp:ListItem>
        <asp:ListItem Value="3">自定义</asp:ListItem>
        </asp:DropDownList>   

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />      

        <asp:DropDownList ID="ddlOrderBy" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlOrderBy_SelectedIndexChanged">
        <asp:ListItem Value="">排序规则</asp:ListItem>            
        <asp:ListItem Value="Item_Code|ASC">按项目代码</asp:ListItem>        
        <asp:ListItem Value="Item_Name|ASC">按项目名称</asp:ListItem>        
        </asp:DropDownList> 
         
        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div>             

    <div id="dataBar" style="margin-top:-1px;">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;">No.</td>
        <td style="width:60px;text-align:center;">项目代码</td>
        <td style="width:180px;text-align:center;">项目名称</td>
        <td style="width:50px;text-align:center;">单位</td>	    
        <td style="width:80px;text-align:center;">消耗数量</td>   
        <td style="width:80px;text-align:center;">消耗金额</td>        
        <td style="width:70px;text-align:center;">消耗明细</td>       
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td align="center"><%# Container.ItemIndex + 1%></td>
        <td align="center"><%# Eval("Item_Code")%></td>
        <td align="left"><%# Eval("Item_Name")%></td>
        <td align="center"><%# Eval("Unit")%></td>        
        <td align="right"><%# Convert.ToDecimal(Eval("TotalQuantity")).ToString("F2")%></td>                
        <td align="right"><%# Convert.ToDecimal(Eval("TotalAmount")).ToString("F2")%></td>                
        <td align="center"><a href="javascript:viewDetail('<%# Eval("Item_Code")%>','<%# Eval("Item_Name").ToString().Replace("'", "{单引号}").Replace("\"", "{双引号}")%>')">[查看]</a></td>
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    <% if (base.TotalAmount > 0) { %>
    <tr>
        <td align="right" colspan="5"><b>合计：</b></td>
        <td align="right"><b><% = base.TotalAmount.ToString("F2") %></b></td>                
        <td align="right"></td>                
        <td></td>
    </tr>
    <%} %>
    </table>
    </div><!--bodyContainer.END-->        

    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

</div>

</form>
</body>
</html> 