﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="comment_quality_myd.aspx.cs" Inherits="VA.Modules.JDingCYT.leaderquery.comment_quality_myd" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>菜品满意度</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/editlist_s.aspx"--> 
    <script type="text/javascript">

        //顾客点评明细；
        function viewDetail(itemCode, itemName) {
            itemName = itemName.replace(/{单引号}/g, "'");
            itemName = itemName.replace(/{双引号}/g, "\"");
            var beginDate = $("#txtBeginDate").val();
            var endDate = $("#txtEndDate").val();
            openTopestWindow("顾客点评明细(" + itemName + ")", "/modules/cyt/leaderquery/comment_list.aspx?searchfield=1&keywords=" + itemCode + "&begindate="+ beginDate +"&enddate="+ endDate +"&issearch=1");
        }

        //设置日期检索条件控件的行为；
        function setDateControlBehavior() {
            var $ddlDate = $("#ddlDateRule");
            if ($ddlDate.length == 0) {
                return;
            }

            if ($ddlDate.val() != "3") {
                $("#txtBeginDate").attr("disabled", "disabled");
                $("#txtEndDate").attr("disabled", "disabled");
            }
            $ddlDate.change(function () {
                var $txtBeginDate = $("#txtBeginDate");
                var $txtEndDate = $("#txtEndDate");
                var beginDate = null;
                var endDate = null;
                var sBeginDate = null;
                var sEndDate = null;

                var myDate = new Date();

                var dateRule = $ddlDate.val();
                if (dateRule == "1") { //上月          
                    var preMonth_today = myDate.dateAdd("m", -1);                    
                    var preMonth_year = preMonth_today.getFullYear();
                    var preMonth_month = preMonth_today.getMonth();                   
                    var thisMonth_today = myDate;
                    var thisMonth_year = myDate.getFullYear();
                    var thisMonth_month = myDate.getMonth();
                    var thisMonth_firstDay = new Date(thisMonth_year, thisMonth_month, 1);
                    beginDate = new Date(preMonth_year, preMonth_month, 1);
                    endDate = thisMonth_firstDay.dateAdd("d", -1); 
                }
                else if (dateRule == "2") { //本月          
                    var thisMonth_today = myDate;
                    var thisMonth_year = myDate.getFullYear();
                    var thisMonth_month = myDate.getMonth();
                    beginDate = new Date(thisMonth_year, thisMonth_month, 1);
                    endDate = myDate;
                }
                else if (dateRule == "3") { //自定义
                    beginDate = myDate;
                    endDate = myDate;
                    $("#txtBeginDate").removeAttr("disabled");
                    $("#txtEndDate").removeAttr("disabled");
                }

                sBeginDate = beginDate.format("yyyy-MM-dd");
                sEndDate = endDate.format("yyyy-MM-dd");

                $txtBeginDate.val(sBeginDate);
                $txtEndDate.val(sEndDate);

                if (dateRule == "3") { //自定义
                    //$("#txtBeginDate").val("");
                    $("#txtEndDate").val("");
                }

                $("#btnSearch").click();
            });
        }

        $(function () {
            initListPage([30, 60, 80, 60, 60, 60, 60, 70, 70, 70, ""]);
            setDateControlBehavior();
        });

    </script>

</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">   

    <div id="titleBar">
        <h1>菜品味道满意度</h1>
    </div>      
    
    <div id="toolBar">                          
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>                   
    </div><!--toolBar.END-->    

    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>        

        <asp:DropDownList ID="ddlCategory" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlCategory_SelectedIndexChanged">           
        </asp:DropDownList>

        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="">统计期间</asp:ListItem>
        <asp:ListItem Value="1" >上月</asp:ListItem>
        <asp:ListItem Value="2" Selected="True">本月</asp:ListItem>
        <asp:ListItem Value="3">自定义</asp:ListItem>
        </asp:DropDownList>   

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />      

        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div>             

    <div id="dataBar" style="margin-top:-1px;">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;" rowspan="2">No.</td>
        <td style="width:60px;text-align:center;" rowspan="2">项目代码</td>
        <td style="width:80px;text-align:center;" rowspan="2">项目名称</td>
        <td style="text-align:center;" colspan="2">满意</td>
        <td style="text-align:center;" colspan="2">一般</td>
	    <td style="text-align:center;" colspan="2">不满意</td>
        <td style="width:70px;text-align:center;" rowspan="2">点评明细</td>       
        <td></td>
    </tr>    
    <tr>
        <td style="width:60px;text-align:center;">比例</td>
        <td style="width:60px;text-align:center;">人次</td>
        <td style="width:60px;text-align:center;">比例</td>
        <td style="width:60px;text-align:center;">人次</td>
	    <td style="width:70px;text-align:center;">比例</td>
        <td style="width:70px;text-align:center;">人次</td>
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td align="center"><%# Container.ItemIndex + 1%></td>
        <td align="center"><%# Eval("Item_Code")%></td>
        <td align="left"><%# Eval("Item_Name")%></td>
        <td align="center"><%# Convert.ToDecimal(Eval("AP")).ToString("P2")%></td>
        <td align="center"><%# Eval("A")%></td>
        <td align="center"><%# Convert.ToDecimal(Eval("BP")).ToString("P2")%></td>
        <td align="center"><%# Eval("B")%></td>
        <td align="center"><%# Convert.ToDecimal(Eval("CP")).ToString("P2")%></td>
        <td align="center"><%# Eval("C")%></td>
        <td align="center"><a href="javascript:viewDetail('<%# Eval("Item_Code")%>','<%# Eval("Item_Name").ToString().Replace("'", "{单引号}").Replace("\"", "{双引号}")%>')">[查看]</a></td>
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

</div>

</form>
</body>
</html> 