﻿<%--<%@ Page Language="C#" %>--%>
<%@ Import Namespace="VA.Modules.JDingCYT.Core.Business" %>
<%@ Import Namespace="VA.Modules.JDingCYT.Core.Model" %>
        <script type="text/javascript">    
        function loadMemberInfo(key, keyType) {

            clearMemberInfo();

            $("#ddlKeyType").val(keyType);
            $("#txtKey").val(key);

            $.ajax({
                type: "GET",
                url: "/modules/cyt/member/datasrc/get_memberinfo.aspx",
                dataType: "html",
                data: { "key": key, "keyType": keyType },
                success: function (data, textStatus) {
                    if (data != "error") {
                        if (data == "") {
                            alert("没有对应的会员记录，请检查输入是否正确！");

                            try
                            {
                                doWhenMemberInfoLoadFail();
                            }
                            catch (e) { alert(e); }
                        } else if (data == "MANYROWS"){
                            browseMembers(keyType, key);
                        } else {
                            var memberInfo = JSON.parse(data);
                            
                            $("#hfName").val(memberInfo.name);
                            $("#hfMemberID").val(memberInfo.memberID);
                            $("#hfCardNo").val(memberInfo.cardno);
                            $("#hfMobileNo").val(memberInfo.mobileno);
                            $("#hfLevelCode").val(memberInfo.levelcode);
                            $("#lblName").html(memberInfo.name);
                            $("#lblCardNo").html(memberInfo.cardno);
                            $("#lblMobileNo").html(memberInfo.mobileno);                            
                            $("#lblAccountBalance").html(memberInfo.accountbalance);
                            $("#lblLevelName").html(memberInfo.levelname);
                            $("#lblCreateDate").html(memberInfo.createdate);
                            $("#lblPoints").html(memberInfo.points);
                            $("#lblStatus").html(memberInfo.statusname);
                            
                            try
                            {
                                doWhenMemberInfoLoadSuc(memberInfo);
                            }
                            catch (e) { alert(e); }
                        }
                    }
                    else {
                        showActResult("获取会员信息失败！", false);
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showActResult("请求失败！textStatus :" + textStatus, false);
                }
            });
        }

        function browseMembers(keyType, keyValue) {
            $('#winMemberList').css("display", "block");
            $('#winMemberList').window({
                width: 730,
                height: 419,
                modal: true,
                minimizable: false,
                collapsible: false,
                title: '会员列表'
            });

            if (keyType == "cardno") {
                keyType = "1";
            }
            else if (keyType == "mobileno") {
                keyType = "2";
            }

            $('#winMemberList').html("<iframe src='../member/datasrc/get_memberlist.aspx?searchfield="+ keyType +"&keywords="+ keyValue +"' style='width:100%;height:100%;border:0px;margin:0px;padding:0px;'  ></iframe>");
        }

        //关闭会员列表窗口；
        function closeMemberListWindow() {
            $('#winMemberList').window("close", true);
        }

        //从弹窗窗口中获取会员信息，并关闭弹出窗口
        function takeMemberInfo(trObj) {
            closeMemberListWindow();
            //var cardNo = trObj.cells[1].innerHTML;
            var cardNo = $(trObj).find("td.cardno").eq(0).html();
            $("#ddlKeyType").val("cardno");
            $("#txtKey").val(cardNo);
            loadMemberInfo(cardNo,"cardno");
        }

        //查看会员详情；
        function viewDetail(isSingleAct, winTitle, pageURL) {
            var memberID = $("#hfMemberID").val();
            var memberName = $("#hfName").val();
            if (memberID == "") {
                return;
            }
            var pageURL = "/modules/cyt/member/member_detail.aspx?memberid=" + memberID;
            var winTitle = "会员信息("+ memberName +")";
            try {
                if (window.top != window.self) {
                    window.top.addTab(winTitle, pageURL);
                }
                else {
                    window.location.href = pageURL;
                }
            } catch (e) { alert(e); }
        }

        function clearMemberInfo() {
            $("#ddlKeyType")[0].options[0].selected = true;
            $("#txtKey").val("");
            $("#hfName").val("");
            $("#hfMemberID").val("");
            $("#hfCardNo").val("");
            $("#hfMobileNo").val("");
            $("#hfLevelCode").val("");
            $("#lblName").html("");
            $("#lblCardNo").html("");
            $("#lblMobileNo").html("");
            $("#lblAccountBalance").html("");
            $("#lblLevelName").html("");
            $("#lblCreateDate").html("");
            $("#lblPoints").html("");
            $("#lblStatus").html("");
            
            $("#txtKey").focus();
        }

        function tryLoadMemberInfo(){
            var key = $("#txtKey").val();
            var keyType = $("#ddlKeyType").val();
            loadMemberInfo(key, keyType);
        }

        $(function () {
            $("#txtKey").focus();
            $("#txtKey").keydown(function (event) {
                if (event.keyCode == 13) {
                    tryLoadMemberInfo();

                    /*一般情况下，回车将直接触发提交事件，这里在回车后，return false一下，避免触发提交*/
                    return false;
                }
            });
        });
    </script>

<%
    //搞不明白，为什么这段代码放到 html 代码的后面就不能正确赋值？
        
    MemberBasicInfo memberInfo = null;
    string memberID = Request.QueryString["memberid"];
    if (!String.IsNullOrEmpty(memberID))
    {                   
        Member member = new Member();        
        memberInfo = member.GetEntity(memberID);
        if (!String.IsNullOrEmpty(memberInfo.MemberID))
        {        

            ddlKeyType.SelectedIndex = 0; //卡号；
            txtKey.Text = memberInfo.CardNo;

            hfName.Value = memberInfo.MemberName;
            hfMemberID.Value = memberInfo.MemberID;
            hfCardNo.Value = memberInfo.CardNo;
            hfMobileNo.Value = memberInfo.MobileNo;

            lblName.Text = memberInfo.MemberName;
            lblCardNo.Text = memberInfo.CardNo;
            lblMobileNo.Text = memberInfo.MobileNo;
            lblAccountBalance.Text = memberInfo.Account_Balance.ToString("F4");
            
            if (!new VA.Modules.JDingCYT.Core.Business.MemberAccountGuard().CheckAccountBalance(memberID, memberInfo.Account_Balance, memberInfo.AccountBalance_Verification_Code, base.SystemConfig))
            {
                lblAccountBalance.Text += "<font color='red'>(异常)</font>";
            }                
            
            try
            {
                lblLevelName.Text = new VA.Modules.JDingCYT.Core.Business.Basic.MemberLevelDict().GetEntity(memberInfo.Level_Code).Level_Name;
            }
            catch
            {
                lblLevelName.Text = "读取失败……";
            }
            lblCreateDate.Text = memberInfo.Create_Date.ToString("yyyy-MM-dd", System.Globalization.CultureInfo.InvariantCulture);
            lblPoints.Text = memberInfo.Account_Points.ToString();
            if (!new VA.Modules.JDingCYT.Core.Business.MemberAccountGuard().CheckAccountPoints(memberID, memberInfo.Account_Points, memberInfo.AccountPoints_Verification_Code, base.SystemConfig))
            {
                lblPoints.Text += "<font color='red'>(异常)</font>";
            }

            lblStatus.Text = VA.Modules.JDingCYT.Core.Enums.MemberStatusConverter.Convert_Value_ToText(memberInfo.Status);                         
        }                                   
    }      
   
%>
    
<table id="tbKeyEnter" cellspacing="0" cellpadding="3" class="editTable">
<tr>
<td>        
    
    <asp:DropDownList ID="ddlKeyType" Runat="server" Width="104px" >
    <asp:ListItem Value="cardno" Selected="True">会员卡号</asp:ListItem>
    <asp:ListItem Value="mobileno">手机号</asp:ListItem>    
    </asp:DropDownList>
    <VACTL:TextBox ID="txtKey" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="150px"
            />        
    <asp:HiddenField runat="server" id="hfName" />
    <asp:HiddenField runat="server" id="hfMemberID" />
    <asp:HiddenField runat="server" id="hfCardNo" />
    <asp:HiddenField runat="server" id="hfMobileNo" />
    <asp:HiddenField runat="server" id="hfLevelCode" />
    <input type="button" id="btnQueryMemberInfo" class="simpleBtn" onclick="tryLoadMemberInfo()" value="确定" />     
    <input type="button" id="btnBrowseMembers" class="simpleBtn" onclick="browseMembers('','')" value="浏览" />    
</td>
</tr>
</table>

<table id="tbMemberInfo" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">姓名：</td>
<td style="width:120px;">
    <asp:Label ID="lblName" runat="server"></asp:Label>
</td>
<td class="th">会员卡号：</td>
<td style="width:120px;">
    <asp:Label ID="lblCardNo" runat="server"></asp:Label>
</td>
<td class="th">手机号：</td>
<td>
    <asp:Label ID="lblMobileNo" runat="server"></asp:Label>
</td>
</tr>
<tr>
<td class="th">钱包余额：</td>
<td>
    <asp:Label ID="lblAccountBalance" runat="server"></asp:Label>
</td>
<td class="th">会员级别：</td>
<td>
    <asp:Label ID="lblLevelName" runat="server"></asp:Label>
</td>
<td class="th">办卡日期：</td>
<td>
    <asp:Label ID="lblCreateDate" runat="server"></asp:Label>
</td>
</tr>
<tr>
<td class="th">会员积分：</td>
<td>
    <asp:Label ID="lblPoints" runat="server"></asp:Label>
</td>
<td class="th">会员状态：</td>
<td>
    <asp:Label ID="lblStatus" runat="server"></asp:Label>
</td>
<td class="th">会员详情：</td>
<td>
    <a href="javascript:viewDetail()">点此查看</a>
</td>
</tr>
</table>

<!--会员列表窗口-->
<div id="winMemberList" style="display:none;"></div> 
