﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_view.aspx.cs" Inherits="VA.Modules.JDingCYT.hc.order_view" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/tabs.css" type="text/css" rel="Stylesheet" />
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/accordion.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->          
    <script type="text/javascript">

    function finish() {
        postRequest("finish");
    }

    function cxFinish() {
        postRequest("cxfinish");
    }

    function postRequest(cmdName) {

        var requestType = "POST";
        var url = pageName + "?act=" + cmdName;  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();

        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("操作成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("操作失败：" + data, false, doAfterAdd);
            }
        };

        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            $("#btnFinish").attr("disabled", "disabled");
            $("#btnCxFinish").attr("disabled", "disabled");

            window.parent.reloadOrders();
            window.parent.reloadRemindMsgs();

            if ($("#ckbAutoNext")[0].checked) {
                showNextOrder();
            }
        }
    }

    function showNextOrder() {
        var currOrderNo = $("#hfKey").val();
        var requestType = "POST";
        var url = pageName + "?act=getnextorder";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();

        var successFN = function (data, textStatus) {
            if (data != "") {
                nextOrderNo = data;
                window.location.href = pageName + "?orderno=" + nextOrderNo;
            }
        };

        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function printOrder() {
        var orderNo = $("#hfKey").val();
        printBill("10", orderNo);
    }

    function changeHistory() {
        var orderNo = $("#hfKey").val();
        openFrameWindow("变更记录", 700, 450, "../mainbiz/order_change_list.aspx?orderno=" + orderNo, false);
    }

    $(function () {
        var sqlCondition = window.localStorage.getItem("SQLCondition");
        $("#hfSQLCondition").val(sqlCondition);
    });

    </script>

    <script type="text/javascript">

        var formEditListTable_RowCounter = 0;

        function formEditListTable_addRow(itemType, itemCode, itemName, unit, price, quantity, zuofa, donateFlag) {

            formEditListTable_RowCounter++;

            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
            if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
                return;
            }

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;

            itemName = itemName.replace(/'/g, "‘");
            unit = unit.replace(/'/g, "‘");

            var amount = (price * quantity).toFixed(2).toString(); //优惠前金额

            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td style="text-align:center;display:none;">';
            rowHtml += '<span>' + itemCode + '</span>';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:left;padding-left:5px;">';
            rowHtml += '<span>' + itemName + '</span>';
            rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
            rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
            rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + unit + '</span>';
            rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;display:none;">';
            rowHtml += '<span style="font-weight:bold;">' + price + '</span>';
            rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" readonly="readonly" /></td>';

            rowHtml += '<td style="text-align:right;padding-right:1px;">';
            rowHtml += '<span style="font-weight:bold;" id="spanAmount_' + rowID + '">' + amount + '</span>';
            rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>'+ zuofa +'</span';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            if (donateFlag == "1") {
                rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" checked="checked" disabled="disabled" />';
            } else {
                rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" disabled="disabled" />';
            }
            rowHtml += '<input type="hidden" name="hfDonate" value="' + donateFlag + '" id="hfDonate_' + rowID + '" />';
            rowHtml += '</td>';
            rowHtml += '</tr>';

            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
            formEditListTable_hideTbNoRecord();
        }

        function formEditListTable_setTotalAmount() {
            var $srcTable = $("#srcTable");
            $srcTable.find("#trTotal").remove();

            var totalRowHtml = '';
            var totalAmount = 0.00;
            //var $hfAmountList = $srcTable.find("input[name=hfAmount]");
            var dataRows = $srcTable.find("tr[id]");

            dataRows.each(function () {
                var $hfAmount = $(this).find("input[name=hfAmount]").eq(0);
                var $hfCkbDonate = $(this).find("input[name=ckbDonate]").eq(0);

                if (!$hfCkbDonate[0].checked) {
                    totalAmount += parseFloat($hfAmount.val());
                }
            });

            //$hfAmountList.each(function () {
            //    totalAmount += parseFloat($(this).val());
            //});

            //if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
            if (dataRows.length > 0) {  //如果有数据行，则添加合计行
                totalRowHtml += '<tr id="trTotal">';

                totalRowHtml += '<td colspan="4" style="text-align:right;padding-right:5px;font-weight:bold;">合计</td>';

                totalRowHtml += '<td style="text-align:right;padding-right:1px;">';
                totalRowHtml += '<span style="font-weight:bold;" id="spanTotalAmount">' + totalAmount.toFixed(2).toString() + '</span>';
                totalRowHtml += '<input type="hidden" name="hfTotalAmount" value="' + totalAmount.toString() + '" id="hfTotalAmount" />';
                totalRowHtml += '</td>';

                totalRowHtml += '<td></td>';
                totalRowHtml += '<td></td>';

                totalRowHtml += '</tr>';

                $srcTable.append($(totalRowHtml));

                $("#hfTotalAmount").val(totalAmount.toFixed(2).toString());

            } else {
                $("#hfTotalAmount").val("");
            }
        }

        function formEditListTable_caculateAmount(rowID) {
            var $txtQuantity = $("#txtQuantity_" + rowID);
            var $txtPrice = $("#hfPrice_" + rowID);
            var $spanDiscount = "";
            var sQuantity = $txtQuantity.val();
            var sPrice = $txtPrice.val();
            var amount = 0.00; //优惠前

            if (sQuantity == "") {
                sQuantity = "0";
            }
            if (sPrice == "") {
                sPrice = "0";
            }

            ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
            //clearNoNum($txtQuantity[0]);
            //clearNoNum($txtPrice[0]);

            if (isNaN(sQuantity)) {
                alert("数量为无效数字！");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (isNaN(sPrice)) {
                alert("单价为无效数字.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }
            if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) < 0) {  //限制数量不能超过100000
                alert("数量不能小于0或超过100000.");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
                alert("单价不能小于0或超过100000.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if ($txtQuantity.hasClass("error")) {
                $txtQuantity.removeClass("error");
            }
            if ($txtPrice.hasClass("error")) {
                $txtPrice.removeClass("error");
            }

            amount = parseFloat(sQuantity) * parseFloat(sPrice);

            $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
            $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

            formEditListTable_setTotalAmount();
        }

        //做法============================================

        function formEditListTable_processZuofaText(rowID) {
            var $txtZuofa = $("#txtZuofa_" + rowID);
            var zuofa = $txtZuofa.val();
            zuofa = zuofa.replace(/,/g, "，");
            $txtZuofa.val(zuofa);
        }

        var $current_txtZuofa = null;
        function takeZuofa(rowID) {
            var $txtZuofa = $("#txtZuofa_" + rowID);
            $current_txtZuofa = $txtZuofa;
            openFrameWindow("做法列表", 530, 419, "../datasrc/get_foodmakeway_list.aspx?callback=takeZuofaCallback");
        }
        function takeZuofaCallback(trObj) {
            closeFrameWindow();
            var zuofa = $(trObj).find("td.zuofa").eq(0).html();
            $current_txtZuofa.val(zuofa);
        }

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<%--<div id="noteBar">                          
    <p>注：此处只显示需要后厨加工的项目，酒水类等不需要后厨加工的项目不在此显示。</p>
</div><!--toolBar.END--> --%>

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:600px;float:left;">

<div class="centerFormTitle">
   <h1><% = base.orderInfo.Table_No %>号台菜单</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">餐 台 号：</td>
<td style="width:200px">
    <% = base.orderInfo.Table_No %>
</td>
<td class="th">就餐人数：</td>
<td style="width:200px">
    <% = base.orderInfo.Customer_Quantity %>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">消费清单</td>
</tr>
</table>
<div class="formEditListTableWrapper" style="min-height:350px;">
<table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:70px;text-align:center;display:none;">项目代码</td>
<td style="width:250px;text-align:center;">品名</td>
<td style="width:40px;text-align:center;">单位</td>
<%--<td style="width:50px;text-align:center;">单价</td>--%>    
<td style="width:40px;text-align:center;">数量</td>
<td style="width:60px;text-align:center;">金额</td>
<td style="text-align:center;">做法</td>
<td style="width:30px;text-align:center;">赠送</td>
</tr>    
</thead>    

<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" style="margin-top:-1px;width:100%;">
<tr>
<td style="text-align:center;height:319px;font-size:14px;">
    暂无数据
</td>
</tr>
</table>
</div><!--formEditListTableWrapper.END-->

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">服务员：</td>
<td style="width:200px">
    <% = base.orderInfo.Waiter_Name %>
</td>
<td class="th">备注：</td>
<td style="width:200px">
    <% = base.orderInfo.Remark %>
</td>
</tr>
<tr>
<td class="th">下单时间：</td>
<td style="width:200px">
    <% = base.orderInfo.Order_Date.ToString("yyyy-MM-dd hh:mm") %>
</td>
<td class="th">下单人：</td>
<td style="width:200px">
    <% = base.orderInfo.OrderMan_Name %>
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnPrint" class="btn" style="width:80px" onclick="printOrder()" value="打印" />
    <input type="button" id="btnChangeHistory" class="btn" onclick="changeHistory()" value="变更记录" />   
    <input type="button" id="btnFinish" runat="server" class="btn" style="width:80px" onclick="finish()" value="完成" />    
    <asp:CheckBox ID="ckbAutoNext" runat="server" Text="完成后自动切换到下个单子" Checked="true" />
    <input type="button" id="btnCxFinish" runat="server" class="btn" style="width:80px" onclick="cxFinish()" value="撤销完成" />    
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfSQLCondition" runat="server" />
  
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<% if (base.orderInfo != null){ %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.MainBiz.OrderItemInfo item in base.orderInfo.OrderItems)
    {
        string itemType = item.Item_Type;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        string zuofa = item.Zuofa.Replace(",","，").Replace("\"","“").Replace("\'","‘");
        string donateFlag = item.Donate_Flag;
        string isBackProcess = item.Is_BackProcess;
        //if (isBackProcess == "1")
        //{
            Response.Write("{");
            Response.Write("\"itemType\":\"" + itemType + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\",\"zuofa\":\"" + zuofa + "\",\"donateFlag\":\"" + donateFlag + "\"");

            if (i == base.orderInfo.OrderItems.Count - 1)
                Response.Write("}");
            else
                Response.Write("},");

            i++;
        //}
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    for (var i = 0; i < itemList.length; i++) {
        formEditListTable_addRow(
        itemList[i].itemType,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity,
        itemList[i].zuofa,
        itemList[i].donateFlag);
    }
</script>

<% } %>

</form>
</body>
</html>

