﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using VA.Utils;
using VA.Modules.JDingCYT.Core.Business.Goods;
using VA.Modules.JDingCYT.Core.Config;
using VA.Modules.JDingCYT.Core.Model.Goods;
using VA.Modules.JDingCYT.WebBase;
using System.Data;

namespace VA.Modules.JDingCYT.goods
{
    public partial class uc_chargeitem_book : System.Web.UI.UserControl
    {
        public string ShopCode
        {
            get;
            set;
        }

        public int MainHeight
        {
            get { return _MainHeight; }
            set { _MainHeight = value; }
        }
        int _MainHeight = 400;

        ChargeItemCategoryDict category = new ChargeItemCategoryDict();
        ChargeItemDict chargeItem = new ChargeItemDict();

        DataTable dtbCategoryAll;
        DataTable dtbChargeItemAll;
        
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                this.dtbCategoryAll = category.GetDataList("Status='" + Core.Enums.ChargeItemCategoryStatus.Enabled.ToString("d") + "' AND (Item_Type<>'" + Core.Enums.ChargeItemType.Food.ToString("d") + "' AND Item_Type<>'" + Core.Enums.ChargeItemType.ServiceItem.ToString("d") + "')", "Category_Code ASC");
                this.dtbChargeItemAll = chargeItem.GetDataList("Item_Type<>'" + Core.Enums.ChargeItemType.Food.ToString("d") + "' AND Item_Type<>'" + Core.Enums.ChargeItemType.ServiceItem.ToString("d") + "' AND Item_Code<>'" + Core.Enums.ConsumeCharge.SimpleConsumeCharge.ITEM_CODE + "' AND Item_Code<>'" + Core.Enums.ConsumeCharge.FreeDiscountItemInfo.ITEM_CODE + "' AND (Shop_Code='" + this.ShopCode + "' OR Shop_Code='" + Core.Enums.GlobalVariables.GLOBAL_SHOP_CODE + "') AND Status='" + Core.Enums.ChargeItemStatus.Enabled.ToString("d") + "'", "Input_Code ASC");

                this.rpChargeItemCategory.DataSource = this.dtbCategoryAll;
                this.rpChargeItemCategory.DataBind();
            }
        }

        protected void rpChargeItemCategory_ItemDataBound(object sender, System.Web.UI.WebControls.RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                Repeater rpChargeItemDict = (Repeater)e.Item.FindControl("rpChargeItemDict");

                //找到分类Repeater关联的数据项 
                DataRowView rowv = (DataRowView)e.Item.DataItem;

                //提取分类ID 
                string parentCode = rowv["Category_Code"].ToString();

                //从用户的所有节点权限集中筛选出数据该模块（模块ID为 moduleID ）的节点权限；
                if (this.dtbChargeItemAll != null)
                {
                    DataRow[] rows = this.dtbChargeItemAll.Select("Category_Code='" + parentCode + "'");
                    if (rows != null && rows.Length > 0)
                    {
                        DataTable dtbData = rows.CopyToDataTable();

                        rpChargeItemDict.DataSource = dtbData;
                        rpChargeItemDict.DataBind();
                    }
                }
            }
        }

        protected string ShowLetterIndex(string inputCode)
        {
            if (!String.IsNullOrEmpty(inputCode))
            {
                return inputCode.Substring(0, 1).ToUpper();
            }
            else
            {
                return "";
            }
        }
    }
}