﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="chargeitem_out.aspx.cs" Inherits="VA.Modules.JDingCYT.goods.chargeitem_out" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

        function confirm() {

            var classCode = $("#txtOutClass_hiddenValue").val();
            var supplierName = $("#txtSupplier").val();
            var supplierCode = $("#txtSupplier_hiddenValue").val();

            if (classCode == "02") { //返厂出库
                if (supplierCode == "" || supplierCode == "-9999") {
                    JTongAlert("提示", "当出库类型为‘返厂出库’时，收货对象不能为空，并且必须从列表中选择！", "warning");
                    return;
                }
            } else {
                if ($.trim(supplierName) == "") {
                    JTongAlert("提示", "收货对象不能为空！", "warning");
                    return;
                }
            }

            if (!formEditListTable_checkTableData()) {
                return;
            }

            var className = $("#txtOutClass").val();
            var supplierName = $("#txtSupplier").val();
            var billAmount = $("#hfTotalAmount").val();
            
            $("#span_Confirm_InClassName").html(className);
            $("#span_Confirm_SupplierName").html(supplierName);
            $("#span_Confirm_BillAmount").html(billAmount);            

            //title、width、height、left、top、divID
            openDivWindow("出库确认", 350, 358,180,116, "winConfirm");
            $("#btnSubmit").focus();
        }

        function cancelSave() {
            $('#winConfirm').window("close");
        }
    
        function save() {
                  
            $("#btnSubmit").attr("disabled", "disabled");

            var requestType = "POST";
            var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                var bizNo = "";
                if (data.substring(0, 2) == "ok") {
                    bizNo = data.split("|")[1];
                    showActResult("出库成功！", true, doAfterAdd, bizNo);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd, bizNo);
                }
                else {
                    showActResult("出库失败：" + data, false, doAfterAdd, bizNo);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        function doAfterAdd(actResult, bizNo) {
            if (actResult) {
                resetPage();
                cancelSave();
            }
        }

        //显示操作结果；
        function showActResult(sMsg, actResult, callback, bizNo) {

            $("#btnSubmit").removeAttr("disabled");

            var icon = "info";
            if (!actResult) {
                icon = "error";
            }

            JTongAlert('操作结果', sMsg, icon, function () {
                if (callback != null && callback != undefined) {
                    callback(actResult, bizNo);
                }
            });
        }

        function resetPage() {                    
            var newBillNo = ajaxGetData("chargeitem_get_newbillno.aspx?billtype=2", "html", null);
            $("#lblBillNo").html(newBillNo);
            $("#txtOutClass").val("");
            $("#txtOutClass_hiddenValue").val("");
            $("#txtSupplier").val("");
            $("#txtSupplier_hiddenValue").val("");
            $("#txtRemark").val("");        

            formEditListTable_clearRows();
            clearInputValidatorError();
        } 

        function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
            if (selectedRow != null) {

                if (JTongSmartDropDownList_inputObjID == "txtOutClass") {
                    var code = selectedRow.cells[0].innerHTML;
                    var name = selectedRow.cells[1].innerHTML;
                    var $txtSupplier = $("#txtSupplier");
                    var $txtSupplierCode = $("#txtSupplier_hiddenValue");

                    $txtSupplier.val("");
                    $txtSupplierCode.val("");
                    
                    if (code == "02") { //返厂出库
                        $txtSupplier.attr("onfocus", "JTongSmartDropDownList_OnfocusHandler(this, 'get_chargeitem_suppliers.aspx',true,true,310,180)");
                    } else {
                        $txtSupplier.removeAttr("onfocus");
                        $txtSupplier.val("本店");
                    }
                }
                else if (JTongSmartDropDownList_inputObjID == "txtItemName") {
                
                    var itemType = $(selectedRow.cells[0]).find("input:hidden[name=hfItemType]").eq(0).val();
                    var itemCategory = $(selectedRow.cells[0]).find("input:hidden[name=hfItemCategory]").eq(0).val();
                    var itemCode = selectedRow.cells[1].innerHTML;
                    var itemName = selectedRow.cells[2].innerHTML;
                    var unit = selectedRow.cells[3].innerHTML;
                    var quantity = 1.0;

                    $("#hfItemType").val(itemType);
                    $("#hfItemCategory").val(itemCategory);
                    $("#txtItemName").val(itemName);
                    $("#txtItemName_hiddenValue").val(itemCode);
                    $("#hfUnit").val(unit);
                    $("#txtQuantity").val(quantity);

                    $("#txtPrice").select();
                }
            }

            //返回true，继续取值；返回false，取消取值；
            return true;
        }

        function addItem() {
            var itemType = $("#hfItemType").val();
            var itemCategory = $("#hfItemCategory").val();
            var itemName = $("#txtItemName").val();
            var itemCode = $("#txtItemName_hiddenValue").val();
            var unit = $("#hfUnit").val();
            var quantity = $("#txtQuantity").val();
            var amount = $("#txtAmount").val();
            var price = $("#txtPrice").val();

            if ($.trim(price) == "") {
                price = 0;
            }
            if ($.trim(itemCode) == "" || itemCode == "-9999") {
                return;
            }
            if (unit == "" || quantity == "") {
                return;
            }

            addNewRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity);

            $("#txtItemName").val("");
            $("#txtItemName_hiddenValue").val("");
            $("#hfItemType").val("");
            $("#hfItemCategory").val("");
            $("#hfUnit").val("");
            $("#txtPrice").val("");
            $("#txtQuantity").val("");
            $("#txtAmount").val("");
            $("#txtItemName").focus();
        }

        function caculateItemAount() {
            var sPrice = $.trim($("#txtPrice").val());
            var sQuantity = $.trim($("#txtQuantity").val());
            var itemAmount = 0.00;
            if (sPrice != "" && sQuantity != "") {
                try
                {
                    itemAmount = parseFloat(sPrice) * parseFloat(sQuantity);
                    $("#txtAmount").val(itemAmount.toFixed(2).toString());
                }catch(e){}
            }
        }

        function addNewRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity) {
            formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity);
        }

        $(function () {
            
            $("#txtPrice").keyup(function (event) {
                if (event.keyCode != 13) {
                    caculateItemAount();
                }
            });
            $("#txtQuantity").keyup(function (event) {
                if (event.keyCode != 13) {
                    caculateItemAount();
                }
            });

            //焦点控制
            $("input").keydown(function (event) {
                if (event.keyCode == 13) {
                    var targetID = event.target.id;
                    switch (targetID) {
                        case "txtPrice":
                            if ($("#txtPrice").val() != "") {
                                $("#txtQuantity")[0].select();
                            }
                            break;
                        case "txtQuantity":
                            addItem();
                            break;                      
                        default:
                            break;
                    }
                    return false;
                }
            });

            ////如果页面中使用了SmartDropDownList控件，并且要求该控件在页面加载后第一个获取脚垫，
            ////那么应该将设置焦点的代码放到onload事件（而不是$(document.ready)）中，
            ////因为SmartDropDownList控件将js脚本封装到了WebResource.axd中，如果放到$(document.ready)中
            ////那么可能当 $("#txtInClass").focus() 执行的时候 WebResource.axd 尚未加载完毕，这是就会报错,
            ////所以应该放到onload事件中。
            //window.onload = function () {
            //    $("#txtItemName").focus();
            //};
        });

    </script>

    <script type="text/javascript">

        var formEditListTable_RowCounter = 0;

        function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity) {
            
            formEditListTable_RowCounter++;

            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
            if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
                return;
            }

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;

            itemName = itemName.replace(/'/g, "‘");
            unit = unit.replace(/'/g, "‘");

            var amount = price * quantity;

            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + itemCode + '</span>';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:left;padding-left:5px;">';
            rowHtml += '<span>' + itemName + '</span>';
            rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
            rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
            rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
            rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + unit + '</span>';
            rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
            rowHtml += '</td>';

            rowHtml += '<td><input type="text" name="txtPrice" value="' + price + '" id="txtPrice_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" /></td>';
            rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" ondblclick="takeQuantity(' + rowID + ')"/></td>';

            rowHtml += '<td style="text-align:right;padding-right:5px;">';
            rowHtml += '<span style="font-weight:bold;" id="spanAmount_' + rowID + '">' + amount + '</span>';
            rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';
            rowHtml += '</tr>';

            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
            formEditListTable_hideTbNoRecord();
        }

        function formEditListTable_setTotalAmount() {
            var $srcTable = $("#srcTable");
            $srcTable.find("#trTotal").remove();

            var totalRowHtml = '';
            var total = 0.00;
            var $hfAmountList = $srcTable.find("input[name=hfAmount]");

            $hfAmountList.each(function () {
                total += parseFloat($(this).val());
            });

            if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
                totalRowHtml += '<tr id="trTotal">';

                totalRowHtml += '<td colspan="6" style="text-align:right;padding-right:5px;font-weight:bold;">合计</td>';

                totalRowHtml += '<td style="text-align:right;padding-right:5px;">';
                totalRowHtml += '<span style="font-weight:bold;" id="spanTotalAmount">' + total.toFixed(2).toString() + '</span>';
                totalRowHtml += '<input type="hidden" name="hfTotalAmount" value="' + total.toFixed(2).toString() + '" id="hfTotalAmount" />';
                totalRowHtml += '</td>';

                totalRowHtml += '<td></td>';

                totalRowHtml += '</tr>';

                $srcTable.append($(totalRowHtml));
            } 
        }

        function formEditListTable_caculateAmount(rowID) {
            var $txtQuantity = $("#txtQuantity_" + rowID);
            var $txtPrice = $("#txtPrice_" + rowID);
            var sQuantity = $txtQuantity.val();
            var sPrice = $txtPrice.val();
            var amount = 0.00;

            if (sQuantity == "") {
                sQuantity = "0";
            }
            if (sPrice == "") {
                sPrice = "0";
            }

            ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
            //clearNoNum($txtQuantity[0]);
            //clearNoNum($txtPrice[0]);

            if (isNaN(sQuantity)) {
                alert("数量为无效数字！");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (isNaN(sPrice)) {
                alert("单价为无效数字.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if (parseFloat(sQuantity) > 100000) {  //限制数量不能超过100000
                alert("数量不能超过100000.");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (parseFloat(sPrice) > 100000) {  //单价不能超过100000
                alert("单价不能超过100000.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if ($txtQuantity.hasClass("error")) {
                $txtQuantity.removeClass("error");
            }
            if ($txtPrice.hasClass("error")) {
                $txtPrice.removeClass("error");
            }

            amount = parseFloat(sQuantity) * parseFloat(sPrice);

            $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
            $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

            formEditListTable_setTotalAmount();
        }

        function formEditListTable_checkTableData() {

            var result = true;

            var dataRowCount = 0;
            var $srcTable = $("#srcTable");

            $srcTable.find("input[name=txtQuantity]").each(function () {
                dataRowCount++;
                var sQuantity = $(this).val();
                if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                    JTongAlert("提示","数量不能为空或0！", "warning");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            $srcTable.find("input[name=txtPrice]").each(function () {
                var sPrice = $(this).val();
                if ($.trim(sPrice) == "") {
                    JTongAlert("提示", "单价不能为空！", "warning");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            if (dataRowCount == 0) {
                JTongAlert("提示","出库清单不能为空！", "warning");
                result = false;
            }

            return result;
        }

        function formEditListTable_clearNoNum(obj) {
            obj.value = obj.value.replace(/[^\d.]/g, "");  //清除“数字”和“.”以外的字符  
            obj.value = obj.value.replace(/^\./g, "");  //验证第一个字符是数字而不是. 
            obj.value = obj.value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的.   
            obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
        }

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1>商品出库</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-bottom:-1px;">
<tr>
<td style="font-weight:bold;text-align:right;">
    出库单号：<asp:Label ID="lblBillNo" runat="server"></asp:Label>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">(<span class="note mustfill">*</span>)出库类型：</td>
<td>
    <VACTL:TextBox ID="txtOutClass" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, 'get_chargeitem_outclass.aspx',true,true,310,180);"
                Width="153px"
                />
    <asp:HiddenField runat="server" id="txtOutClass_hiddenValue" />
</td>
<td class="th">(<span class="note mustfill">*</span>)收货对象：</td>
<td>
    <VACTL:TextBox ID="txtSupplier" Runat="server"
                EnableViewState="False"
                CssClass="input"
                Width="153px"
                />
    <asp:HiddenField runat="server" id="txtSupplier_hiddenValue" />
</td>
</tr>
<tr>
<td class="th">操作员：</td>
<td style="width:250px;">
    <% = base.EmployeeName %>
</td>
<td class="th">出库日期：</td>
<td>
    <% = DateTime.Now.ToString("yyyy-MM-dd", System.Globalization.CultureInfo.InvariantCulture) %>
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td colspan="3">
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="580px"
        MaxLength="100"
        />        
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">出库商品清单</td>
</tr>
</table>
<div class="formEditListTableWrapper" style="min-height:285px;">
<table cellspacing="0" class="formEditListTable" id="srcTable" style="width:700px;margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:70px;text-align:center;">代码</td>
<td style="width:300px;text-align:center;">品名</td>
<td style="width:50px;text-align:center;">单位</td>
<td style="width:50px;text-align:center;">单价</td>    
<td style="width:50px;text-align:center;">数量</td>
<td style="width:70px;text-align:center;">金额</td>
<td style="text-align:center;">操作</td>
</tr>    
</thead>    

<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" style="margin-top:-1px;width:100%;">
<tr>
<td style="text-align:center;height:200px;font-size:14px;">
    暂无数据
</td>
</tr>
</table>
</div>

<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:left;">
    商品：<VACTL:TextBox ID="txtItemName" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, 'get_chargeitem_forstockout.aspx',true,true,550,180);"
                Width="250px"
                />
    <asp:HiddenField runat="server" id="txtItemName_hiddenValue" />  

    <asp:HiddenField runat="server" id="hfItemType" />  
    <asp:HiddenField runat="server" id="hfItemCategory" />  
    <asp:HiddenField runat="server" id="hfUnit" />  

    单价：<VACTL:TextBox runat="server" ID="txtPrice" 
            CssClass="input" 
            Width="60px"
            CanBeNull="No"
            FieldName="单价"
            RequiredFieldType="Money"
            Text="0.00"
            />
    数量：<VACTL:TextBox runat="server" ID="txtQuantity" 
            CssClass="input" 
            Width="60px"
            CanBeNull="No"
            FieldName="数量"
            RequiredFieldType="Numeric"
            Text="0.00"
            />
    金额：<VACTL:TextBox runat="server" ID="txtAmount" 
            CssClass="input" 
            Width="60px"
            CanBeNull="No"
            FieldName="金额"
            RequiredFieldType="Money"
            Text="0.00"
            />
    <input type="button" id="btnAddItem" class="simpleBtn" onclick="addItem()" value="添加" />

</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnNext" class="btn" style="width:80px" onclick="confirm()" value="出库" />
    <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/controls/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<!--确认窗口-->    
<div id="winConfirm" style="display:none;">

    <div style="width:300px;margin:auto;">
    
    <br />

    <div class="centerFormTitle">
        <h1>确认出库信息</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;width:300px;">
    <tr>
    <td class="th">操 作 员：</td>
    <td>    
	    <span id="span_Confirm_OperatorName"><%= base.EmployeeName %></span>
    </td>
    </tr>
    <tr>
    <td class="th">出库日期：</td>
    <td>    
	    <span id="span1"><% = DateTime.Now.ToString("yyyy-MM-dd") %></span>
    </td>
    </tr>
    <tr>
    <td class="th">出库类型：</td>
    <td>    
	    <span id="span_Confirm_InClassName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">收货对象：</td>
    <td>    
        <span id="span_Confirm_SupplierName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">单据金额：</td>
    <td>   
        <span id="span_Confirm_BillAmount" style="font-weight:bold;"></span> 
    </td>
    </tr>   
    <tr>
    <td colspan="2" class="footer">

        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="确定" />
        <input type="button" id="btnCancel" class="btn" style="width:80px" onclick="cancelSave()" value="取消" />
       <%-- <asp:CheckBox ID="ckbPrintBill" runat="server"
             Text="打票" /> --%>
    </td>
    </tr>
    </table>
    </div>

</div><!--winConfirm.END-->

</form>
</body>
</html>

