﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="chargeitem_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.goods.chargeitem_edit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var commisionType = $("#ddlCommisionType").val();
        var commisionXS = $("#txtCommisionXS").val();
        var discount = $("#txtMemberDiscount").val();
        if (commisionType == "1") { //按比例计提

            if (parseInt(commisionXS) > 1) {
                JTongAlert("提示", "当提成类型为按比例计提时，提成系数不能大于1","info");
                return;
            }
        }
        if (discount != "") {
            if (parseFloat(discount) > 1) {
                JTongAlert("提示", "会员折扣不能大于1.", "info");
                return;
            }
        }

        var flag = "0";
        if ($("#hfKey").val() != "") {
            flag = "1";
        }

        if (flag == 0) {
            add();
        }
        else {
            update();
        }
    }

    function add() {
        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("添加成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("添加失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function update() {
        var requestType = "POST";
        var url = pageName + "?act=update";
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("修改成功！", true, doAfterUpdate);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterUpdate);
            }
            else {
                showActResult("修改失败：" + data, false, doAfterUpdate);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try{
                if (window.parent != window.self) {
                    window.parent.completeReload();
                }
            }catch(e){}
            resetPage();
        }
    }
    function doAfterUpdate(actResult) {
        if (actResult) {
            try{
                if (window.parent != window.self) {
                    window.parent.closeFrameWindow();
                    window.parent.completeReload();
                }
            }catch(e){}
        }
    }

    function resetPage() {

        var newItemCode = ajaxGetData("chargeitem_get_newitemcode.aspx", "html", null);
        $("#txtItemCode").val(newItemCode);
        $("#txtItemName").val("");
        $("#txtInputCode").val("");
        $("#txtUnit").val("");
        $("#txtUnit_hiddenValue").val("");
        $("#txtPrice").val("");
        $("#txtRemark").val("");
       
        clearInputValidatorError();

        $("#txtItemName").focus();
    }

    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtUnit") {
                $("#txtPrice").focus();
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    function ddlCommisionType_changeHandler() {
        var commisionType = $("#ddlCommisionType").val();
        if (commisionType == "0") { //不计提
            $("#txtCommisionXS").val("0");
            $("#txtCommisionXS").attr("disabled", "disabled");
        } else {
            $("#txtCommisionXS").removeAttr("disabled");
            $("#txtCommisionXS").select();
        }
    }

    function ddlCategory_changeHandler() {
        var selectedValue = $("#ddlCategory").val();
        var categoryCode = selectedValue.split("|")[0];
        var itemType = selectedValue.split("|")[1];
        if (itemType == "1") { //服务项目
            $("#ddlStockManage").val("0");
            $("#ddlStockManage").attr("disabled", "disabled");
        } else {
            $("#ddlStockManage").val("1");
            $("#ddlStockManage").removeAttr("disabled");
        }
    }

    function uploadImage() {
        openFrameWindow("上传图片", 500, 220, "chargeitem_edit_uploadpic.aspx", false);
    }

    function takeImage(thumpicFileName) {
        $("#txtItemImage").val(thumpicFileName);
        closeFrameWindow();
    }

    $(function () {
        $("#ddlCategory").focus();
        $("#txtItemName").keyup(function (event) {
            var itemName = $(this).val();
            if ($.trim(itemName) == "") {
                return;
            }
            if (event.keyCode != 13) {
                var requestType = "GET";
                var url = "../smartdropdownlist_datasrc/get_inputcode.aspx";
                var dataType = "html";
                var data = { keywords: itemName };
                var successFN = function (data, textStatus) {
                    $("#txtInputCode").val(data);
                };
                ajaxRequest(requestType,
                    url,
                    dataType,
                    data,
                    successFN,
                    errorFN
                    );
            }
        });

        $("#ddlCommisionType").change(function () {
            ddlCommisionType_changeHandler();
        });
        ddlCommisionType_changeHandler();

        $("#ddlCategory").change(function () {
            ddlCategory_changeHandler();
        });
        ddlCategory_changeHandler();

        //焦点控制
        //$("input:not(#txtUnit),select").keydown(function (event) {
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "ddlCategory":
                        $("#txtItemName").focus();
                        break;
                    case "txtItemCode":
                        $("#txtItemName").focus();
                        break;
                    case "txtItemName":
                        if ($("#txtItemName").val() != "") {
                            $("#txtUnit").focus();
                        }
                        break;                   
                    case "txtUnit":
                        if ($("#txtUnit").val() != "") {
                            $("#txtPrice").select();
                        }
                        break;
                    case "txtPrice":
                        if ($("#txtPrice").val() != "") {
                            $("#txtPurchasePrice").select();
                        }
                        break;
                    case "txtPurchasePrice":
                        if ($("#txtPurchasePrice").val() != "") {
                            $("#ddlCommisionType").focus();
                        }
                        break;
                    case "ddlCommisionType":
                        var commisionType = $("#ddlCommisionType").val();
                        if (commisionType == "0") { //不计提
                            $("#txtMemberDiscount").select();
                        } else {
                            $("#txtCommisionXS").select();
                        }                        
                        break;
                    case "txtCommisionXS":
                        $("#txtMemberDiscount").select();
                        break;
                    case "txtMemberDiscount":
                        $("#txtMemberPrice").select();
                        break;
                    case "txtMemberPrice":
                        $("#ddlStockManage").focus();
                        break;
                    case "ddlStockManage":
                        $("#txtMinLevelNumber").select();
                        break;
                    case "txtMinLevelNumber":
                        $("#txtRemark").select();
                        break;
                    case "txtRemark":
                        save();
                        break;
                    default:
                        break;
                }
            }
        });
    });

    </script>

    <style type="text/css">  
    .editTable .th{
        width:120px;
    }
    </style>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:650px;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">添加商品/项目</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr runat="server" visible="false">
<td class="th">(<span class="note mustfill">*</span>)项目类型：</td>
<td colspan="3">              
    <asp:DropDownList ID="ddlItemType" Runat="server" Width="104px" >          
    </asp:DropDownList>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server"
         ControlToValidate="ddlItemType"
         ErrorMessage="[项目类型]必须选择一项！" />       
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)所属分类：</td>
<td colspan="3">              
    <asp:DropDownList ID="ddlCategory" Runat="server" Width="104px" >    
    </asp:DropDownList>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server"
         ControlToValidate="ddlCategory"
         ErrorMessage="[所属分类]必须选择一项！" />
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)项目代码：</td>
<td colspan="3">              
    <VACTL:TextBox ID="txtItemCode" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="项目代码"            
            ReadOnly="true"
            MaxLength="10" />        
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)项目名称：</td>
<td>              
    <VACTL:TextBox ID="txtItemName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            CanBeNull="No"
            FieldName="项目名称"
            MaxLength="25" />        
</td>
<td class="th">(<span class="note mustfill">*</span>)输入码：</td>
<td>              
    <VACTL:TextBox ID="txtInputCode" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="输入码"
            MaxLength="30" />        
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)单位：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtUnit" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_units.aspx',true,true,310,180,0,true,'2',true);"
            Width="100px"
            CanBeNull="No"
            FieldName="单位"
            MaxLength="10" />
    <asp:HiddenField runat="server" id="txtUnit_hiddenValue" />
</td>
<td class="th">(<span class="note mustfill">*</span>)单价：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtPrice" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="单价"
            RequiredFieldType="Money"
            />
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)成本价：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtPurchasePrice" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="成本价"
            RequiredFieldType="Money"
            />
</td>
<td class="th">(<span class="note mustfill">*</span>)提成类型：</td>
<td>
    <asp:DropDownList ID="ddlCommisionType" Runat="server" 
         Width="104px" >    
        <asp:ListItem Value="0" Selected="True">不计提</asp:ListItem>
        <asp:ListItem Value="1">按比例计提</asp:ListItem>
        <asp:ListItem Value="2">按固定金额计提</asp:ListItem>
    </asp:DropDownList>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server"
         ControlToValidate="ddlCommisionType"
         Display="None"
         ErrorMessage="[提成类型]必须选择一项！" />
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)提成系数：</td>
<td colspan="3">              
     <VACTL:TextBox runat="server" ID="txtCommisionXS" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="提成系数"
            RequiredFieldType="Money"
            /> <span class="note">（填写小数，如：0.1表示按10%计提）</span>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)会员折扣：</td>
<td colspan="3">              
     <VACTL:TextBox runat="server" ID="txtMemberDiscount" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="会员折扣"
            RequiredFieldType="Money"
            MaximumValue="1"
            /> （填写小数，如：0.8表示8折）
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)会员价格：</td>
<td colspan="3">              
     <VACTL:TextBox runat="server" ID="txtMemberPrice" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="会员价格"
            RequiredFieldType="Money"
            Text="0"
            /> <span class="note">（如果设置了会员价格，则会员折扣无效，0表示使用会员折扣）</span>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)自动库存管理：</td>
<td colspan="3">
    <asp:DropDownList ID="ddlStockManage" Runat="server" 
         Width="104px" 
         >    
        <asp:ListItem Value="1" Selected="True">启用</asp:ListItem>
        <asp:ListItem Value="0">不启用</asp:ListItem>        
    </asp:DropDownList>   
    <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server"
         ControlToValidate="ddlStockManage"
         Display="None"
         ErrorMessage="[库存管理]必须选择一项！" />
    <span class="note">如果启用，则顾客消费结账时，系统自动扣减库存。</span>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)低位警戒线：</td>
<td colspan="3">
    <VACTL:TextBox runat="server" ID="txtMinLevelNumber" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="低位警戒线"
            RequiredFieldType="Money"
            MinimumValue="0"
            Text="0"
            /><%-- <span class="note">（如果库存低于该值，系统将进行提示）</span>--%>
</td>
</tr>
<tr>
<td class="th">图片：</td>
<td colspan="3">    
	<VACTL:TextBox ID="txtItemImage" Runat="server"
		    EnableViewState="False"
		    CssClass="input"
            Width="200px"
            MaxLength="100"  />	
    <input type="button" id="Button1" class="simpleBtn" onclick="uploadImage()" value="上传图片" />
</td>
</tr>
<tr id="Tr1" runat="server" visible="false">
<td class="th">(<span class="note mustfill">*</span>)营销支持：</td>
<td>
    <asp:DropDownList ID="ddlIsSupportSaleStrategy" Runat="server" Width="104px" >    
        <asp:ListItem Value="1" Selected="True">支持</asp:ListItem>
        <asp:ListItem Value="0">不支持</asp:ListItem>
    </asp:DropDownList>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server"
         ControlToValidate="ddlIsSupportSaleStrategy"
         ErrorMessage="[营销支持]必须选择一项！" />
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td colspan="3">               
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="487px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td colspan="4" class="footer">
    <% if (base.flag == 0) { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />
    <% } else { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <% } %>    
    
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfShopCode" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

