﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="chargeitem_donate_cx.aspx.cs" Inherits="VA.Modules.JTongMember.goods.chargeitem_donate_cx" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>商品/服务项目赠送冲销</title>
    <!--#include virtual="/include/css/edit.aspx"-->
    <!--#include virtual="/include/js/edit.aspx"-->     
    <script type="text/javascript">

    function save() {
            
        var donateType = $("#ddlDonateType").val();

        if (!formEditListTable_checkTableData()) {
            return;
        }

        JTongAlertConfirm("确定要冲销吗？", add);
    }

    function add() {

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("冲销成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("冲销失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {

            if ($("#ckbNotify")[0].checked == true) {
                ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "donatechargeitem", "bizno": bizNo });
            }

            resetPage();
        }
    }
    
    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {
        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function resetPage() {
        
        $("#txtBizNo").val("");        
        $("#txtRemark").val("");
        $("#txtItemName").val("");
        $("#txtItemName_hiddenValue").val("");
        $("#txtItemName_CustomParms").val("");

        $("#txtItemName").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnSubmit").attr("disabled", "disabled");

        formEditListTable_clearRows();

        clearMemberInfo();
    }

    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtItemName") {
                
                var itemType = selectedRow.cells[0].innerHTML;
                var itemCode = selectedRow.cells[1].innerHTML;
                var itemName = selectedRow.cells[2].innerHTML;
                var unit = selectedRow.cells[3].innerHTML;
                var price = selectedRow.cells[5].innerHTML;
                var quantity = 1;

                if (itemType == "服务") { //服务
                    itemType = "1";
                }
                else if (itemType == "商品") { //商品
                    itemType = "2";
                }

                formEditListTable_addRow(itemType, itemCode, itemName, unit, price,quantity);
                $("#txtItemName").val("");
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {
      
        $("#txtItemName").removeAttr("disabled");
        $("#txtRemark").removeAttr("disabled");
        $("#btnSubmit").removeAttr("disabled");
        $("#txtItemName_CustomParms").val("memberid=" + memberInfo.memberID);

        $("#txtItemName").focus();
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {

    }

    $(function () {        
        $("#txtItemName").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnSubmit").attr("disabled", "disabled");
    });

    </script>

    <script type="text/javascript">

        var formEditListTable_RowCounter = 0;

        function formEditListTable_addRow(itemType, itemCode, itemName, unit, price, quantity) {
            
            formEditListTable_RowCounter++;

            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
            if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
                return;
            }

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;

            itemName = itemName.replace(/'/g, "‘");
            unit = unit.replace(/'/g, "‘");
            
            var amount = price * quantity;

            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + itemCode + '</span>';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:left;padding-left:5px;">';
            rowHtml += '<span>' + itemName + '</span>';
            rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
            rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
            rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + unit + '</span>';
            rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
            rowHtml += '</td>';
            
            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice' + rowID + '" />';
            rowHtml += '<input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" />';
            rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';
            rowHtml += '</tr>';
            
            //调试代码；
            //$("#txtRemark").val(rowHtml);
            
            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
            formEditListTable_hideTbNoRecord();
        }

        function formEditListTable_setTotalAmount() {
            var $srcTable = $("#srcTable");
            $srcTable.find("#trTotal").remove();

            var totalRowHtml = '';
            var total = 0.00;
            var $hfAmountList = $srcTable.find("input[name=hfAmount]");

            $hfAmountList.each(function () {
                total += parseFloat($(this).val());
            });

            /*
            if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
                totalRowHtml += '<tr id="trTotal">';

                totalRowHtml += '<td colspan="7" style="text-align:right;padding-right:5px;font-weight:bold;">合计</td>';

                totalRowHtml += '<td style="text-align:right;padding-right:5px;">';
                totalRowHtml += '<span style="font-weight:bold;" id="spanTotalAmount">' + total.toFixed(2).toString() + '</span>';
                totalRowHtml += '<input type="hidden" name="hfTotalAmount" value="' + total.toFixed(2).toString() + '" id="hfTotalAmount" />';
                totalRowHtml += '</td>';

                totalRowHtml += '<td></td>';

                totalRowHtml += '</tr>';

                $srcTable.append($(totalRowHtml));
            }
            */
        }

        function formEditListTable_caculateAmount(rowID) {
            var $txtQuantity = $("#txtQuantity_" + rowID);
            var $txtPrice = $("#hfPrice" + rowID);
            var sQuantity = $txtQuantity.val();
            var sPrice = $txtPrice.val();
            var amount = 0.00;

            if (sQuantity == "") {
                sQuantity = "0";
            }
            if (sPrice == "") {
                sPrice = "0";
            }

            ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
            //clearNoNum($txtQuantity[0]);
            //clearNoNum($txtPrice[0]);

            if (isNaN(sQuantity)) {
                alert("数量为无效数字！");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
        
            if (isNaN(sPrice)) {
                alert("单价为无效数字.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) < 0) {  //限制数量不能超过100000
                alert("数量不能小于0或超过100000.");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
                alert("单价不能小于0或超过100000.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if ($txtQuantity.hasClass("error")) {
                $txtQuantity.removeClass("error");
            }
            if ($txtPrice.hasClass("error")) {
                $txtPrice.removeClass("error");
            }

            amount = parseFloat(sQuantity) * parseFloat(sPrice);

            $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());            

            formEditListTable_setTotalAmount();
        }

        function formEditListTable_checkTableData() {

            var result = true;

            var dataRowCount = 0;
            var $srcTable = $("#srcTable");

            $srcTable.find("input[name=txtQuantity]").each(function () {
                dataRowCount++;
                var sQuantity = $(this).val();
                if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                    alert("数量不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            /*
            $srcTable.find("input[name=hfPrice]").each(function () {
                var sPrice = $(this).val();
                if ($.trim(sPrice) == "" || $.trim(sPrice) == "0") {
                    alert("单价不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });
            */

            if (dataRowCount == 0) {
                alert("赠送商品清单不能为空！");
                result = false;
            }

            return result;
        }

        function formEditListTable_clearNoNum(obj) {
            obj.value = obj.value.replace(/[^\d.]/g, "");  //清除“数字”和“.”以外的字符  
            obj.value = obj.value.replace(/^\./g, "");  //验证第一个字符是数字而不是. 
            obj.value = obj.value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的.   
            obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
        }

    </script>

     <style type="text/css">  
    .editTable .th{
        width:100px;
    }
    </style>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="noteBar">                          
    <p>注：该功能用于冲减会员所拥有的可划次消费的商品/服务项目数量，冲减时不会自动创建商品入库单，如有必要，在冲销操作完成后，请手工对商品进行入库。</p>
</div><!--toolBar.END--> 

<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">商品赠送冲销</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="display:none;">
<tr>
<td class="th">(<span class="note mustfill">*</span>)赠送类型：</td>
<td>
    <asp:DropDownList ID="ddlDonateType" runat="server" EnableViewState="false">
    </asp:DropDownList>      
</td>
</tr>
</table>

<div id="divMemberInfoContainer">
<!--#include file="../include/memberinfo.aspx"--> 
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">(<span class="note mustfill">*</span>)冲销商品清单</td>
</tr>
</table>
<table cellspacing="0" class="formEditListTable" id="srcTable" style="width:700px;margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:70px;text-align:center;">代码</td>
<td style="width:390px;text-align:center;">品名</td>
<td style="width:50px;text-align:center;">单位</td>
<td style="width:70px;text-align:center;">冲销数量</td>
<td style="text-align:center;">操作</td>
</tr>    
</thead>    
<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:center;height:100px;">
    暂无数据
</td>
</tr>
</table>

<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:right;">
    添加要冲销的商品/服务项目：
    <VACTL:TextBox ID="txtItemName" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_member_chargeitems.aspx',true,true,450,180);"
                Width="310px"
                />
    <asp:HiddenField runat="server" id="txtItemName_hiddenValue" />  
    <asp:HiddenField runat="server" id="txtItemName_CustomParms" />
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">备注：</td>
<td>    
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="561px"
        MaxLength="100"     
        />        
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />   

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnResetPage" class="btn" style="width:100px" onclick="resetPage()" value="重置" />    
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

