﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="chargeitem_discountsetting_memberlevel.aspx.cs" Inherits="VA.Modules.JDingCYT.goods.chargeitem_discountsetting_memberlevel" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
    function save() {

        if (!checkData()) {
            return;
        }

        $.ajax({
            type: "POST",
            url: pageName + "?act=update",
            dataType: "html",
            data: $("form").eq(0).serialize(),
            success: function (data, textStatus) {
                if (data == "ok") {
                    showActResult("保存设置成功！", true);                   
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false);
                }
                else {
                    showActResult("保存设置失败：" + data, false);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showActResult("保存设置失败！textStatus :" + textStatus, false);
            }
        });
    }

    function clearSettings() {

        JTongAlertConfirm("确定要清除设置吗？", function () {
            $.ajax({
                type: "POST",
                url: pageName + "?act=clear",
                dataType: "html",
                data: $("form").eq(0).serialize(),
                success: function (data, textStatus) {
                    if (data == "ok") {
                        showActResult("清除设置成功！", true, function () {
                            window.location.reload();
                        });
                    } else if (data.indexOf("01|") != -1) {
                        showActResult(data.substring(3), false);
                    }
                    else {
                        showActResult("清除失败：" + data, false);
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showActResult("清除失败！textStatus :" + textStatus, false);
                }
            });
        });        
    }

    function checkData() {

        var result = true;
        var $srcTable = $("#srcTable");

        $srcTable.find("input[name=txtDiscount]").each(function () {        
            var sDiscount = $.trim($(this).val());
            if ($.trim(sDiscount) == "" || $.trim(sDiscount) == "0") {
                //alert("折扣不能为空！");
                $(this).val("1");
                $(this).select();
                $(this).addClass("error");
                //result = false;
                //return false;
            }

            sDiscount = $.trim($(this).val());

            var validator = new DataValidator();
            if (!validator.isFloat($.trim(sDiscount)) &&
                !validator.isInteger($.trim(sDiscount))
                ) {
                alert("折扣值无效！");
                $(this).select();
                $(this).addClass("error");
                result = false;
                return false;
            }
            
            if (parseFloat(sDiscount) >1) {
                alert("折扣值不能大于1！");
                $(this).select();
                $(this).addClass("error");
                result = false;
                return false;
            }
        });

        if (!result) {
            return false;
        }

        $srcTable.find("input[name=txtPrice]").each(function () {
            var sPrice = $.trim($(this).val());
            var sItemPrice = $.trim($("#hfItemPrice").val());
            if ($.trim(sPrice) != "") {
                var validator = new DataValidator();
                if (!validator.isFloat($.trim(sPrice)) &&
                    !validator.isInteger($.trim(sPrice))
                    ) {
                    alert("价格值无效！");
                    $(this).select();
                    $(this).addClass("error");
                    result = false;
                    return false;
                }

                if (parseFloat(sPrice) > parseFloat(sItemPrice)) {
                    alert("价格不能大于该项目的非会员价" + sItemPrice + "！");
                    $(this).select();
                    $(this).addClass("error");
                    result = false;
                    return false;
                }
            }
        });

        return result;
    }

    //显示操作结果；
    function showActResult(sMsg,actResult,callback) {        
        
        if (actResult) {
            JTongAlert('操作结果', sMsg, 'info', function () {
                if (callback != null && callback != undefined) {
                    callback();
                }
            });
        } else {
            JTongAlert('操作结果', sMsg, 'error', function () {
                if (callback != null && callback != undefined) {
                    callback();
                }
            });
        }
    }

    $(function () {
        
    });

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="noteBar">                          
    <p>注：如果设置了价格，则设置的折扣将不再启用作用；如果价格为空或0则表示使用折扣；</p>
</div><!--toolBar.END--> 

<div class="editPageWrapper" style="width:500px;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Standard)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

    <table cellspacing="0" cellpadding="3" class="editTable">
    <tr>
    <td class="th">项目代码：</td>
    <td colspan="3">              
        <% = base.itemInfo.Item_Code %>                       
    </td>
    </tr>
    <tr>
    <td class="th">项目名称：</td>
    <td colspan="3">              
         <% = base.itemInfo.Item_Name %>     
    </td>
    </tr>    
    <tr>
    <td class="th">单位：</td>
    <td>
        <% = base.itemInfo.Unit %>     
    </td>
    <td class="th">单价：</td>
    <td>
        <% = base.itemInfo.Price %>     
    </td>
    </tr>
    <tr>
    <td class="th">会员折扣：</td>
    <td colspan="3">              
         <% = base.itemInfo.Member_Discount.ToString("F2") %>  
         <span class="note">注：如未做高级设置，则系统将使用该值。</span>
    </td>
    </tr>
    <tr>
    <td class="th">会员价格：</td>
    <td colspan="3">              
         <% = base.itemInfo.Member_Price.ToString("F2") %>   
        <span class="note">注：如未做高级设置，则系统将使用该值。</span>
    </td>
    </tr>
    </table>

    <br />

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
    <tr>
    <td class="th" style="font-weight:bold;text-align:left;"><asp:Label ID="lblItemName" runat="server"></asp:Label> 高级设置</td>
    </tr>
    </table>
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>
    <table id="srcTable" cellpadding="3" cellspacing="0" class="listTable" style="margin-top:-1px;">
    <thead>
    <tr>
        <td style="width:50px;text-align:center;">No.</td>
        <td style="width:150px;text-align:center;">会员级别</td>
        <td style="width:100px;text-align:center;">折扣</td>        
        <td style="width:100px;text-align:center;">价格</td>
    </tr>    
    </thead>
    <tbody>
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td style="text-align:center;"><%# Container.ItemIndex %></td>
        <td align="center"><%# Eval("Level_Name")%><input type="hidden" name="hfMemberLevelCode" value="<%# Eval("Level_Code")%>" /></td>
        <td align="center"><input type="text" name="txtDiscount" class="input" value='<%# GetDiscount(Eval("Level_Code").ToString())%>' /></td>        
        <td align="center"><input type="text" name="txtPrice" class="input" value='<%# GetPrice(Eval("Level_Code").ToString())%>' /></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </tbody>
    </table>    

    </FooterTemplate>
    </asp:Repeater>    

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px">
    <tr>
    <td colspan="2" class="footer">
        <input type="button" id="Button1" class="btn" style="width:100px" onclick="save()" value="保存设置" />    
        <input type="button" id="Button2" class="btn" style="width:100px" onclick="clearSettings()" value="清除设置" />    
        <asp:HiddenField ID="hfKey" runat="server" />
        <asp:HiddenField ID="hfItemPrice" runat="server" />
    </td>
    </tr>
    </table>

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

