﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="gift_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.gift.gift_edit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var flag = "0";
        if ($("#hfKey").val() != "") {
            flag = "1";
        }

        if (flag == 0) {
            //JTongAlertConfirm("确定要保存吗？", add);
            add();
        }
        else {
            update();            
        }
    }

    function add() {
        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data,textStatus) {
            if (data == "ok") {
                showActResult("添加成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("添加失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function update() {
        var requestType = "POST";
        var url = pageName + "?act=update";
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("修改成功！", true, doAfterUpdate);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterUpdate);
            }
            else {
                showActResult("修改失败：" + data, false, doAfterUpdate);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.completeReload();
                }
            } catch (e) { }
            resetPage();
        }
    }
    function doAfterUpdate(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.closeFrameWindow();
                    window.parent.completeReload();
                }
            } catch (e) { }
        }
    }

    function resetPage() {
        var newItemCode = ajaxGetData("gift_get_newitemcode.aspx", "html", null);
        $("#txtItemCode").val(newItemCode);
        $("#txtItemName").val("");
        $("#txtInputCode").val("");
        $("#txtUnit").val("");
        $("#txtUnit_hiddenValue").val("");
        $("#txtCostPoints").val("");
        $("#txtRemark").val("");

        clearInputValidatorError();

        $("#txtItemName").focus();
    }


    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {

        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtUnit") {

                $("#txtCostPoints").focus();
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    $(function () {
        $("#txtItemName").focus();
        $("#txtItemName").keyup(function (event) {
            var itemName = $(this).val();
            if ($.trim(itemName) == "") {
                return;
            }
            if (event.keyCode != 13) {
                var requestType = "GET";
                var url = "../smartdropdownlist_datasrc/get_inputcode.aspx";
                var dataType = "html";
                var data = { keywords: itemName };
                var successFN = function (data, textStatus) {
                    $("#txtInputCode").val(data);
                };
                ajaxRequest(requestType,
                    url,
                    dataType,
                    data,
                    successFN,
                    errorFN
                    );
            }
        });

        //焦点控制
        //$("input:not(#txtUnit),select").keydown(function (event) {
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "txtItemCode":
                        $("#txtItemName").focus();
                        break;
                    case "txtItemName":
                        if ($("#txtItemName").val() != "") {
                            $("#ddlCategory").focus();
                        }
                        break;
                    case "ddlCategory":
                        $("#txtUnit").focus();
                        break;
                    case "txtUnit":
                        $("#txtCostPoints").focus();
                        break;
                    case "txtCostPoints":
                        $("#txtRemark").focus();
                        break; 
                    case "txtRemark":
                        save();
                        break;
                    default:
                        break;
                }
            }
        });     
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:600px;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">添加礼品</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr id="trEditResult" runat="server" visible="false">
<td colspan="2" style="text-align:center;">
    <div class="editResult">
    <asp:Literal id="litEditResult" runat="server" />
    </div>
</td>
</tr>
<tr style="display:none;">
<td class="th">(<span class="note mustfill">*</span>)礼品类型：</td>
<td>
    <asp:RadioButtonList id="rbnItemType" runat="server"
         RepeatDirection="Horizontal"
         RepeatLayout="Flow">
        <asp:ListItem Value="1">服务项目</asp:ListItem>
        <asp:ListItem Value="2" Selected="True">商品</asp:ListItem>
    </asp:RadioButtonList>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)礼品代码：</td>
<td>              
    <VACTL:TextBox ID="txtItemCode" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="100px"
            CanBeNull="No"
            FieldName="礼品代码"
            RequiredFieldType="PositiveInteger"
            ReadOnly="true"
            MaxLength="10" />        
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)礼品名称：</td>
<td>              
    <VACTL:TextBox ID="txtItemName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            CanBeNull="No"
            FieldName="礼品名称"
            MaxLength="25" />        
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)输 入 码：</td>
<td>              
    <VACTL:TextBox ID="txtInputCode" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="200px"
            CanBeNull="No"
            FieldName="输入码"
            MaxLength="30" />        
</td>
</tr>
<tr>
<td class="th">所属分类：</td>
<td>
    <asp:DropDownList ID="ddlCategory" Runat="server" Width="104px" >    
    </asp:DropDownList>
   <%-- <asp:RequiredFieldValidator runat="server"
         ControlToValidate="ddlCategory"
         ErrorMessage="[所属分类]必须选择一项！" />--%>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)计量单位：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtUnit" 
            CssClass="input" 
            onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_units.aspx',true,true,310,180,0,true,'2',true);"
            Width="100px"
            CanBeNull="No"
            FieldName="单位"
            MaxLength="10" />
    <asp:HiddenField runat="server" id="txtUnit_hiddenValue" />
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)兑换分值：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtCostPoints" 
            CssClass="input"             
            Width="100px"
            CanBeNull="No"
            FieldName="兑换分值"
            RequiredFieldType="Integer"
            MaxLength="10" /> 注：0表示不支持积分兑换。
</td>
</tr>
<%--<tr>
<td class="th">(<span class="note mustfill">*</span>)单价：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtPrice" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="单价"
            RequiredFieldType="Money"
            />
</td>
</tr>--%>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="200px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td colspan="2" class="footer">
    <% if (base.flag == 0) { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />
    <% } else { %>
    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <% } %>    
    
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfShopCode" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

