﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="announcement_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.corporateaffairs.announcement_edit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>公告发布</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">    
    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var flag = "0";
        if ($("#hfKey").val() != "") {
            flag = "1";
        }

        if (flag == 0) {
            add();
        }
        else {
            update();
        }
    }

    function add() {
        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("保存成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("保存失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function update() {
        var requestType = "POST";
        var url = pageName + "?act=update1";
        var dataType = "html";
        var data = $("form").eq(0).serialize();        
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("保存成功！", true, doAfterUpdate);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterUpdate);
            }
            else {
                showActResult("保存失败：" + data, false, doAfterUpdate);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.reload();
                }
            } catch (e) { }
            resetPage();
        }
    }

    function doAfterUpdate(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.reload();
                }
            } catch (e) { }
        }
    }

    function resetPage() {

        $("#txtTitle").val("");
        $("#txtContent").val("");
        $("#ckbHighlight")[0].checked = false;
        $("#ckbSetTop")[0].checked = false;

        clearInputValidatorError();

        $("#txtTitle").focus();
    }

    $(function () {
        $("#txtTitle").focus();
    });

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:720px;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">公告发布</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr>
<td class="th">操 作 员：</td>
<td>
    <% = base.EmployeeName %>
</td>
</tr>
<tr>
<td class="th">当前门店：</td>
<td>
    <% = base.ShopName %>
</td>
</tr>
<tr>
<td class="th">当前日期：</td>
<td>
    <% = DateTime.Now.ToString("yyyy-MM-dd", System.Globalization.CultureInfo.InvariantCulture) %>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)公告标题：</td>
<td>              
    <VACTL:TextBox ID="txtTitle" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="400px"
            CanBeNull="No"
            FieldName="公告标题"
            MaxLength="50" />   
    
    <asp:CheckBox ID="ckbHighlight" runat="server"
         Text="醒目显示"
         Visible="false" />

    <asp:CheckBox ID="ckbSetTop" runat="server"
         Text="置顶排列" />
         
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)公告内容：</td>
<td>
    <VACTL:TextBox ID="txtContent" runat="server"
            EnableViewState="False"
		    CssClass="input"
            Width="600px"
            Height="250px" 
            CanBeNull="No"
            FieldName="公告内容"
            TextMode="MultiLine"
            /> 
</td>
</tr>
<tr id="trRelease" runat="server">
<td class="th">(<span class="note mustfill">*</span>)是否发布：</td>
<td>
    <asp:RadioButtonList ID="rblStatus" runat="server"
         RepeatDirection="Horizontal"
         RepeatLayout="Flow">
        <asp:ListItem Value="1">存为草稿</asp:ListItem>
        <asp:ListItem Value="2" Selected="True">立即发布</asp:ListItem>        
    </asp:RadioButtonList>
</td>
</tr>
<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="btnClear" class="btn" style="width:100px" onclick="resetPage()" value="重置" />

    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</form>
</body>
</html>

