﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="quickcharge.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.quickcharge" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

        function confirm() {

            //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
            var validationResult = Page_ClientValidate('');
            if (!validationResult) {
                return;
            }

            //var chargeDate = $("#spanChargeDate").html();
            //var operatorName = $("#spanOperatorName").html();
            var totalAmount = $("#txtTotalAmount").val();
            var discountAmount = $("#txtDiscountAmount").val();
            var chargeAmount = $("#txtChargeAmount").val();
            var payTypeName = $("#ddlPayTypes").find("option:selected").text();

            if (parseFloat(totalAmount) < 0) {
                JTongAlert("提示", "合计金额不能为负数！", "error", function () {
                    $("#txtTotalAmount").select();
                });
                return;
            }
            if (parseFloat(discountAmount) < 0) {
                JTongAlert("提示", "优惠金额不能为负数！", "error", function () {
                    $("#txtDiscountAmount").select();
                });
                return;
            }

            //$("#span_Confirm_ChargeDate").html(chargeDate);
            //$("#span_Confirm_OperatorName").html(operatorName);
            $("#span_Confirm_TotalAmount").html(totalAmount);
            $("#span_Confirm_DiscountAmount").html(discountAmount);
            $("#span_Confirm_ChargeAmount").html(chargeAmount);
            $("#span_Confirm_PayTypeName").html(payTypeName);

            $('#winConfirm').css("display", "block");
            $('#winConfirm').window({
                width: 350,
                height: 358,
                left: 180,
                top: 116,
                modal: true,
                maximizable: false,
                minimizable: false,
                collapsible: false,
                title: '确认'
            });
            $("#btnSubmit").focus();
        }

        function cancelSave() {
            $('#winConfirm').window("close");
        }
    
    function save() {

        var hfMemberID = $("#hfMemberID").val();
        var isFreeCustomer = $("#ckbIsFreeCustomer")[0].checked;
        
        if (!isFreeCustomer) {  //如果会员        
            if ($.trim(hfMemberID) == "") {
                JTongAlert('提示', "会员信息不能为空！", 'warning');
                return;
            }
        } else {
            var payTypeCode = $("#ddlPayTypes").val(); 
            if (payTypeCode == "2") {
                JTongAlert('提示', "对于散客，支付方式不能为：会员钱包支付！", 'warning');
                return;
            }
        }

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("收银成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("收银失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {
            
            var isFreeCustomer = $("#ckbIsFreeCustomer")[0].checked;
            if (!isFreeCustomer) { //如果是会员；
                if ($("#ckbNotify")[0].checked == true) {
                    ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "consumecharge", "bizno": bizNo });
                }
            }

            resetPage();
            cancelSave();
        }
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {

        $("#btnSubmit").removeAttr("disabled");

        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function resetPage() {
        
        var isFreeCustomer = $("#ckbIsFreeCustomer")[0].checked;
        if (!isFreeCustomer) { //如果是会员；            
            $("#txtTotalAmount").attr("disabled", "disabled");
            $("#txtDiscountAmount").attr("disabled", "disabled");
            $("#txtChargeAmount").attr("disabled", "disabled");
            $("#ddlPayTypes").attr("disabled", "disabled");
            $("#txtRemark").attr("disabled", "disabled");
            $("#btnSubmit").attr("disabled", "disabled");
        }
        
        $("#txtTotalAmount").val("");
        $("#txtDiscountAmount").val("");
        $("#txtChargeAmount").val("");
        $("#ddlPayTypes")[0].options[0].selected = true;
        $("#txtRemark").val("");
        $("#spanCostPoints").html("");

        clearMemberInfo();
        clearInputValidatorError();
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {

        $("#txtTotalAmount").removeAttr("disabled");
        $("#txtDiscountAmount").removeAttr("disabled");
        $("#txtChargeAmount").removeAttr("disabled");
        $("#ddlPayTypes").removeAttr("disabled");
        $("#txtRemark").removeAttr("disabled");
        $("#btnSubmit").removeAttr("disabled");

        $("#txtTotalAmount").focus();
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {

    }    

    function applySaleStrategy() {

        var customerType = "";
        var consumeAmount = $("#txtTotalAmount").val();
        if ($.trim(consumeAmount) == "") {
            return;
        }

        var validator = new DataValidator();
        if (!validator.isFloat(consumeAmount)) {
            JTongAlert("提示", "\"合计金额\"不是有效的数字！", "error", function () {
                $("#txtTotalAmount").select();
            });
            return;
        }

        if ($("#ckbIsFreeCustomer")[0].checked == true){
            customerType = "1"; //散客
        }else{
            customerType = "2"; //会员
        }

        $.ajax({
            type: "GET",
            url: "apply_consume_salestategy.aspx",
            dataType: "html",
            async: false,
            data: { "memberID": $("#hfMemberID").val(), "customerType" : customerType , "consumeAmount": $("#txtTotalAmount").val() },
            success: function (data, textStatus) {
                if (data != "error") {
                    if (data == "") {
                        //do nothing
                        caculateChargeAmount();
                    } else {
                        var ssResult = JSON.parse(data);                        
                        $("#txtDiscountAmount").val(ssResult.discountAmount);
                        $("#hfStrategyCode").val(ssResult.strategyCode);
                        $("#hfStrategyName").val(ssResult.strategyName);
                        caculateChargeAmount();
                    }
                }
                else {
                    showActResult("应用营销策略失败！", false);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showActResult("请求失败！textStatus :" + textStatus, false);
            }
        });
    }

    function caculateChargeAmount() {
        
        var sTotalAmount = $.trim($("#txtTotalAmount").val());
        var sDiscountAmount = $.trim($("#txtDiscountAmount").val());
        var chargeAmount = 0.00;
        if (sTotalAmount != "") {

            if (sDiscountAmount == "") {
                sDiscountAmount = "0.00";
                $("#txtDiscountAmount").val(sDiscountAmount);
            }            

            chargeAmount = parseFloat(sTotalAmount) - parseFloat(sDiscountAmount);
            $("#txtChargeAmount").val(chargeAmount.toFixed(2).toString());
        } else {
            $("#txtChargeAmount").val("");
            $("#txtDiscountAmount").val("");
        }

        caculateCostPoints();
    }
    function caculateChargeAmount2() {

        var sTotalAmount = $.trim($("#txtTotalAmount").val());
        var discountAmount = 0.00;
        var sChargeAmount = $.trim($("#txtChargeAmount").val());
        if (sTotalAmount != "") {

            if (sChargeAmount == "") {
                sChargeAmount = "0.00";
                $("#txtChargeAmount").val(sChargeAmount);
            }

            discountAmount = parseFloat(sTotalAmount) - parseFloat(sChargeAmount);
            $("#txtDiscountAmount").val(discountAmount.toFixed(2).toString());
        } else {
            $("#txtChargeAmount").val("");
            $("#txtDiscountAmount").val("");
        }

        caculateCostPoints();
    }

    //计算抵扣需要的积分；
    function caculateCostPoints() {

        var payTypeCode = $("#ddlPayTypes").val();
        if (payTypeCode == "20") { //20-积分抵扣
            var sPayAmount = $.trim($("#txtChargeAmount").val());
            var payAmount = 0;
            if (sPayAmount != "") {
                payAmount = parseFloat(sPayAmount);
            }

            var xs = $("#hfPointXSEqualMoney").val();
            var costPoints = parseFloat(xs) * parseFloat(payAmount);
            $("#spanCostPoints").html("共需积分： " + costPoints.toFixed().toString() + " 分");
            $("#spanCostPoints").show();
        } else {
            $("#spanCostPoints").hide();
        }
    }

    function ddlPayTypes_SelectedIndexChanged() {
        caculateCostPoints();
    }

    $(function () {
        $("#ckbIsFreeCustomer").click(function () {
            var ckbIsFreeCustomer = $("#ckbIsFreeCustomer")[0];
            if (ckbIsFreeCustomer.checked) {

                clearMemberInfo();

                $("#txtKey").attr("disabled", "disabled");
                $("#ddlKeyType").attr("disabled", "disabled");
                $("#btnBrowseMembers").attr("disabled", "disabled");

                $("#ckbNotify").attr("disabled", "disabled");
                $("#ckbNotify")[0].checked = false;
                
                $("#txtTotalAmount").removeAttr("disabled");
                $("#txtDiscountAmount").removeAttr("disabled");
                $("#txtChargeAmount").removeAttr("disabled");
                $("#ddlPayTypes").removeAttr("disabled");
                $("#txtRemark").removeAttr("disabled");
                $("#btnSubmit").removeAttr("disabled");

                //对于散客，默认选中现金；
                for (var i = 0; i < $("#ddlPayTypes")[0].options.length; i++) {
                    var optionValue = $("#ddlPayTypes")[0].options[i].value;
                    if (optionValue == "3") { //现金支付；
                        $("#ddlPayTypes")[0].options[i].selected = true;
                        break;
                    }
                }

                $("#txtTotalAmount").focus();
            }
            else {
                $("#txtKey").removeAttr("disabled");
                $("#ddlKeyType").removeAttr("disabled");
                $("#btnBrowseMembers").removeAttr("disabled");

                $("#ckbNotify").removeAttr("disabled");

                //对于会员，默认选中会员卡账户支付；
                for (var i = 0; i < $("#ddlPayTypes")[0].options.length; i++) {
                    var optionValue = $("#ddlPayTypes")[0].options[i].value;
                    if (optionValue == "2") { //会员卡账户支付；
                        $("#ddlPayTypes")[0].options[i].selected = true;
                        break;
                    }
                }
            }
        });
        
        //为 txtTotalAmount 同时注册了keyup和keydown事件，均处理了回车事件，发现keydown的回车事件
        //会被处理，keyup不会被处理，所以将应用优惠策略的代码放到keydown事件中。
        $("#txtTotalAmount").keyup(function (event) {           
            var keyCode = event.keyCode; 
            if (keyCode != 13) {                
                caculateChargeAmount();
            }
        });
        $("#txtDiscountAmount").keyup(function (event) {
            caculateChargeAmount();
        });
        $("#txtChargeAmount").keyup(function (event) {
            caculateChargeAmount2();
        });
        $("#txtChargeAmount").change(function () {
            caculateCostPoints();
        });

        $("#ddlPayTypes").change(function () {
            ddlPayTypes_SelectedIndexChanged();
        });
        
        $("#txtTotalAmount").attr("disabled", "disabled");
        $("#txtDiscountAmount").attr("disabled", "disabled");
        $("#txtChargeAmount").attr("disabled", "disabled");
        $("#ddlPayTypes").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnSubmit").attr("disabled", "disabled");
        
        //焦点控制
        $("input,select").keydown(function (event) {
            if (event.keyCode == 13) {
                var targetID = event.target.id;
                switch (targetID) {
                    case "txtTotalAmount":                        
                        applySaleStrategy();
                        caculateChargeAmount();
                        $("#txtChargeAmount").select();
                        break;
                    case "txtDiscountAmount":
                        $("#txtChargeAmount").select();
                        break;
                    case "txtChargeAmount":
                        if ($("#txtChargeAmount").val() != "") {
                            $("#ddlPayTypes").focus();
                        }
                        break;
                    case "ddlPayTypes":
                        //调用confirm()方法将直接触发保存事件，所以更改为让btnNext获得焦点；
                        $("#btnNext").focus();
                        break;                  
                    default:
                        break;
                }
            }
        });
    });

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1>快速收银</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-bottom:-1px;">
<tr>
<td style="font-weight:bold;text-align:right;">
    <asp:CheckBox ID="ckbIsFreeCustomer" runat="server"
         Text="散客" />
</td>
</tr>
</table>

<!--#include file="../include/memberinfo.aspx"--> 

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" colspan="6" style="font-weight:bold;text-align:left;">收银信息</td>
</tr>
<tr>
<td class="th">消费总额：</td>
<td style="width:119px;">
    <VACTL:TextBox runat="server" ID="txtTotalAmount" 
            CssClass="input" 
            Width="110px"
            CanBeNull="No"
            FieldName="合计金额"
            RequiredFieldType="Money"
            Font-Bold="true"
            />
    <asp:HiddenField runat="server" id="hfStrategyCode" />
    <asp:HiddenField runat="server" id="hfStrategyName" />
</td>
<td class="th">优惠金额：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtDiscountAmount" 
            CssClass="input" 
            Width="110px"
            CanBeNull="No"
            FieldName="优惠金额"
            RequiredFieldType="Money"
            Text="0.00"
            Font-Bold="true"
            />
</td>
</tr>
<tr>
<td class="th">实收金额：</td>
<td colspan="3">
    <VACTL:TextBox runat="server" ID="txtChargeAmount" 
            CssClass="input" 
            Width="110px"
            CanBeNull="No"
            FieldName="实收金额"
            Font-Bold="true"
            />
</td>
</tr>
<tr>
<td class="th">支付方式：</td>
<td colspan="3">
    <asp:DropDownList ID="ddlPayTypes" Runat="server" >
    </asp:DropDownList>

    <span id="spanCostPoints" style="color:green;"></span>
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td colspan="3">
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="580px"
        MaxLength="100"
        />        
</td>
</tr>
<tr>
<td class="th">操作员：</td>
<td colspan="3">
    <% = base.EmployeeName %>
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnNext" class="btn" style="width:80px" onclick="confirm()" value="收银" />
    <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfPointXSEqualMoney" runat="server" />

    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<!--确认窗口-->    
<div id="winConfirm" style="display:none;">

    <div style="width:300px;margin:auto;">
    
    <br />

    <div class="centerFormTitle">
        <h1>确认收费信息</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;width:300px;">
    <tr>
    <td class="th">操 作 员：</td>
    <td>    
	    <span id="span_Confirm_OperatorName"><%= base.EmployeeName %></span>
    </td>
    </tr>
    <tr>
    <td class="th">收费日期：</td>
    <td>    
	    <span id="span1"><% = DateTime.Now.ToString("yyyy-MM-dd") %></span>
    </td>
    </tr>
    <tr>
    <td class="th">消费总额：</td>
    <td>    
	    <span id="span_Confirm_TotalAmount" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">优惠金额：</td>
    <td>    
        <span id="span_Confirm_DiscountAmount" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">实收金额：</td>
    <td>   
        <span id="span_Confirm_ChargeAmount" style="font-weight:bold;"></span> 
    </td>
    </tr>
    <tr>
    <td class="th">支付方式：</td>
    <td>    
        <span id="span_Confirm_PayTypeName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td colspan="2" class="footer">

        <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />   

        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="确定" />
        <input type="button" id="btnCancel" class="btn" style="width:80px" onclick="cancelSave()" value="取消" />        
    </td>
    </tr>
    </table>
    </div>

</div><!--winConfirm.END-->

</form>
</body>
</html>

