﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="pointcard_charge.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.pointcard_charge" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
    
    function confirm() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        var hfMemberID = $("#hfMemberID").val();
        var consuemQuantity = $("txtConsumeQuantity").val();
        var selectCard = false;

        if (!isNaN(consuemQuantity)) {
            JTongAlert('提示', "划次数量填写无效！", 'warning');
            return;
        }

        if ($.trim(hfMemberID) == "") {
            JTongAlert('提示', "会员信息不能为空！", 'warning');
            return;
        }
        
        var cardName = "";
        var consumeQuantity = $("#txtConsumeQuantity").val();
        var waiter = $("#txtWaiter").val();

        $("#divMemberPointCards").find("tr").each(function () {
            var radio = $(this).find("input[type=radio]")[0];
            if (radio != undefined) {
                if (radio.checked) {
                    cardName = this.cells[2].innerHTML;
                    selectCard = true;
                    return false;
                }
            }
        });

        if (!selectCard) {
            JTongAlert('提示', "请选择计次卡！", 'warning');
            return;
        }
       
        $("#span_Confirm_CardName").html(cardName);
        $("#span_Confirm_ConsumeQuantity").html(consumeQuantity);
        $("#span_Confirm_Waiter").html(waiter);

        var windowTitle = "确认";
        var windowWidth = 450;
        var windowHeight = 358;
        var left = 180;
        var top = 116;
        var winDivID = "winConfirm";
        openDivWindow(windowTitle, windowWidth, windowHeight, left, top, winDivID);
        $("#btnSubmit").focus();
    }

    function cancelSave() {
        $('#winConfirm').window("close");
    }

    function save() {

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("收银成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("收银失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {

            if ($("#ckbNotify")[0].checked == true) {
                ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "consumecharge", "bizno": bizNo });
            }

            resetPage();
            cancelSave();
        } 
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {

        $("#btnSubmit").removeAttr("disabled");

        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function resetPage() {
        
        $("#ddlPayTypes").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#txtConsumeQuantity").attr("disabled", "disabled");
        $("#txtWaiter").attr("disabled", "disabled");
        $("#btnSubmit").attr("disabled", "disabled");

        clearMemberInfo();

        $("#txtRemark").val("");
        $("#txtConsumeQuantity").val("1");
        $("#txtWaiter").val("");
        $("#txtWaiter_hiddenValue").val("");

        $("#divMemberPointCards").html("");
        $("#tbNoRecord").show();

        clearInputValidatorError();

        $("#txtKey").focus();
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {

        $("#txtConsumeQuantity").removeAttr("disabled");
        $("#txtWaiter").removeAttr("disabled");
        $("#txtRemark").removeAttr("disabled");        
        
        loadMemberPointCards(memberInfo.memberID);        
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {

    }

    function loadMemberPointCards(memberID) {       
        $.ajax({
            type: "GET",
            url: "get_member_pointcardlist.aspx",
            dataType: "html",
            data: { "memberid": memberID },
            success: function (data, textStatus) {

                if (data.indexOf("该会员没有可用的计次消费卡") == -1) {                    
                    $("#btnSubmit").removeAttr("disabled");                    
                }

                $("#tbNoRecord").hide();
                $("#divMemberPointCards").html(data);
                $("#divMemberPointCards").find("table[class=listTable]").find("tr").click(function () {
                    $("#divMemberPointCards").find("table[class=listTable]").find("tr").removeClass("tr_selected");
                    var $tr = $(this);
                    $tr.find("input[name=pointCard]")[0].checked = true;
                    $tr.addClass("tr_selected");
                });
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showActResult("请求失败！textStatus :" + textStatus, false);
            }
        });
    }

    function clearWaiters() {
        $("#txtWaiter").val("");
        $("#txtWaiter_hiddenValue").val("");
    }

    $(function () {
        $("#txtConsumeQuantity").attr("disabled", "disabled");
        $("#txtWaiter").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnSubmit").attr("disabled", "disabled");
    });

    </script>   

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

<div class="centerFormTitle">
   <h1>划次收银</h1>
</div>

<!--#include file="../include/memberinfo.aspx"--> 

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">该会员拥有的计次卡</td>
</tr>
</table>

<div id="divMemberPointCards"></div>

<%--<table cellspacing="0" class="listTable" id="srcTable" style="width:700px;margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;"></td>
<td style="width:60px;text-align:center;">卡类型</td>
<td style="text-align:center;">卡名称</td>
<td style="width:60px;text-align:center;">已用次数</td>
<td style="width:60px;text-align:center;">剩余次数</td>    
<td style="width:60px;text-align:center;">生效日期</td>
<td style="width:60px;text-align:center;">过期时间</td>
<td style="width:60px;text-align:center;">刷卡记录</td>
</tr>    
</thead>    

<tbody>

<tr>
<td align="center"><input type="radio" name="pointCard" value="1" /></td>
<td align="center">自由消费卡</td>
<td align="left">理发100元理10次卡</td>
<td align="center">10</td>
<td align="center">5</td>
<td align="center">2015-08-05</td>
<td align="center">2115-08-05</td>
<td align="center">[ 查看 ]</td>
</tr>
<tr>
<td align="center"><input type="radio" name="pointCard" value="1" /></td>
<td align="center">自由消费卡</td>
<td align="left">理发100元理10次卡</td>
<td align="center">10</td>
<td align="center">5</td>
<td align="center">2015-08-05</td>
<td align="center">2115-08-05</td>
<td align="center">[ 查看 ]</td>
</tr>
    
</tbody>
</table>--%>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:center;height:100px;">
    暂无记录
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">划次数量：</td>
<td>    
    <VACTL:TextBox ID="txtConsumeQuantity" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="50px"
        MaxLength="10"
        CanBeNull="No"
        FieldName="划次数量"   
        RequiredFieldType="PositiveInteger"
        Text="1"   
        MinimumValue="1"
        MaximumValue="10000"
        /> 次
</td>
</tr>
<tr>
<td class="th">服 务 员：</td>
<td>    
   <VACTL:TextBox ID="txtWaiter" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_employees.aspx',true,true,300,180);"
                Width="110px"
                />
    <asp:HiddenField runat="server" id="txtWaiter_hiddenValue" />  
    <input type="button" id="btnClearWaiters" class="simpleBtn" onclick="clearWaiters()" value="清除服务员" />    
</td>
</tr>
<tr>
<td class="th">消费备注：</td>
<td>    
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="580px"
        MaxLength="100"
        />        
</td>
</tr>
<tr>
<td class="th">操 作 员：</td>
    <td>    
	    <%= base.EmployeeName %>
    </td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnNext" class="btn" style="width:80px" onclick="confirm()" value="收银" />
    <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<!--确认窗口-->    
<div id="winConfirm" style="display:none;">

    <div style="width:420px;margin:auto;">
    
    <br />

    <div class="centerFormTitle">
        <h1>确认收银信息</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;width:100%;">
    <tr>
    <td class="th">操 作 员：</td>
    <td>    
	    <span id="span_Confirm_OperatorName"><%= base.EmployeeName %></span>
    </td>
    </tr>
    <tr>
    <td class="th">收银日期：</td>
    <td>    
	    <span id="span1"><% = DateTime.Now.ToString("yyyy-MM-dd") %></span>
    </td>
    </tr>
    <tr>
    <td class="th">计 次 卡：</td>
    <td>    
        <span id="span_Confirm_CardName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">划次数量：</td>
    <td>    
	    <span id="span_Confirm_ConsumeQuantity" style="font-weight:bold;"></span>
    </td>
    </tr>    
    <tr>
    <td class="th">服 务 员：</td>
    <td>   
        <span id="span_Confirm_Waiter" style="font-weight:bold;"></span> 
    </td>
    </tr>    
    <tr>
    <td colspan="2" class="footer">

        <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />   

        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="确定" />
        <input type="button" id="btnCancel" class="btn" style="width:80px" onclick="cancelSave()" value="取消" />        
    </td>
    </tr>
    </table>
    </div>

</div><!--winConfirm.END-->


<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  


</form>
</body>
</html>

