﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="point_charge.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.normalpoint_charge" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

        function confirm() {

            //var chargeDate = $("#spanChargeDate").html();
            //var operatorName = $("#spanOperatorName").html();
            var payTypeName = "赠品划次支付";
            //$("#span_Confirm_ChargeDate").html(chargeDate);
            //$("#span_Confirm_OperatorName").html(operatorName);
            $("#span_Confirm_PayTypeName").html(payTypeName);

            $('#winConfirm').css("display", "block");
            $('#winConfirm').window({
                width: 350,
                height: 280,
                left: 180,
                top: 116,
                modal: true,
                maximizable: false,
                minimizable: false,
                collapsible: false,
                title: '确认'
            });
            $("#btnSubmit").focus();
        }

        function cancelSave() {
            $('#winConfirm').window("close");
        }
    
    function save() {

        if (!formEditListTable_checkTableData()) {
            return;
        }

        $("#btnSubmit").attr("disabled", "disabled");

        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("划次成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("划次失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult, bizNo) {
        if (actResult) {

            if ($("#ckbNotify")[0].checked == true) {
                ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "consumecharge", "bizno": bizNo });
            }

            resetPage();
            cancelSave();
        }
    }

    //显示操作结果；
    function showActResult(sMsg, actResult, callback, bizNo) {

        $("#btnSubmit").removeAttr("disabled");

        var icon = "info";
        if (!actResult) {
            icon = "error";
        }

        JTongAlert('操作结果', sMsg, icon, function () {
            if (callback != null && callback != undefined) {
                callback(actResult, bizNo);
            }
        });
    }

    function resetPage() {
        
        $("#txtRemark").val("");
        $("#txtItemName").val("");        
        $("#txtItemName_hiddenValue").val("");
        $("#txtItemName_CustomParms").val("");

        $("#txtItemName").attr("disabled", "disabled");
        $("#txtWaiter").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnNext").attr("disabled", "disabled");

        clearMemberInfo();

        formEditListTable_clearRows();

        //清除错误提示样式；
        $("select,input").each(function () {
            if ($(this).hasClass("error_indicator")) {
                $(this).removeClass("error_indicator");
            }
        });
    }

    //会员信息加载成功时调用的方法；            
    function doWhenMemberInfoLoadSuc(memberInfo) {

        $("#txtItemName").removeAttr("disabled");
        $("#txtWaiter").removeAttr("disabled");
        $("#txtRemark").removeAttr("disabled");
        $("#btnNext").removeAttr("disabled");
        $("#txtItemName_CustomParms").val("memberid=" + memberInfo.memberID);

        $("#txtItemName").focus();
    }

    //会员信息加载失败时调用的方法；
    function doWhenMemberInfoLoadFail() {

    }    

    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtItemName") {
                
                var levelCode = $("#hfLevelCode").val();
                var itemType = selectedRow.cells[0].innerHTML;
                var itemCode = selectedRow.cells[1].innerHTML;
                var itemName = selectedRow.cells[2].innerHTML;
                var unit = selectedRow.cells[3].innerHTML;
                var price = parseFloat(selectedRow.cells[5].innerHTML);
                var quantity = 1.0;
                var amount = price * quantity;

                if (itemType == "服务") {
                    itemType = "1";
                }
                else if (itemType == "商品") {
                    itemType = "2";
                }
                
                formEditListTable_addRow(itemType, itemCode, itemName, unit, price, quantity);
                $("#txtItemName").val("");
                $("#txtItemName_hiddenValue").val("");
            } else if (JTongSmartDropDownList_inputObjID == "txtWaiter") {

                var code = selectedRow.cells[0].innerHTML;
                var name = selectedRow.cells[1].innerHTML;

                var $srcTable = $("#srcTable");
                $srcTable.find("input.waiterName").each(function () {
                    $(this).val(name);
                });
                $srcTable.find("input.waiterCode").each(function () {
                    $(this).val(code);
                });
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    function caculateChargeAmount() {
        var sTotalAmount = $.trim($("#txtTotalAmount").val());
        var sDiscountAmount = $.trim($("#txtDiscountAmount").val());
        var chargeAmount = 0.00;
        if (sTotalAmount != "") {

            if (sDiscountAmount == "") {
                sDiscountAmount = "0.00";
            }

            chargeAmount = parseFloat(sTotalAmount) - parseFloat(sDiscountAmount);            
            $("#txtChargeAmount").val(chargeAmount);
            $("#hfChargeAmount").val(chargeAmount);
        }
    }

    $(function () {

        $("#txtItemName").attr("disabled", "disabled");
        $("#txtWaiter").attr("disabled", "disabled");
        $("#txtRemark").attr("disabled", "disabled");
        $("#btnNext").attr("disabled", "disabled");
    });

    </script>

    <script type="text/javascript">

        var formEditListTable_RowCounter = 0;

        function formEditListTable_addRow(itemType,itemCode, itemName, unit, price, quantity) {
            
            formEditListTable_RowCounter++;

            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
            if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
                return;
            }

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;

            itemName = itemName.replace(/'/g, "‘");
            unit = unit.replace(/'/g, "‘");

            var amount = price * quantity;

            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + itemCode + '</span>';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:left;padding-left:5px;">';
            rowHtml += '<span>' + itemName + '</span>';
            rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
            rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
            rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + unit + '</span>';
            rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
            rowHtml += '</td>';
            
            rowHtml += '<td style="text-align:right;padding-right:5px;">';
            rowHtml += '<input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" />';            
            //rowHtml += '<span style="font-weight:bold;" id="spanAmount_' + rowID + '">' + amount + '</span>';
            rowHtml += '<input type="hidden" name="txtPrice" value="' + price + '" id="txtPrice_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" />';
            rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td>';
            rowHtml += '<input class="waiterName" type="text" name="txtWaiterName" value="" id="txtWaiterName_' + rowID + '" readonly="true" onclick="takeWaiter(' + rowID + ')" />';
            rowHtml += '<input class="waiterCode" type="hidden" name="hfWaiterCode" value="" id="hfWaiterCode_' + rowID + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';
            rowHtml += '</tr>';

            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
            formEditListTable_hideTbNoRecord();
        }

        function formEditListTable_dataMerge($srcTable, itemCode, quantity) {
            var result = false;
            var trID = "";

            $srcTable.find("tr").each(function () {
                var $tr = $(this);
                var $hfItemCode = null;
                
                if ($tr.find("input[name=hfItemCode]").length > 0) {
                    $hfItemCode = $tr.find("input[name=hfItemCode]").eq(0);
                    if ($hfItemCode.val() == itemCode) {
                        var $txtQuantity = $tr.find("input[name=txtQuantity]").eq(0);
                        var sOldQuantity = $($txtQuantity).val();
                        var sNewQuantity = (parseFloat(sOldQuantity) + parseFloat(quantity)).toString();
                        $txtQuantity.val(sNewQuantity);
                        result = true;
                        trID = $tr.attr("id").replace("tr_","");
                        
                        //return false;——跳出所有循环；相当于 javascript 中的 break 效果。
                        //return true;——跳出当前循环，进入下一个循环；相当于 javascript 中的 continue 效果
                        return false; //跳出循环；
                    }
                }
            });

            if (result == true) {
                formEditListTable_caculateAmount(trID);
            }

            return result;
        }

        function formEditListTable_removeRow(rowID) {

            var $srcTable = $("#srcTable");
            $srcTable.find("#tr_" + rowID).remove();

            var dataRowCount = $srcTable.find("input[name=hfAmount]").length;
            if (dataRowCount == 0) { //如果已无数据行，则重置计数器；
                formEditListTable_RowCounter = 0;
                formEditListTable_showTbNoRecord();
            }

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
        }

        function formEditListTable_clearRows() {
            var $srcTable = $("#srcTable");
            $srcTable.find("tr[id]").remove();

            formEditListTable_setTotalAmount();
            formEditListTable_showTbNoRecord();
        }

        function formEditListTable_showTbNoRecord() {
            $("#tbNoRecord").show();
        }
        function formEditListTable_hideTbNoRecord() {
            $("#tbNoRecord").hide();
        }

        function formEditListTable_setRowNo() {
            var $srcTable = $("#srcTable");
            var $tdNos = $srcTable.find("td.tdRowNo");
            $.each($tdNos, function (n, value) {
                $(value).html(n + 1);
            });
        }

        function formEditListTable_setTotalAmount() {
            var $srcTable = $("#srcTable");
            $srcTable.find("#trTotal").remove();

            var totalRowHtml = '';
            var total = 0.00;
            var $hfAmountList = $srcTable.find("input[name=hfAmount]");

            $hfAmountList.each(function () {
                total += parseFloat($(this).val());
            });
          
            if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
                totalRowHtml += '<tr id="trTotal" style="display:none;">';

                totalRowHtml += '<td colspan="6" style="text-align:right;padding-right:5px;font-weight:bold;">合计</td>';

                totalRowHtml += '<td style="text-align:right;padding-right:5px;">';
                totalRowHtml += '<span style="font-weight:bold;" id="spanTotalAmount">' + total.toFixed(2).toString() + '</span>';
                totalRowHtml += '<input type="hidden" name="hfTotalAmount" value="' + total.toFixed(2).toString() + '" id="hfTotalAmount" />';
                totalRowHtml += '</td>';

                totalRowHtml += '<td></td>';

                totalRowHtml += '</tr>';

                $srcTable.append($(totalRowHtml));
            }
        }

        function formEditListTable_caculateAmount(rowID) {
            var $txtQuantity = $("#txtQuantity_" + rowID);
            var $txtPrice = $("#txtPrice_" + rowID);
            var sQuantity = $txtQuantity.val();
            var sPrice = $txtPrice.val();
            var amount = 0.00;

            if (sQuantity == "") {
                sQuantity = "0";
            }
            if (sPrice == "") {
                sPrice = "0";
            }

            ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
            //clearNoNum($txtQuantity[0]);
            //clearNoNum($txtPrice[0]);

            if (isNaN(sQuantity)) {
                alert("数量为无效数字！");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (isNaN(sPrice)) {
                alert("单价为无效数字.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) < 0) {  //限制数量不能超过100000
                alert("数量不能小于0或超过100000.");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }
            if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
                alert("单价不能小于0或超过100000.");
                $txtPrice.val("");
                $txtPrice.focus();
                return;
            }

            if ($txtQuantity.hasClass("error")) {
                $txtQuantity.removeClass("error");
            }
            if ($txtPrice.hasClass("error")) {
                $txtPrice.removeClass("error");
            }

            amount = parseFloat(sQuantity) * parseFloat(sPrice);

            $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
            $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

            formEditListTable_setTotalAmount();
        }

        function formEditListTable_checkTableData() {

            var result = true;

            var dataRowCount = 0;
            var $srcTable = $("#srcTable");

            $srcTable.find("input[name=txtQuantity]").each(function () {
                dataRowCount++;
                var sQuantity = $(this).val();
                if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                    alert("数量不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });

            /*
            $srcTable.find("input[name=txtPrice]").each(function () {
                var sPrice = $(this).val();
                if ($.trim(sPrice) == "" || $.trim(sPrice) == "0") {
                    alert("单价不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });
            */

            if (dataRowCount == 0) {
                alert("消费清单不能为空！");
                result = false;
            }

            return result;
        }

        function formEditListTable_clearNoNum(obj) {
            obj.value = obj.value.replace(/[^\d.]/g, "");  //清除“数字”和“.”以外的字符  
            obj.value = obj.value.replace(/^\./g, "");  //验证第一个字符是数字而不是. 
            obj.value = obj.value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的.   
            obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
        }

        //服务员============================================

        var $current_txtWaiterName = null;
        var $current_txtWaiterCode = null;
        function takeWaiter(rowID) {
            var $txtWaiterName = $("#txtWaiterName_" + rowID);
            var $txtWaiterCode = $("#txtWaiterCode_" + rowID);

            $current_txtWaiterName = $txtWaiterName;
            $current_txtWaiterCode = $txtWaiterCode;

            openFrameWindow("员工列表", 730, 419, "../datasrc/get_employee_list.aspx");
        }
        function takeEmployeeInfo(trObj) {
            closeFrameWindow();

            var employeeCode = $(trObj).find("td.employeeCode").eq(0).html();
            var employeeName = $(trObj).find("td.employeeName").eq(0).html();

            $current_txtWaiterCode.val(employeeCode);
            $current_txtWaiterName.val(employeeName);
        }
        function clearWaiters() {
            var $srcTable = $("#srcTable");
            $srcTable.find("input.waiterName").each(function () {
                $(this).val("");
            });
            $srcTable.find("input.waiterCode").each(function () {
                $(this).val("");
            });
        }

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<%
    if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Free ||
        VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevel == VA.Modules.JDingCYT.Core.Enums.SoftLevel.Basic)
    {
        base.ShowSoftFunctionLimitNote(VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName);
    }
%>

<div class="centerFormTitle">
   <h1>赠品划次</h1>
</div>

<!--#include file="../include/memberinfo.aspx"--> 

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">消费清单</td>
</tr>
</table>
<table cellspacing="0" class="formEditListTable" id="srcTable" style="width:700px;margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:70px;text-align:center;">项目代码</td>
<td style="width:300px;text-align:center;">项目品名</td>
<td style="width:50px;text-align:center;">单位</td>
<%--<td style="width:50px;text-align:center;">单价</td>   --%> 
<td style="width:70px;text-align:center;">划次数量</td>
<%--<td style="width:70px;text-align:center;">金额</td>--%>
<td style="width:70px;text-align:center;">服务员</td>
<td style="text-align:center;">操作</td>
</tr>    
</thead>    

<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:center;height:70px;">
    暂无数据
</td>
</tr>
</table>

<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:right;">
    添加商品/服务项目：
    <VACTL:TextBox ID="txtItemName" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_member_chargeitems.aspx',true,true,450,180);"
                Width="210px"
                />
    <asp:HiddenField runat="server" id="txtItemName_hiddenValue" />  
    <asp:HiddenField runat="server" id="txtItemName_CustomParms" />

     服务员：
    <VACTL:TextBox ID="txtWaiter" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_employees.aspx',true,true,300,180);"
                Width="110px"
                />
    <asp:HiddenField runat="server" id="txtWaiter_hiddenValue" />  
    <input type="button" id="btnClearWaiters" class="simpleBtn" onclick="clearWaiters()" value="清除服务员" />    
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">操 作 员：</td>
<td>
    <%= base.EmployeeName %>
</td>
</tr>
<tr>
<td class="th">消费备注：</td>
<td>
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="580px"
        MaxLength="100"
        />        
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnNext" class="btn" style="width:80px" onclick="confirm()" value="划次" />
    <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    <asp:HiddenField ID="hfKey" runat="server" />

</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<!--确认窗口-->    
<div id="winConfirm" style="display:none;">

    <div style="width:300px;margin:auto;">
    
    <br />

    <div class="centerFormTitle">
        <h1>确认划次信息</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;width:300px;">
    <tr>
    <td class="th">操 作 员：</td>
    <td>    
	    <span id="span_Confirm_OperatorName"><%= base.EmployeeName %></span>
    </td>
    </tr>
    <tr>
    <td class="th">划次日期：</td>
    <td>    
	    <span id="span1"><% = DateTime.Now.ToString("yyyy-MM-dd") %></span>
    </td>
    </tr>
   <%-- <tr>
    <td class="th">合计金额：</td>
    <td>    
	    <span id="span_Confirm_TotalAmount" style="font-weight:bold;"></span>
    </td>
    </tr>   --%>
    <tr>
    <td class="th">支付方式：</td>
    <td>    
        <span id="span_Confirm_PayTypeName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td colspan="2" class="footer">

        <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />   

        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="确定" />
        <input type="button" id="btnCancel" class="btn" style="width:80px" onclick="cancelSave()" value="取消" />
    </td>
    </tr>
    </table>
    </div>

</div><!--winConfirm.END-->

</form>
</body>
</html>

