﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="favitem_takeitems.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.favitem_takeitems" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>常用收费项目管理-选择收费项目</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/editlist.aspx"-->  
    <script type="text/javascript">

        var $hiddenKeyStorage = null;
        var keyArray = new Array();
        
        //选择全部记录
        function selectAllRecords(){
            var requestType = "GET";
            var url = pageName + "?act=get";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                if (data.indexOf("01|") != -1) {
                    showActResult(data, false);
                }
                else {
                    $hiddenKeyStorage.val(data);
                    keyArray = data.split(',');
                    //alert(keyArray.length);
                    selectRows();
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        //根据keyArray数组的值来选中行；
        function selectRows() {
            var $dataTable = $("#tablebody");
            var $dataRows = $dataTable.find("tr");
            $dataRows.each(function () {
                var checkboxObj = $(this).find(":checkbox")[0];
                var key = this.cells[2].innerHTML;

                if (keyArray.indexOf(key) != -1) {
                    smartListTable_selectTR(true, $(this));
                    checkboxObj.checked = true;
                }
            });
        }

        //选择当页记录
        function selectCurrentPageRecords() {
            var tableID = "tb1_header";
            smartListTable_selectAll(tableID, true);
        }

        //列表页数据加载完毕后会自动调用该函数；
        function afterDataListLoaded() {            
            selectRows();
        }
        
        function JTongSmartListTable_afterSelect(trObj) {
            var key = trObj.cells[2].innerHTML;            
            addItem(key);
        }

        function JTongSmartListTable_afterCancelSelect(trObj) {
            var key = trObj.cells[2].innerHTML;
            removeItem(key);
        }

        function addItem(key) {
            if (key == "项目代码") {
                return;
            }
            if (keyArray.indexOf(key) == -1) {
                keyArray.push(key);
                saveKeyString();
            } 
        }

        function removeItem(key) {
            var index = keyArray.indexOf(key);
            if (index != -1) {
                keyArray.splice(index, 1);
                saveKeyString();
            }
        }

        function saveKeyString() {
            var keyString = keyArray.join(",");
            $hiddenKeyStorage.val(keyString);
        }

        function ok() {
            var keyString = keyArray.join(",");
            $hiddenKeyStorage.val(keyString);

            var requestType = "POST";
            var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = { keyString: keyString };
            var successFN = function (data, textStatus) {
                if (data == "ok") {
                    showActResult("添加成功！", true);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data, false);
                }
                else {
                    showActResult("添加失败：" + data, false);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        function showActResult(actDesc, actResult) {
            if (actResult) {
                $.messager.alert('操作结果', actDesc, 'info', function () {
                    try {
                        if (window.parent != window.self) {
                            window.parent.closeFrameWindow();
                            window.parent.refresh();
                        }
                    } catch (e) { }
                });
            } else {
                $.messager.alert('操作结果', actDesc, 'warning')
            }
        }

        function cancel() {
            window.parent.closeFrameWindow();
        }

        $(function(){                   
            initListPage();
            $hiddenKeyStorage = $("#hiddenKeyStorage");
        });
    </script>

</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">    

    <div id="toolBar">
        <a href="javascript:selectAllRecords()" class="jtongui-toolbarbutton" icon="icon-add">选择全部记录</a>
        <a href="javascript:selectCurrentPageRecords()" class="jtongui-toolbarbutton" icon="icon-add">选择本页记录</a>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>

    </div>
    <!--toolBar.END-->

    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>

        <asp:DropDownList ID="ddlItemType" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlItemType_SelectedIndexChanged">           
        </asp:DropDownList>

        <asp:DropDownList ID="ddlCategory" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlCategory_SelectedIndexChanged">           
        </asp:DropDownList>

       <%-- <asp:DropDownList ID="ddlChargeItemStatus" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlChargeItemStatus_SelectedIndexChanged">           
        </asp:DropDownList>--%>
                               
        <asp:DropDownList ID="ddlSearchField" runat="server" EnableViewState="false">
        <asp:ListItem Value="">检索字段</asp:ListItem>
        <asp:ListItem Value="1">项目名称</asp:ListItem>
        <asp:ListItem Value="2">项目代码</asp:ListItem>
        </asp:DropDownList>               
                 
      <%--  <asp:DropDownList ID="ddlSearchType" runat="server" EnableViewState="false">
        <asp:ListItem Value="1">模糊匹配</asp:ListItem>
        <asp:ListItem Value="2">精确匹配</asp:ListItem>
        </asp:DropDownList>   --%>            

        <asp:TextBox ID="txtKeyWords" runat="server"
            CssClass="input"
            Width="100px" />
   
        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div><!--searchBar.END-->     

    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;"><input type="checkbox" id="ckb_selectAll"/></td>
        <td style="width:60px;text-align:center;">项目类型</td>
        <td style="width:60px;text-align:center;">项目代码</td>
        <td style="width:200px;text-align:center;">项目名称</td>
        <td style="width:60px;text-align:center;">输入码</td>
        <td style="width:50px;text-align:center;">单位</td>
        <td style="width:60px;text-align:center;">单价</td>	 	 
        <td style="width:60px;text-align:center;">提成类型</td>	 
        <td style="width:60px;text-align:center;">提成系数</td>
        <td style="width:60px;text-align:center;">会员折扣</td>
        <td style="width:70px;text-align:center;">创建人</td>
        <td style="width:70px;text-align:center;">创建日期</td>          
        <td style="width:120px;text-align:center;">备注</td>	  
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table id="tablebody" cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td style="text-align:center;"><input type="checkbox" name="ckb_dataItem" value="<%# Eval("RID")%>" /></td>
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.ChargeItemTypeConverter.Convert_Value_ToText(Eval("Item_Type").ToString(), true)%></td>
        <td align="center"><%# Eval("Item_Code")%></td>
        <td align="left"><%# Eval("Item_Name")%></td>        
        <td align="center"><%# Eval("Input_Code")%></td>
        <td align="center"><%# Eval("Unit")%></td>        
        <td align="center"><%# Eval("Price")%></td>
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.ChargeItemCommisionTypeConverter.Convert_Value_ToText(Eval("Commision_Type").ToString(),true)%></td>
        <td align="center"><%# Eval("Commision_XS")%></td>
        <td align="center"><%# Eval("Member_Discount")%></td>
        <td align="center"><%# Eval("Operator_Name")%></td>	    
        <td align="center"><%# String.Format("{0:yyyy-MM-dd}",Eval("Create_Date"))%></td>
        <td align="left"><%# Eval("Remark")%></td>  
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <div id="divPagerInfo" style="display:none">
        <%=base.pageInfo%>
    </div>

    <input type="hidden" id="hidden_pageCnt" value="<% = base.PageCnt%>" />
    <input type="hidden" id="hidden_rdCnt" value="<% = base.RdCnt%>" />
    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <div id="pagerBar">
       ……
    </div><!--pageNavBar.END-->    

    <div id="bottomToolBar">                                          
        <input type="button" id="btnSubmit" class="btn" style="width:100px" onclick="ok()" value="添加" />
        <input type="button" id="btnCancel" class="btn" style="width:100px" onclick="cancel()" value="取消" />
    </div><!--toolBar.END-->  
    
    <asp:HiddenField runat="server" ID="hfCurrPage" EnableViewState="true" />
    
</div>


</form>
</body>
</html> 