﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="charge_view.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.charge_view" %>

<%@ Register src="../mainbiz/uc_foodmenu.ascx" tagname="uc_foodmenu" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>收银/结账详情</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <link href="/app_themes/<% = webSiteConfig.ThemeName %>/css/pages/consume.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->          
    <script type="text/javascript">

        function cancel() {
            closeActivatedTopestWindow();
        }

        function cxBill() {
            var bizNo = $("#hfKey").val();
            window.location.href = "charge_cx.aspx?bizno=" + bizNo;
        }

        function setInvoiceGivedFlag(flag){
            var requestType = "POST";
            var url = pageName + "?act=setinvoicegivedflag&invoicegivedflag=" + flag;
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                if (data == "ok") {
                    showActResult("更改成功！", true, doAfterAdd);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd);
                }
                else {
                    showActResult("更改失败：" + data, false, doAfterAdd);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        function doAfterAdd(actResult) {
            if (actResult) {
                window.location.reload();
            }
        }

    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">收银/结账详情</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">收银单号：</td>
<td>
    <% = base.chargeInfo.BizNo %>
</td>
</tr>
<tr>
<td class="th">顾客类型：</td>
<td>
    <% = VA.Modules.JDingCYT.Core.Enums.CustomerTypeConverter.Convert_Value_ToText(base.chargeInfo.Customer_Type) %>
    <% if (base.chargeInfo.Customer_Type == VA.Modules.JDingCYT.Core.Enums.CustomerType.Member.ToString("d")) { %>
    卡号：<% = base.chargeInfo.CardNo %>，姓名：<% = base.chargeInfo.Name %>
    <% } %>
</td>
</tr>
<tr>
<td class="th">收银类型：</td>
<td>
    <% = VA.Modules.JDingCYT.Core.Enums.ConsumeChargeConverter.OrderTypeConverter.Convert_Value_ToText(base.chargeInfo.Order_Type) %>
    <% if (base.chargeInfo.Order_Type == VA.Modules.JDingCYT.Core.Enums.ConsumeCharge.OrderType.Dianneixiaofei.ToString("d")) { %>
    （订单号：<% = base.chargeInfo.Order_No %>，台号：<% = base.chargeInfo.Table_No %>，序号：<% = base.chargeInfo.Order_SequenceNo %>）
    <% } %>
</td>
</tr>
</table>

<%--<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">消费清单</td>
</tr>
</table>--%>
<div class="formEditListTableWrapper" style="min-height:255px;overflow:auto;overflow-x:hidden;">
    
    <asp:Repeater ID="rpChargeItems" Runat="server" EnableViewState="False"  >    
    <HeaderTemplate>
        <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:-1px;">
        <thead>
        <tr>
        <td style="width:30px;text-align:center;">No.</td>
   <%--     <td style="width:70px;text-align:center;display:none;">项目代码</td>--%>
        <td style="width:210px;text-align:center;">项目名称</td>
        <td style="width:40px;text-align:center;">单位</td>
        <td style="width:50px;text-align:center;">单价</td>    
<%--        <td style="width:60px;text-align:center;">折后单价</td>  --%>  
        <td style="width:40px;text-align:center;">数量</td>
        <td style="width:70px;text-align:center;">折后金额</td>
        <td style="width:60px;text-align:center;">优惠</td>
        <td style="width:50px;text-align:center;">服务员</td>
        <td style="width:30px;text-align:center;">赠送</td>
        </tr>    
        </thead>    
        <tbody>                 
    </HeaderTemplate>
    <ItemTemplate>
        <tr>
            <td style="text-align:center;"><%# Container.ItemIndex + 1 %></td>
            <td style="text-align:left;"><%# Eval("Item_Name")%></td>
            <td style="text-align:center;"><%# Eval("Unit")%></td>
            <td style="text-align:center;"><%# Eval("Price")%></td>
            <%--<td style="text-align:center;"><%# (Convert.ToDecimal(Eval("Charges"))/Convert.ToDecimal(Eval("Quantity"))).ToString("F2")%></td>--%>
            <td style="text-align:center;"><%# Eval("Quantity")%></td>
            <td style="text-align:center;"><%# Eval("Charges")%></td>
            <td style="text-align:center;"><%# Eval("Discounts")%></td>
            <td style="text-align:center;"><%# Eval("Waiter_Name")%></td>
            <td style="text-align:center;"><%# Eval("Donate_Flag").ToString() == "1" ? "√" : ""%></td>
        </tr>
    </ItemTemplate>            
    <FooterTemplate>            
        </tbody>
        </table>
    </FooterTemplate>
    </asp:Repeater>  
    
    <table cellspacing="0" class="formEditListTable" id="srcTable_NoData" runat="server" style="margin-top:-1px;">
    <thead>
    <tr>
    <td style="width:30px;text-align:center;">No.</td>
<%--     <td style="width:70px;text-align:center;display:none;">项目代码</td>--%>
    <td style="width:210px;text-align:center;">项目名称</td>
    <td style="width:40px;text-align:center;">单位</td>
    <td style="width:50px;text-align:center;">单价</td>    
    <td style="width:60px;text-align:center;">折后单价</td>    
    <td style="width:40px;text-align:center;">数量</td>
    <td style="width:70px;text-align:center;">折后金额</td>
    <td style="width:60px;text-align:center;">优惠</td>
    <td style="width:50px;text-align:center;">服务员</td>
    <td style="width:30px;text-align:center;">赠送</td>
    </tr>    
    </thead>    
    </table>
                           

</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">消费总额：</td>
<td style="width:119px;">
    <% = base.chargeInfo.Costs.ToString("F2") %>
</td>
<td class="th">优惠金额：</td>
<td>
    <% = base.chargeInfo.Discounts.ToString("F2") %>         
</td>
<td class="th">实收金额：</td>
<td>
   <% = base.chargeInfo.PayAmount.ToString("F2") %>
</td>
</tr>
<tr>
<td class="th">支付方式：</td>
<td colspan="5">
    <% = base.chargeInfo.PayType_Desc %>
</td>
</tr>
<tr>
<td class="th">结账时间：</td>
<td>
    <% = VA.Utils.DateHelper.GetLongTimeString_PrecisionToMinute(base.chargeInfo.Operate_Date) %>
</td>
<td class="th">操 作 员：</td>
<td>
    <% = base.chargeInfo.Operator_Name %>
</td>
<td class="th">发票开具：</td>
<td>
    <% = VA.Modules.JDingCYT.Core.Enums.ConsumeChargeConverter.InvoiceGivedConverter.Convert_Value_ToText(base.chargeInfo.Invoice_Gived, true) %>
</td>
</tr>
<tr>
<td class="th">收银备注：</td>
<td colspan="5">
    <% = base.chargeInfo.Remark %>
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">
    
    <% if (base.chargeInfo.Bill_Type == VA.Modules.JDingCYT.Core.Enums.BillType.CXBill.ToString("d") ||
           base.chargeInfo.Bill_Status == VA.Modules.JDingCYT.Core.Enums.BillStatus.Canceled.ToString("d")) {%>
        <input type="button" id="Button2" class="btn" style="width:80px" value="撤销" disabled="disabled" />   
    <% } else { %>
        <input type="button" id="btnNext" class="btn" style="width:80px" onclick="cxBill()" value="撤销" />        

        <% if (base.chargeInfo.Invoice_Gived == VA.Modules.JDingCYT.Core.Enums.ConsumeCharge.InvoiceGived.Yes.ToString("d")) { %>
            <input type="button" id="Button3" class="btn" style="width:80px" value="发票未开" onclick="setInvoiceGivedFlag('0')" />
        <% } else { %>
            <input type="button" id="Button4" class="btn" style="width:80px" value="发票已开" onclick="setInvoiceGivedFlag('1')" />
        <% } %>

    <% } %>
        
    <input type="button" id="Button1" class="btn" style="width:80px" onclick="cancel()" value="关闭" /> 

    <asp:HiddenField ID="hfKey" runat="server" /> <!--保存BizNo-->
    <asp:HiddenField ID="hfChargeID" runat="server" /> <!--保存Charge_ID-->

</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->


</form>
</body>
</html>

