﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="charge_group_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.charge_group_edit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">

    function save() {

        //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
        var validationResult = Page_ClientValidate('');
        if (!validationResult) {
            return;
        }

        if (!formEditListTable_checkTableData()) {
            return;
        }

        var flag = "0";
        if ($("#hfKey").val() != "") {
            flag = "1";
        }

        if (flag == 0) {
            add();
        }
        else {
            update();
        }
    }

    function add() {
        var requestType = "POST";
        var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("添加成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("添加失败：" + data, false, doAfterAdd);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function update() {
        var requestType = "POST";
        var url = pageName + "?act=update";
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("修改成功！", true, doAfterUpdate);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterUpdate);
            }
            else {
                showActResult("修改失败：" + data, false, doAfterUpdate);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.completeReload();
                }
            } catch (e) { }
            resetPage();
        }
    }
    function doAfterUpdate(actResult) {
        if (actResult) {
            try {
                if (window.parent != window.self) {
                    window.parent.closeFrameWindow();
                    window.parent.reload();
                }
            } catch (e) { }
        }
    }

    function resetPage() {

        $("#txtGroupName").val("");
        $("#txtRemark").val("");

        formEditListTable_clearRows();
        setSmartDownDownListControlPosition();

        clearInputValidatorError();

        $("#txtGroupName").focus();
    }
   
    /**商品/服务项目添加操作.BEGIN**********************/

    function JTongSmartDropDownList_AfterTakeValue(JTongSmartDropDownList_inputObjID, selectedRow) {
        if (selectedRow != null) {

            if (JTongSmartDropDownList_inputObjID == "txtItemName") {
                
                var itemType = $(selectedRow.cells[0]).find("input:hidden[name=hfItemType]").eq(0).val();
                var itemCategory = $(selectedRow.cells[0]).find("input:hidden[name=hfItemCategory]").eq(0).val();
                var itemCode = selectedRow.cells[1].innerHTML;
                var itemName = selectedRow.cells[2].innerHTML;
                var unit = selectedRow.cells[3].innerHTML;
                var price = selectedRow.cells[4].innerHTML;
                var quantity = 1;

                formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity);
                $("#txtItemName").val("");
            }
        }

        //返回true，继续取值；返回false，取消取值；
        return true;
    }

    /**商品/服务项目添加操作.END**********************/
    
    $(function () {
        $("#txtGroupName").focus();
    });

    </script>

    <script type="text/javascript">

        var formEditListTable_RowCounter = 0;

        function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity) {
            
            formEditListTable_RowCounter++;

            var $srcTable = $("#srcTable");
            var srcTableID = $srcTable.attr("id");

            //如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
            if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
                return;
            }

            var rowHtml = '';
            var $row = null;
            var rowCnt = $srcTable[0].rows.length;
            var rowID = formEditListTable_RowCounter;

            itemName = itemName.replace(/'/g, "‘");
            unit = unit.replace(/'/g, "‘");
            
            var amount = price * quantity;

            rowHtml += '<tr id="tr_' + rowID + '">';
            rowHtml += '<td style="text-align:center;" class="tdRowNo"></td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + itemCode + '</span>';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:left;padding-left:5px;">';
            rowHtml += '<span>' + itemName + '</span>';
            rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
            rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
            rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
            rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" />';            
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;">';
            rowHtml += '<span>' + unit + '</span>';
            rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
            rowHtml += '</td>';
            
            
            rowHtml += '<td>';            
            rowHtml += '<input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" />';
            rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" />';
            rowHtml += '</td>';

            rowHtml += '<td style="text-align:center;"><a href="javascript:formEditListTable_removeRow(' + rowID + ')">删除</a></td>';
            rowHtml += '</tr>';
            
            //调试代码；
            //$("#txtRemark").val(rowHtml);
            
            $row = $(rowHtml);
            $srcTable.append($row);

            formEditListTable_setRowNo();
            formEditListTable_setTotalAmount();
            formEditListTable_hideTbNoRecord();

            setSmartDownDownListControlPosition();
        }

        function formEditListTable_setTotalAmount() {
            return;
        }

        function formEditListTable_caculateAmount(rowID) {
            var $txtQuantity = $("#txtQuantity_" + rowID);
            if (sQuantity == "") {
                sQuantity = "0";
            }

            if (isNaN(sQuantity)) {
                alert("数量为无效数字！");
                $txtQuantity.val("");
                $txtQuantity.focus();
                return;
            }            
        }

        function formEditListTable_checkTableData() {

            var result = true;

            var dataRowCount = 0;
            var $srcTable = $("#srcTable");

            $srcTable.find("input[name=txtQuantity]").each(function () {
                dataRowCount++;
                var sQuantity = $(this).val();
                if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                    alert("数量不能为空或0！");
                    $(this).focus();
                    $(this).addClass("error");
                    result = false;
                    return;
                }
            });            

            if (dataRowCount == 0) {
                alert("组套包含的商品/服务项目不能为空！");
                result = false;
            }

            return result;
        }

        function formEditListTable_clearNoNum(obj) {
            obj.value = obj.value.replace(/[^\d.]/g, "");  //清除“数字”和“.”以外的字符  
            obj.value = obj.value.replace(/^\./g, "");  //验证第一个字符是数字而不是. 
            obj.value = obj.value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的.   
            obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
        }

        function setSmartDownDownListControlPosition() {
            
            //var top = 0;

            //var $inputObj = $("#txtItemName");

            ////获得元素的顶端偏移量
            //top = $inputObj.offset().top - 179;

            //$("#txtItemName_Position_Top").val(top);
        }

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">添加组套</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr>
<td class="th">(<span class="note mustfill">*</span>)组套名称：</td>
<td>
    <VACTL:TextBox ID="txtGroupName" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="300px"
            CanBeNull="No"
            FieldName="组套名称"
            MaxLength="25" />  
</td>
</tr>
</table>
<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">包含的商品/服务项目</td>
</tr>
</table>
<div class="formEditListTableWrapper" style="min-height:240px;">
<table cellspacing="0" class="formEditListTable" id="srcTable" style="width:700px;margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:70px;text-align:center;">项目代码</td>
<td style="width:200px;text-align:center;">项目品名</td>
<td style="width:50px;text-align:center;">单位</td>
<td style="width:50px;text-align:center;">数量</td>
<td style="text-align:center;">操作</td>
</tr>    
</thead>    
<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" style="margin-top:-1px;width:100%;">
<tr>
<td style="text-align:center;height:210px;">
    暂无数据
</td>
</tr>
</table>
</div>

<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:right;">
    菜品/商品：
    <VACTL:TextBox ID="txtItemName" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_chargeitems.aspx',true,true,450,180,0,false);"
                Width="310px"
                />
    <asp:HiddenField runat="server" id="txtItemName_hiddenValue" /> 
    <asp:HiddenField runat="server" id="txtItemName_CustomParms" Value="range=2&itemtype=2,3" /> 
<%--    <asp:HiddenField runat="server" id="txtItemName_Position_Left" Value="255" /> 
    <asp:HiddenField runat="server" id="txtItemName_Position_Top" Value="70" /> --%>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable">
<tr>
<td class="th">备注：</td>
<td>    
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="580px"
        MaxLength="100"     
        />        
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <% if (base.flag == 0) { %>
    <input type="button" id="Button1" class="btn" style="width:100px" onclick="save()" value="保存" />
    <input type="button" id="Button2" class="btn" style="width:100px" onclick="resetPage()" value="重置" />
    <% } else { %>
    <input type="button" id="btnUpdate" runat="server" class="btn" style="width:100px" onclick="save()" value="保存" />
    <asp:Label ID="lblNote" runat="server" ForeColor="Red"></asp:Label>
    <% } %>   

    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<% if (base.flag == 1){ %>
<%    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.Consume.ChargeGroupItemInfo item in base.groupInfo.Items)
    {
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");
        string quantity = item.Quantity.ToString();

        Response.Write("{");
        Response.Write("\"itemType\":\"" + itemType + "\",\""+ itemCategory +"\":\""+ itemCategory +"\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\"");

        if (i == base.groupInfo.Items.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    for (var i = 0; i < itemList.length; i++) {
        formEditListTable_addRow(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity);            
    }
</script>

<% } %>


</form>
</body>
</html>

