﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="charge_editlist_kc.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.charge_editlist_kc" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>快餐收银记录</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <link href="/admin/app_themes/<% = webSiteConfig.ThemeName %>/css/edit.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/editlist.aspx"-->  
    <script type="text/javascript"> 
        
        //单条撤销；
        function scx(keyValue, bizNo) {

            openTopestWindow("收银撤销(" + bizNo + ")", "/modules/cyt/consume/charge_cx.aspx?bizno=" + bizNo);
            return;

            $('#winCX').css("display", "block");
            $('#winCX').window({
                width: 350,
                height: 250,
                modal: true,
                minimizable: false,
                collapsible: false,
                title: '填写撤单原因'
            });

            $("#hf_BCXKey").val(keyValue);
            $("#hf_BCXBizNo").val(bizNo);
            $("#span_bcxBizNo").html(bizNo);
        }

        //撤销执行；
        function CXSave() {
            var keyValue = $("#hf_BCXKey").val();
            //singleActWrapper("CX", keyValue, "确定要撤单吗？", "");            
            var customArg = $("#ddlCXReason").find("option:selected").text();
            if (customArg == "其它原因") {
                customArg = $.trim($("#txtCustomReason").val());
                if (customArg == "") {
                    JTongAlert("提示", "请填写撤单原因！", "warning", function () {
                        $("#txtCustomReason").focus();
                    });
                    return;
                }
            }

            singleActWrapper("CX", keyValue, "", customArg);
        }

        //当服务端执行成功时，在弹出操作成功提示后，会执行该方法。
        function doWhenServerActSuc(currActName, customArg) {
            if (currActName == "CX") {
                closeWindow();

                var bizNo = customArg;

                if ($("#ckbPrintBill")[0].checked == true) {
                    printBill("1", bizNo);
                }

                if ($("#ckbNotify")[0].checked == true) {
                    ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "consumecharge", "bizno": bizNo });
                }

                window.location.reload(); //重新刷新页面，以便重新计算汇总金额。
            }
        }

        //关闭窗口；
        function closeWindow() {
            $('#winCX').window("close");
        }

        //添加；
        function add() {
            openTopestWindow("消费收银", "/modules/cyt/consume/charge.aspx");
        }

        function sviewDetail(rid) {
            //openFrameWindow("消费明细", 780, 300, "../consume/charge_details.aspx?masterid=" + rid);
            openTopestWindow("收银/结账详情(" + rid + ")", "/modules/cyt/consume/charge_view.aspx?chargeid=" + rid);
        }

        //行双击事件；
        function JTongSmartListTable_trDblclick(trObj) {
            var chargeID = $(trObj.cells[0]).find("input:hidden[name=hfChargeID]").eq(0).val();

            sviewDetail(chargeID);
            event.stopPropagation();  //阻止事件冒泡，避免行被选中；
        }

        //显示汇总金额；
        function afterDataListLoaded() {
            $("#statBar").html($("#divStatInfo").html());
        }

        //设置结账输入框的行为；
        function setDayAccountControlBehavior() {
            var keywords_ToolTip = "结账ID";
            var $txtDayAccountID = $("#txtDayAccountID");
            var $ddlDayAccountFlag = $("#ddlDayAccountFlag");
            $ddlDayAccountFlag.change(function () {
                var flag = $(this).val();
                if (flag == "2") { //已结账
                    $txtDayAccountID.removeAttr("disabled", "disabled");
                    $txtDayAccountID.val(keywords_ToolTip);
                } else {
                    $txtDayAccountID.attr("disabled", "disabled");
                    $txtDayAccountID.val("");
                }
            });

            var flag = $ddlDayAccountFlag.val();
            if (flag == "2") { //已结账
                $txtDayAccountID.removeAttr("disabled", "disabled");
                if ($txtDayAccountID.val() == "") {
                    $txtDayAccountID.val(keywords_ToolTip);
                }
            } else {
                $txtDayAccountID.attr("disabled", "disabled");
                $txtDayAccountID.val("");
            }

            $txtDayAccountID.addClass("keywords-toolTip");

            $txtDayAccountID.focus(function () {
                var keywords = $(this).val();
                if (keywords == keywords_ToolTip) {
                    $txtDayAccountID.val("");
                    $txtDayAccountID.removeClass("keywords-toolTip");
                }
            });

            $txtDayAccountID.focusout(function () {
                var keywords = $(this).val();
                if (keywords == "") {
                    $txtDayAccountID.val(keywords_ToolTip);
                    $txtDayAccountID.addClass("keywords-toolTip");
                }
            });
        }

        $(function () {
            initListPage();
            setDayAccountControlBehavior();

            $("#txtCustomReason").hide();
            $("#ddlCXReason").change(function () {
                var reasonText = $("#ddlCXReason").val();
                if (reasonText == "其它原因") {
                    $("#txtCustomReason").show();
                    $("#txtCustomReason").focus();
                } else {
                    $("#txtCustomReason").hide();
                }
            });
        });
    </script>
</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">        
    
    <div id="toolBar">    
      <%--  <a href="javascript:add()" class="jtongui-toolbarbutton" icon="icon-add">消费收银</a> --%>                     
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>            
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>

    </div><!--toolBar.END-->   
                     
    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>
                
        <asp:DropDownList ID="ddlOrderType" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlOrderType_SelectedIndexChanged"
             Visible="false">
        </asp:DropDownList> 

        <asp:DropDownList ID="ddlCustomerType" runat="server" 
             AutoPostBack="true"
             OnSelectedIndexChanged="ddlCustomerType_SelectedIndexChanged">        
        </asp:DropDownList>          

        <asp:DropDownList ID="ddlSearchField" runat="server">
        <asp:ListItem Value="">检索字段</asp:ListItem>
        <asp:ListItem Value="1">会员姓名</asp:ListItem>
        <asp:ListItem Value="2">会员卡号</asp:ListItem>
        <asp:ListItem Value="3">操作员姓名</asp:ListItem>
        <asp:ListItem Value="4">消费单号</asp:ListItem>
        <asp:ListItem Value="5">付款方式</asp:ListItem>
        </asp:DropDownList>               
                 
       <%-- <asp:DropDownList ID="ddlSearchType" runat="server">
        <asp:ListItem Value="1">模糊匹配</asp:ListItem>
        <asp:ListItem Value="2">精确匹配</asp:ListItem>
        </asp:DropDownList>     --%>          

        <asp:TextBox ID="txtKeyWords" runat="server"
            CssClass="input keywords"
            Width="80px" />

        <asp:DropDownList ID="ddlDateRule" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">收银日期</asp:ListItem>
        <asp:ListItem Value="1">今天</asp:ListItem>
            <asp:ListItem Value="2">昨天</asp:ListItem>
            <asp:ListItem Value="3">前天</asp:ListItem>
            <asp:ListItem Value="4">近两天</asp:ListItem>
            <asp:ListItem Value="5">近三天</asp:ListItem>
            <asp:ListItem Value="6">近一周</asp:ListItem>
            <asp:ListItem Value="7">近一月</asp:ListItem>
            <asp:ListItem Value="8">上月</asp:ListItem>
            <asp:ListItem Value="9">本月</asp:ListItem>
            <asp:ListItem Value="10">自定义</asp:ListItem>
        </asp:DropDownList>  

        <VACTL:TextBox ID="txtBeginDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />  
        -      
        <VACTL:TextBox ID="txtEndDate" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="80px"            
            onfocus="laydate()"
            MaxLength="20" />                
        
        <asp:DropDownList ID="ddlDayAccountFlag" runat="server" EnableViewState="false">
        <asp:ListItem Value="" Selected="True">是否日结</asp:ListItem>
        <asp:ListItem Value="1">未日结</asp:ListItem>
        <asp:ListItem Value="2">已日结</asp:ListItem>
        </asp:DropDownList>          
        <VACTL:TextBox ID="txtDayAccountID" Runat="server"
            EnableViewState="False"
            CssClass="input"
            Width="60px"            
            MaxLength="20" />        

        <asp:DropDownList ID="ddlInvoiceGived" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlInvoiceGived_SelectedIndexChanged">
        <asp:ListItem Value="" Selected="True">发票开具</asp:ListItem>
        <asp:ListItem Value="0">未开</asp:ListItem>
        <asp:ListItem Value="1">已开</asp:ListItem>
        </asp:DropDownList>   

        <asp:DropDownList ID="ddlOrderBy" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlOrderBy_SelectedIndexChanged">
        <asp:ListItem Value="">排序规则</asp:ListItem>            
        <asp:ListItem Value="Charge_ID|ASC">按收银顺序-正序</asp:ListItem>        
        <asp:ListItem Value="Charge_ID|DESC">按收银顺序-倒序</asp:ListItem>
        <asp:ListItem Value="Charges|DESC">按收款金额-由多到少</asp:ListItem>
        <asp:ListItem Value="Charges|ASC">按收款金额-由少到多</asp:ListItem>
        </asp:DropDownList>   

        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="查询" 
             Onclick="btnSearch_Click" />
        
        </ContentTemplate>
        </asp:UpdatePanel>

    </div><!--searchBar.END-->    

    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <%--<td style="width:30px;text-align:center;"><input type="checkbox" id="ckb_selectAll"/></td>--%>
        <td style="width:30px;text-align:center;">No.</td>      
        <td style="width:100px;text-align:center;">收银时间</td>	      
        <td style="width:80px;text-align:center;">收银单号</td>        
        <%--<td style="width:80px;text-align:center;">订单号</td>
        <td style="width:60px;text-align:center;">收银类型</td>
        <td style="width:30px;text-align:center;">台号</td>--%>
        <td style="width:30px;text-align:center;">序号</td>
        <td style="width:30px;text-align:center;">详情</td>       
        <td style="width:30px;text-align:center;">撤单</td>	                          	    
        <td style="width:30px;text-align:center;">打票</td>      
        <td style="width:60px;text-align:center;">消费总额</td>        	 	 
        <td style="width:60px;text-align:center;">优惠金额</td>        	 	 
        <%--<td style="width:70px;text-align:center;">应收金额</td>  --%>      	 	 
        <td style="width:70px;text-align:center;">实收金额</td>        	 	 
        <td style="width:80px;text-align:center;">付款方式</td>
        <td style="width:70px;text-align:center;">顾客类型</td>
        <td style="width:70px;text-align:center;">顾客姓名</td>                        
        <td style="width:70px;text-align:center;">会员卡号</td>                   
        <td style="width:190px;text-align:center;">备注</td>   
        <td style="width:60px;text-align:center;">发票开具</td>        
        <td style="width:70px;text-align:center;">操作员</td>      
        <td style="width:100px;text-align:center;display:none;">门店</td>
        <td style="width:60px;text-align:center;">日结账ID</td>	         
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table cellpadding="3" cellspacing="0" class="tablebody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <%-- <td style="text-align:center;"><input type="checkbox" name="ckb_dataItem" value="<%# Eval("RID")%>" /></td>--%>
        <td align="center"><%# (base.currPage - 1)*base.PageSize + Container.ItemIndex + 1%>
            <input type="hidden" name="hfChargeID" value="<%# Eval("Charge_ID")%>" />
        </td>        
        <td align="center"><%# String.Format("{0:yyyy-MM-dd HH:mm}", Eval("Operate_Date"))%></td>        
        <td align="center"<%# ShowBillStyle(Eval("Bill_Status").ToString(), Eval("Bill_Type").ToString())%>><%# Eval("BizNo")%></td>         
        <%--<td align="center"><%# Eval("Order_No")%></td>        
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.ConsumeChargeConverter.OrderTypeConverter.Convert_Value_ToText(Eval("Order_Type").ToString())%></td>        
        <td align="center"><%# Eval("Table_No")%></td>   --%>
        <td align="center"><%# Eval("Order_SequenceNo")%></td>   
        <td align="center"><a href="javascript:sviewDetail(<%# Eval("Charge_ID")%>);"><img src="/admin/icons/detail.png" alt="详情"/></a></td>         	       	                        
        <td align="center">
            <%# base.ShowCXIcon(Eval("Charge_ID").ToString(),Eval("BizNo").ToString(), Eval("Bill_Status").ToString(), Eval("Bill_Type").ToString())%>            
        </td>  
        <td align="center">
            <%# base.ShowPrintBillIcon("2",Eval("BizNo").ToString())%>            
        </td> 
        <td align="right"><%# Eval("Costs")%></td>        
        <td align="right"><%# Eval("Discounts")%></td>                
        <%--<td align="right"><%# Eval("Charges")%></td> --%>       
        <td align="right"><%# Eval("PayAmount")%></td>        
        <td align="left"><%# Eval("PayType_Desc")%></td>        
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.ConsumeChargeConverter.CustomerTypeConverter.Convert_Value_ToText(Eval("Customer_Type").ToString())%></td>
        <td align="center"><%# Eval("Name")%></td>        
        <td align="center"><%# Eval("CardNo")%></td>                
        <td align="left"><%# Eval("Remark")%></td>          
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.ConsumeChargeConverter.InvoiceGivedConverter.Convert_Value_ToText(Eval("Invoice_Gived").ToString(), true)%></td>
        <td align="center"><%# Eval("Operator_Name")%></td> 
        <td align="center" style="display:none;"><%# Eval("Shop_Name")%></td> 
        <td align="center"><%# Eval("Settle_Account_ID")%></td>                       
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <div id="divPagerInfo" style="display:none">
        <%=base.pageInfo%>
    </div>

    <div id="divStatInfo" style="display:none">
        共 <span style="font-weight:bold;"><%=base.RdCnt%></span> 条收银记录，
        消费总额合计：<span style="font-weight:bold;"><%= base.TotalCosts.ToString("F2")%></span>，
        优惠金额合计：<span style="font-weight:bold;"><%= base.TotalDiscounts.ToString("F2")%></span>，
        <%--应收金额合计：<span style="font-weight:bold;"><%= base.TotalCharges.ToString("F2")%></span>，--%>
        实收金额合计：<span style="font-weight:bold;"><%= base.TotalPayAmount.ToString("F2")%></span>&nbsp;&nbsp;
    </div>

    <input type="hidden" id="hidden_pageCnt" value="<% = base.PageCnt%>" />
    <input type="hidden" id="hidden_rdCnt" value="<% = base.RdCnt%>" />
    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <div id="statBar">
       
    </div><!--statBar.END-->

    <div id="pagerBar">
       ……
    </div><!--pageNavBar.END-->
    
    <asp:HiddenField runat="server" ID="hfCurrPage" EnableViewState="true" />
    
</div>

<!--撤单详情窗口-->
<div id="winCX" style="display:none;">

    <div style="width:300px;padding:10px;margin:auto;">

    <div class="centerFormTitle">
        <h1>填写撤单原因</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;">    
    <tr>
    <td class="th">被撤单号：</td>
    <td>   
        <span id="span_bcxBizNo" style="font-weight:bold;"></span> 
        <input type="hidden" id="hf_BCXKey" name="hf_BCXKey" />
        <input type="hidden" id="hf_BCXBizNo" name="hf_BCXBizNo" />
    </td>
    </tr>    
    <tr>
    <td class="th">撤单原因：</td>
    <td>    
        <asp:DropDownList ID="ddlCXReason" runat="server" EnableViewState="false">
        <asp:ListItem Value="客户要求" Selected="True">客户要求</asp:ListItem>
        <asp:ListItem Value="操作失误">操作失误</asp:ListItem>
        <asp:ListItem Value="其它原因">其它原因</asp:ListItem>
        </asp:DropDownList> 
        <input type="text" class="input" style="width:90px;" id="txtCustomReason" name="txtCustomReason" maxlength="20" /> 
    </td>
    </tr>
    <tr>
    <td colspan="2" style="text-align:center;">    
        
        <asp:CheckBox ID="ckbPrintBill" runat="server"
             Text="打票" />    

        <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />      
    </td>
    </tr>  
    <tr>
    <td colspan="2" class="footer">
        <input type="button" id="btnCXBill" class="btn" style="width:80px" onclick="CXSave()" value="撤单" />
        <input type="button" id="btnClose" class="btn" style="width:80px" onclick="closeWindow()" value="关闭" />
    </td>
    </tr>
    </table>

    </div>

</div> 

</form>
</body>
</html> 