﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="charge_cx.aspx.cs" Inherits="VA.Modules.JDingCYT.consume.charge_cx" %>

<%@ Register src="../mainbiz/uc_foodmenu.ascx" tagname="uc_foodmenu" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>收银/结账撤销</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <link href="/app_themes/<% = webSiteConfig.ThemeName %>/css/pages/consume.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->          
    <script type="text/javascript">

        function cancel() {
            closeActivatedTopestWindow();
        }

        //撤单-填写撤单原因；
        function cxBill() {

            var windowWidth = 350;
            var windowHeight = 180;
            var isMaximized = false;
            var left = 160;
            var top = 150;
            var winDivID = "winCX";
            var windowTitle = "填写撤单原因";
            
            openDivWindow2(windowTitle, windowWidth, windowHeight, winDivID, isMaximized, left, top);
        }

        //撤单执行；
        function cxSave() {

            var requestType = "POST";
            var url = pageName + "?act=cxbill";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            //var data = $("form").eq(0).serialize(); //取不到值 ？？
            var data = { "hfReasonContent": $("#hfReasonContent").val(), "hfChargeID": $("#hfChargeID").val() };
            var successFN = function (data, textStatus) {
                var bizNo = "";
                if (data.substring(0, 2) == "ok") {
                    showActResult("撤单成功！", true, doAfterAdd, bizNo);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd, bizNo);
                }
                else {
                    showActResult("撤单失败：" + data, false, doAfterAdd, bizNo);
                }
            };

            currActType = "cxbill";
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }
        //取消撤单
        function cxCancel() {
            $('#winCX').window("close");
        }

        //显示操作结果；
        function showActResult(sMsg, actResult, callback, bizNo) {
            var icon = "info";
            if (!actResult) {
                icon = "error";
            }

            JTongAlert('操作结果', sMsg, icon, function () {
                if (callback != null && callback != undefined) {
                    callback(actResult, bizNo);
                }
            });
        }

        function doAfterAdd(actResult) {
            if (actResult) {
                window.location.href = pageName;
            }
        }        

        //验证单号；
        function checkBizNo(){
            var bizNo = $("#txtBizNo").val();
            $.ajax({
                type: "GET",
                url: pageName + "?act=checkbizno&bizno=" + bizNo,
                dataType: "html",
                data: null,
                success: function (data, textStatus) {
                    if (data != "error") {
                        if (data == "") {
                            JTongAlert("提示", "该单号不存在或不符合撤销条件！", "error", function () {
                                $("#txtBizNo").select();
                            });
                        } else {
                            window.location.href = pageName + "?bizno=" + data;
                        }
                    }
                    else {
                        JTongAlert("提示", "验证收银单号失败！", "error", function () {
                            $("#txtBizNo").select();
                        });
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showActResult("请求失败！textStatus :" + textStatus, false);
                }
            });
        }        

        function ddlCXReason_onChange() {
            var reasonText = $("#ddlCXReason").val();
            $("#hfReasonContent").val(reasonText);
            if (reasonText == "其它原因") {
                $("#txtCustomReason").val("");
                $("#txtCustomReason").show();
                $("#txtCustomReason").focus();
            } else {
                $("#txtCustomReason").hide();
            }
        }

        $(function () {
            var bizNo = $("#hfKey").val();
            if (bizNo != "") {
                $("#txtBizNo").val(bizNo);
            } else {
                $("#txtBizNo").select();
            }
            $("#txtBizNo").keydown(function (event) {
                var keyCode = event.keyCode;
                if (keyCode == 13) {
                    checkBizNo();
                    return false;
                }
            });

            $("#txtCustomReason").hide();
            $("#txtCustomReason").blur(function () {
                $("#hfReasonContent").val($("#txtCustomReason").val());
            });
            $("#ddlCXReason").change(function () {
                ddlCXReason_onChange();
            });
            ddlCXReason_onChange();
        });
    </script>
</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:700px;float:left;">

<div class="centerFormTitle">
   <h1><asp:Label ID="lblFormTitle" runat="server">收银/结账撤销</asp:Label></h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">收银单号：</td>
<td>
    <asp:TextBox runat="server" ID="txtBizNo" 
            CssClass="input" 
            Width="150px"
            MaxLength="20"
            Font-Size="16px"
            Font-Bold="true" />   <span class="note" >注：输入后回车</span>
</td>
</tr>
<tr>
<td class="th">顾客类型：</td>
<td>
    <% = VA.Modules.JDingCYT.Core.Enums.CustomerTypeConverter.Convert_Value_ToText(base.chargeInfo.Customer_Type) %>
    <% if (base.chargeInfo.Customer_Type == VA.Modules.JDingCYT.Core.Enums.CustomerType.Member.ToString("d")) { %>
    卡号：<% = base.chargeInfo.CardNo %>，姓名：<% = base.chargeInfo.Name %>
    <% } %>
</td>
</tr>
<tr>
<td class="th">收银类型：</td>
<td>
    <% = VA.Modules.JDingCYT.Core.Enums.ConsumeChargeConverter.OrderTypeConverter.Convert_Value_ToText(base.chargeInfo.Order_Type) %>
    <% if (base.chargeInfo.Order_Type == VA.Modules.JDingCYT.Core.Enums.ConsumeCharge.OrderType.Dianneixiaofei.ToString("d")) { %>
    （订单号：<% = base.chargeInfo.Order_No %>，台号：<% = base.chargeInfo.Table_No %>，序号：<% = base.chargeInfo.Order_SequenceNo %>）
    <% } %>
</td>
</tr>
</table>

<%--<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">消费清单</td>
</tr>
</table>--%>
<div class="formEditListTableWrapper" style="min-height:285px;overflow:auto;overflow-x:hidden;">
    
    <asp:Repeater ID="rpChargeItems" Runat="server" EnableViewState="False"  >    
    <HeaderTemplate>
        <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:-1px;">
        <thead>
        <tr>
        <td style="width:30px;text-align:center;">No.</td>
   <%--     <td style="width:70px;text-align:center;display:none;">项目代码</td>--%>
        <td style="width:210px;text-align:center;">项目名称</td>
        <td style="width:40px;text-align:center;">单位</td>
        <td style="width:50px;text-align:center;">单价</td>    
        <%--<td style="width:60px;text-align:center;">折后单价</td>    --%>
        <td style="width:40px;text-align:center;">数量</td>
        <td style="width:70px;text-align:center;">折后金额</td>
        <td style="width:60px;text-align:center;">优惠</td>
        <td style="width:50px;text-align:center;">服务员</td>
        <td style="width:30px;text-align:center;">赠送</td>
        </tr>    
        </thead>    
        <tbody>                 
    </HeaderTemplate>
    <ItemTemplate>
        <tr>
            <td style="text-align:center;"><%# Container.ItemIndex + 1 %></td>
            <td style="text-align:left;"><%# Eval("Item_Name")%></td>
            <td style="text-align:center;"><%# Eval("Unit")%></td>
            <td style="text-align:center;"><%# Eval("Price")%></td>
            <%--<td style="text-align:center;"><%# (Convert.ToDecimal(Eval("Charges"))/Convert.ToDecimal(Eval("Quantity"))).ToString("F2")%></td>--%>
            <td style="text-align:center;"><%# Eval("Quantity")%></td>
            <td style="text-align:center;"><%# Eval("Charges")%></td>
            <td style="text-align:center;"><%# Eval("Discounts")%></td>
            <td style="text-align:center;"><%# Eval("Waiter_Name")%></td>
            <td style="text-align:center;"><%# Eval("Donate_Flag").ToString() == "1" ? "√" : ""%></td>
        </tr>
    </ItemTemplate>            
    <FooterTemplate>            
        </tbody>
        </table>
    </FooterTemplate>
    </asp:Repeater>  
    
    <table cellspacing="0" class="formEditListTable" id="srcTable_NoData" runat="server" style="margin-top:-1px;">
    <thead>
    <tr>
    <td style="width:30px;text-align:center;">No.</td>
<%--     <td style="width:70px;text-align:center;display:none;">项目代码</td>--%>
    <td style="width:210px;text-align:center;">项目名称</td>
    <td style="width:40px;text-align:center;">单位</td>
    <td style="width:50px;text-align:center;">单价</td>    
    <td style="width:60px;text-align:center;">折后单价</td>    
    <td style="width:40px;text-align:center;">数量</td>
    <td style="width:70px;text-align:center;">折后金额</td>
    <td style="width:60px;text-align:center;">优惠</td>
    <td style="width:50px;text-align:center;">服务员</td>
    <td style="width:30px;text-align:center;">赠送</td>
    </tr>    
    </thead>    
    </table>
                           

</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">消费总额：</td>
<td style="width:119px;">
    <% = base.chargeInfo.Costs.ToString("F2") %>
</td>
<td class="th">优惠金额：</td>
<td>
    <% = base.chargeInfo.Discounts.ToString("F2") %>         
</td>
<td class="th">实收金额：</td>
<td>
   <% = base.chargeInfo.PayAmount.ToString("F2") %>
</td>
</tr>
<tr>
<td class="th">支付方式：</td>
<td colspan="5">
    <% = base.chargeInfo.PayType_Desc %>
</td>
</tr>
<tr>
<td class="th">结账时间：</td>
<td>
    <% = VA.Utils.DateHelper.GetLongTimeString_PrecisionToMinute(base.chargeInfo.Operate_Date) %>
</td>
<td class="th">操 作 员：</td>
<td>
    <% = base.chargeInfo.Operator_Name %>
</td>
<td class="th">收银备注：</td>
<td>
    <% = base.chargeInfo.Remark %>
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">
    
    <% if (base.chargeInfo != null && !String.IsNullOrEmpty(base.chargeInfo.BizNo)) {%>

        <% if (base.chargeInfo.Bill_Type == VA.Modules.JDingCYT.Core.Enums.BillType.CXBill.ToString("d") ||
               base.chargeInfo.Bill_Status == VA.Modules.JDingCYT.Core.Enums.BillStatus.Canceled.ToString("d")) {%>
            <input type="button" id="Button3" class="btn" style="width:80px" value="撤销" disabled="disabled" />   
        <% } else { %>        
            <input type="button" id="btnNext" class="btn" style="width:80px" onclick="cxBill()" value="撤销" />   
        <% } %>
    <% } else { %>
        <input type="button" id="Button2" class="btn" style="width:80px" value="撤销" disabled="disabled" />   
    <% } %>
    <input type="button" id="Button1" class="btn" style="width:80px" onclick="cancel()" value="取消" /> 

    <asp:HiddenField ID="hfKey" runat="server" /> <!--保存BizNo-->
    <asp:HiddenField ID="hfChargeID" runat="server" /> <!--保存Charge_ID-->

</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<!--撤单详情窗口-->
<div id="winCX" style="display:none;">

    <div style="width:300px;padding:10px;margin:auto;">

    <div class="centerFormTitle">
        <h1>填写撤单原因</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;">      
    <tr>
    <td class="th">撤单原因：</td>
    <td>    
        <asp:DropDownList ID="ddlCXReason" runat="server" EnableViewState="false">
        <asp:ListItem Value="客户要求" Selected="True">客户要求</asp:ListItem>
        <asp:ListItem Value="操作失误">操作失误</asp:ListItem>
        <asp:ListItem Value="其它原因">其它原因</asp:ListItem>
        </asp:DropDownList>          
        <input type="text" class="input" style="width:90px;" id="txtCustomReason" name="txtCustomReason" maxlength="20" />
        <input type="hidden" class="input" style="width:90px;" id="hfReasonContent" name="hfReasonContent" maxlength="20" />
    </td>
    </tr> 
    <tr>
    <td colspan="2" class="footer">
        <input type="button" id="btnCXBill" class="btn" style="width:80px" onclick="cxSave()" value="撤单" />
        <input type="button" id="btnCxCancel" class="btn" style="width:80px" onclick="cxCancel()" value="取消" />
    </td>
    </tr>
    </table>

    </div>

</div> 

</form>
</body>
</html>

