﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="wallet_withdraw.aspx.cs" Inherits="VA.Modules.JDingCYT.charge.wallet_withdraw" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>会员提现</title>
    <!--#include virtual="/modules/cyt/include/css/edit.aspx"-->
    <!--#include virtual="/modules/cyt/include/js/edit.aspx"-->      
    <script type="text/javascript">
        function confirm() {

            //调用asp.net验证控件自带的js数据验证脚本对控件进行验证；
            var validationResult = Page_ClientValidate('');
            if (!validationResult) {
                return;
            }

            var withdrawDate = $("#spanwithdrawDate").html();
            var operatorName = $("#spanOperatorName").html();
            var withdrawAmount = $("#txtWithdrawAmount").val();
            var payTypeName = $("#ddlPayTypes").find("option:selected").text();

            if (parseFloat(withdrawAmount) < 0) {
                JTongAlert("提示", "提现金额不能为负数！", "error", function () {
                    $("#txtWithdrawAmount").select();
                });
                return;
            }

            $("#span_Confirm_withdrawDate").html(withdrawDate);
            $("#span_Confirm_OperatorName").html(operatorName);
            $("#span_Confirm_WithdrawAmount").html(parseFloat(withdrawAmount).toFixed(2).toString());
            $("#span_Confirm_PayTypeName").html(payTypeName);

            $('#winConfirm').css("display", "block");
            $('#winConfirm').window({
                width: 350,
                height: 368,
                left: 180,
                top:116,
                modal: true,
                maximizable: false,
                minimizable: false,
                collapsible: false,
                title: '确认'
            });
            $("#btnSubmit").focus();
        }

        function cancelSave() {
            $('#winConfirm').window("close");
        }

        function save() {

            $("#btnSubmit").attr("disabled", "disabled");

            var requestType = "POST";
            var url = pageName + "?act=add";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();
            var successFN = function (data, textStatus) {
                var bizNo = "";
                if (data.substring(0, 2) == "ok") {
                    bizNo = data.split("|")[1];
                    showActResult("提现成功！", true, doAfterAdd, bizNo);
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd, bizNo);
                }
                else {
                    showActResult("提现失败：" + data, false, doAfterAdd, bizNo);
                }
            };
            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        }

        function doAfterAdd(actResult, bizNo) {
            if (actResult) {
                
                if ($("#ckbNotify")[0].checked == true) {
                    ajaxExecute("get", "../notification/biztransaction_notify.aspx", { "biztype": "walletwithdraw", "bizno": bizNo });
                }                

                cancelSave();
                resetPage();
            }
        }

        //显示操作结果；
        function showActResult(sMsg, actResult, callback, bizNo) {

            $("#btnSubmit").removeAttr("disabled");

            var icon = "info";
            if (!actResult) {
                icon = "error";
            }

            JTongAlert('操作结果', sMsg, icon, function () {
                if (callback != null && callback != undefined) {
                    callback(actResult, bizNo);
                }
            });
        }

        function resetPage() {
            
            clearMemberInfo();

            $("#txtWithdrawAmount").val("");            

            //$("#ddlPayTypes")[0].options[0].selected = true;

            //默认选中现金；
            for (var i = 0; i < $("#ddlPayTypes")[0].options.length; i++) {
                var optionValue = $("#ddlPayTypes")[0].options[i].value;
                if (optionValue == "3") { //现金支付；
                    $("#ddlPayTypes")[0].options[i].selected = true;
                    break;
                }
            }

            $("#txtRemark").val("");

            $("#txtWithdrawAmount").attr("disabled", "disabled");            
            $("#ddlPayTypes").attr("disabled", "disabled");
            $("#txtRemark").attr("disabled", "disabled");
            $("#btnNext").attr("disabled", "disabled");  

            clearInputValidatorError();
        }

        //会员信息加载成功时调用的方法；            
        function doWhenMemberInfoLoadSuc(memberInfo) {
            $("#txtWithdrawAmount").removeAttr("disabled");
            $("#ddlPayTypes").removeAttr("disabled");
            $("#txtRemark").removeAttr("disabled");
            $("#btnNext").removeAttr("disabled");

            $("#txtWithdrawAmount").focus();
        }

        //会员信息加载失败时调用的方法；
        function doWhenMemberInfoLoadFail() {

        }
        
        $(function () {

            $("#txtWithdrawAmount").focus();
                
            $("#txtWithdrawAmount").attr("disabled", "disabled");            
            $("#ddlPayTypes").attr("disabled", "disabled");
            $("#txtRemark").attr("disabled", "disabled");
            $("#btnNext").attr("disabled", "disabled");

            //焦点控制；
            $("input,select").keydown(function (event) {
                if (event.keyCode == 13) {
                    var targetID = event.target.id;
                    switch (targetID) {
                        case "txtWithdrawAmount":
                            if ($("#txtWithdrawAmount").val() != "") {
                                $("#ddlPayTypes").focus();
                            }
                            break;
                        case "ddlPayTypes":
                            $("#txtRemark").focus();
                            break;
                        case "txtRemark":
                            confirm();
                            return false;
                            break;
                        default:
                            break;
                    }
                }
            });
        });

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div class="editPageWrapper" style="width:700px;">

<div class="centerFormTitle">
   <h1>会员提现</h1>
</div>

<!--#include file="../include/memberinfo.aspx"--> 

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" colspan="2" style="font-weight:bold;text-align:left;">提现信息</td>
</tr>
<tr>
<td class="th">提现日期：</td>
<td>    
	<span id="spanwithdrawDate"><% = DateTime.Now.ToString("yyyy-MM-dd") %></span>
</td>
</tr>
<tr>
<td class="th">操作员：</td>
<td>    
	<span id="spanOperatorName"><% = base.EmployeeName %></span>
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)提现金额：</td>
<td>
    <VACTL:TextBox runat="server" ID="txtWithdrawAmount" 
            CssClass="input" 
            Width="100px"
            CanBeNull="No"
            FieldName="提现金额"
            RequiredFieldType="Money"
            />
</td>
</tr>
<tr>
<td class="th">(<span class="note mustfill">*</span>)付款方式：</td>
<td>
    <asp:DropDownList ID="ddlPayTypes" Runat="server" >
    </asp:DropDownList>
</td>
</tr>
<tr>
<td class="th">备注：</td>
<td>    
	<VACTL:TextBox ID="txtRemark" Runat="server"
		 EnableViewState="False"
		 CssClass="input"
         Width="200px"
         MaxLength="100"  />	
</td>
</tr>

<tr>
<td colspan="2" class="footer">

    <input type="button" id="btnNext" class="btn" style="width:80px" onclick="confirm()" value="提现" />
    <input type="button" id="btnResetPage" class="btn" style="width:80px" onclick="resetPage()" value="重置" />
    <asp:HiddenField ID="hfKey" runat="server" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

<!--确认窗口-->    
<div id="winConfirm" style="display:none;">

    <div style="width:300px;margin:auto;">
    
    <br />

    <div class="centerFormTitle">
        <h1>确认提现信息</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;width:300px;">
    <tr>
    <td class="th">操 作 员：</td>
    <td>    
	    <span id="span_Confirm_OperatorName"></span>
    </td>
    </tr>
    <tr>
    <td class="th">提现日期：</td>
    <td>    
	    <span id="span_Confirm_withdrawDate"></span>
    </td>
    </tr>
    <tr>
    <td class="th">提现金额：</td>
    <td>    
	    <span id="span_Confirm_WithdrawAmount" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td class="th">付款方式：</td>
    <td>    
        <span id="span_Confirm_PayTypeName" style="font-weight:bold;"></span>
    </td>
    </tr>
    <tr>
    <td colspan="2" style="text-align:center;">    
        <asp:CheckBox ID="ckbNotify" runat="server"
             Text="短信通知" />         
    </td>
    </tr>
    <tr>
    <td colspan="2" class="footer">

        <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save(0)" value="确定" />
        <input type="button" id="btnCancel" class="btn" style="width:80px" onclick="cancelSave()" value="取消" />        

    </td>
    </tr>
    </table>
    </div>

</div><!--winConfirm.END-->

</form>
</body>
</html>

