﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="table_editlist.aspx.cs" Inherits="VA.Modules.JDingCYT.basic.table_editlist" %>

<%@ Import Namespace="System.Data"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>餐台管理</title>    
    <!--#include virtual="/modules/cyt/include/css/editlist.aspx"-->
    <link href="/admin/app_themes/<% = webSiteConfig.ThemeName %>/css/edit.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/modules/cyt/include/js/editlist.aspx"-->  
    <script type="text/javascript">

        //批量设置授权码 ；
        function setAuthorizationCode() {

            $('#winSetAuthorization').css("display", "block");
            $('#winSetAuthorization').window({
                width: 350,
                height: 200,
                modal: true,
                minimizable: false,
                collapsible: false,
                title: '设置授权码'
            });
        }

        //保存授权码；
        function saveAuthorizationCode() {
            var authorizationCode = $("#txtAuthorizationCode").val();
            batchllyActWrapper("SetAuthorizationCode", "", authorizationCode);
        }

        //当服务端执行成功时，在弹出操作成功提示后，会执行该方法。
        function doWhenServerActSuc(currActName, customArg) {
            if (currActName == "SetAuthorizationCode") {
                closeWindow();
                window.location.reload(); //重新刷新页面，以便重新计算汇总金额。
            }
        }

        //关闭窗口；
        function closeWindow() {
            $('#winSetAuthorization').window("close");
        }
                 
        //添加；
        function add() {
            openFrameWindow("添加餐台", 535, 250, "table_edit.aspx");            
        }

        //单条修改；
        function smodify(keyValue) {
            var ids = keyValue;
            openFrameWindow("修改餐台信息", 535, 250, "table_edit.aspx?tableno=" + ids);
            event.stopPropagation();  //阻止事件冒泡，避免行被选中；            
        }

        //单条删除；
        function sdel(keyValue) {
            singleActWrapper("Del", keyValue, "确定要删除该项吗？", "");
        }

        //单条删除；
        function sdel(keyValue) {
            singleActWrapper("Del", keyValue, "确定要删除该项吗？", "");
        }

        //启用；
        function enable() {
            batchllyActWrapper("Enable", "", "");
        }

        //停用；
        function disable() {
            batchllyActWrapper("Disable", "", "");
        }

        //显示汇总信息；
        function afterDataListLoaded() {
            _w_table_rowspan("#tableBody", 2);
        }

        $(function () {
            initListPage();
        });

    </script>


</head>
<body>
<!--说明：该页面是以 employee_editlist_nofresh_5.aspx 为原型封装的结果-->
<form id="Form1" method="post" runat="server">
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

<div id="pageWrapper" class="pageWrapper">  
    
    <div id="toolBar">    
        <a href="javascript:add()" class="jtongui-toolbarbutton" icon="icon-add">添加</a>                                      
        <a href="javascript:enable()" class="jtongui-toolbarbutton" icon="icon-enable">启用</a>        
        <a href="javascript:disable()" class="jtongui-toolbarbutton" icon="icon-disable">停用</a>        
        <a href="javascript:setAuthorizationCode()" class="jtongui-toolbarbutton" icon="icon-disable">设置授权码</a>
        <asp:LinkButton ID="lbnExportToExcel" runat="server" CssClass="jtongui-toolbarbutton" icon="icon-export" OnClick="lbnExportToExcel_Click">导出</asp:LinkButton>
        <a href="javascript:refresh()" class="jtongui-toolbarbutton" icon="icon-reload">刷新</a>            
    </div><!--toolBar.END-->   
                     
    <div id="searchBar">
    
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>

        <asp:DropDownList ID="ddlStatus" runat="server"
             AutoPostBack="true" 
            onselectedindexchanged="ddlStatus_SelectedIndexChanged">             
        </asp:DropDownList>

        <asp:DropDownList ID="ddlTableZone" runat="server"
             AutoPostBack="true" 
            onselectedindexchanged="ddlTableZone_SelectedIndexChanged">             
        </asp:DropDownList>

        <asp:DropDownList ID="ddlTableType" runat="server"
             AutoPostBack="true" 
            onselectedindexchanged="ddlTableType_SelectedIndexChanged">             
        </asp:DropDownList>
                               
        <asp:TextBox ID="txtKeyWords" runat="server"
            CssClass="input"
            Width="150px" />
   
        <asp:Button ID="btnSearch" runat="server" 
             CssClass="simpleBtn"
             Text="搜索" 
             Onclick="btnSearch_Click" />
        
    </ContentTemplate>
    </asp:UpdatePanel>

    </div><!--searchBar.END-->    

    <div id="dataBar">

    <!--MainList.Start-->    
    <div class="jtongui-smartlisttable" id="jtongui-smartlisttable">

    <table cellpadding="3" cellspacing="0" class="tableheader" id="tb1_header" >
    <thead>
    <tr>
        <td style="width:30px;text-align:center;"><input type="checkbox" id="ckb_selectAll"/></td>
        <td style="width:100px;text-align:center;">餐区</td>
        <td style="width:50px;text-align:center;">台号</td>
        <td style="width:50px;text-align:center;">座位数</td>
        <td style="width:50px;text-align:center;">类型</td>
        <td style="width:200px;text-align:center;">备注</td>        
        <td style="width:70px;text-align:center;">授权码</td>
        <td style="width:70px;text-align:center;">状态</td> 
        <td style="width:30px;text-align:center;">修改</td>	      
        <td style="width:30px;text-align:center;">删除</td>	    	  	       	    
        <td></td>
    </tr>    
    </thead>
    </table>

    <div id="dataBody">
    <asp:Repeater ID="myRepeater" Runat="server" EnableViewState="False"  >
    <HeaderTemplate>    
    <div class="bodyContainer">
    <% = base.ShowNoRecordInfo() %>
    <table cellpadding="3" cellspacing="0" class="tablebody" id="tableBody" tbHeader="tb1_header">
    </HeaderTemplate>
    <ItemTemplate>
    <tr>
        <td style="text-align:center;"><input type="checkbox" name="ckb_dataItem" value="<%# Eval("Table_No")%>" /></td>        
        <td align="center"><%# Eval("Zone_Name")%></td>
        <td align="center"><%# Eval("Table_No")%></td>
        <td align="center"><%# Eval("Seating_Quantity")%></td>
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.TableTypeConverter.Convert_Value_ToText(Eval("Table_Type").ToString())%></td>
        <td align="left"><%# Eval("Table_Name")%></td>
        <td align="left"><%# Eval("Authorization_Code")%></td>
        <td align="center"><%# VA.Modules.JDingCYT.Core.Enums.DictDataStatusConverter.Convert_Value_ToText(Eval("Table_Status").ToString(),true)%></td>                         	       	     
        <td align="center">
            <a href="#" onclick="javascript:smodify('<%# Eval("Table_No")%>');"><img src="/admin/icons/edit.png" alt="修改"/>  </a>
        </td>     
        <td align="center">
            <a href="#" onclick="javascript:sdel('<%# Eval("Table_No")%>');"><img src="/admin/icons/delete.png" alt="删除"/>  </a>
        </td>                	       	     
        <td></td>
    </tr>
    </ItemTemplate>
    <FooterTemplate>
    </table>
    </div><!--bodyContainer.END-->        

    <div id="divPagerInfo" style="display:none">
        <%=base.pageInfo%>
    </div>

    <input type="hidden" id="hidden_pageCnt" value="<% = base.PageCnt%>" />
    <input type="hidden" id="hidden_rdCnt" value="<% = base.RdCnt%>" />
    <input type="hidden" name="chkNum" value="<%=chkNum%>" />

    </FooterTemplate>
    </asp:Repeater>    
    </div><!--dataBody.END-->

    </div><!--jtongui-smartlisttable.END-->        
    <!--MainList.End-->  

    </div><!--dataBar.END-->

    <div id="pagerBar">
       ……
    </div><!--pageNavBar.END-->
    
    <asp:HiddenField runat="server" ID="hfCurrPage" EnableViewState="true" />
    
</div>

<!--设置授权码-->
<div id="winSetAuthorization" style="display:none;">

    <div style="width:300px;padding:10px;margin:auto;">

    <div class="centerFormTitle">
        <h1>设置自助点餐授权码</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;">    
    <tr>
    <td class="th">授权码：</td>
    <td>   
        <input type="text" id="txtAuthorizationCode" name="txtAuthorizationCode" />
    </td>
    </tr>       
    <tr>
    <td colspan="2" class="footer">
        <input type="button" id="btnSaveAuthorizationCode" class="btn" style="width:80px" onclick="saveAuthorizationCode()" value="确定" />
        <input type="button" id="btnClose" class="btn" style="width:80px" onclick="closeWindow()" value="关闭" />
    </td>
    </tr>
    </table>

    </div>

</div> 

</form>
</body>
</html> 