﻿<%@ Page Language="C#"%>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">

    public string msg="";
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (!String.IsNullOrEmpty(VA.FX.Core.Config.DBConfig.ConnectionString))
            {
                //此时，数据库可能尚未构建，所以可能会爆异常；
                string systemIsInstalled = VA.Modules.JDingCYT.Core.Config.SystemConfig.BizConfig.GetConfigItemValueFromDB(VA.Modules.JDingCYT.Core.Config.SystemConfig.BizConfig.ConfigKey.SYSTEM_ISINSTALLED);
                if (systemIsInstalled == "1")
                {
                    Response.Write("系统已安装，不能重复执行安装！<a href='/default.aspx'>[点此]</a>进行入系统");
                    Response.End();
                }    
            }                       
        }
        catch { }
        
        bool isOK = true;
        string binFolderPath = HttpRuntime.BinDirectory;
        try
        {
            List<string> assemblylist = VA.Install.SystemInfo.SystemAssemblyList;         

            ArrayList inexistenceAssemblyList = new ArrayList();
            foreach (string assembly in assemblylist)
            {
                if (!System.IO.File.Exists(binFolderPath + assembly))
                {
                    isOK = false;
                    inexistenceAssemblyList.Add(assembly);
                }
            }
            if (!isOK)
            {
                foreach (string assembly in inexistenceAssemblyList)
                {
                    msg += "<li>该程序包中缺少动态库文件: "+ assembly +"</li>";
                }
            }
        }
        catch(Exception ex)
        {
            isOK = false;
            msg += "<li>检测系统动态库文件存在性时发生异常："+ ex.Message +"</li>";
        }

        if (!System.IO.File.Exists(Server.MapPath("/jdingcyt.config")))
        {
            isOK = false;
            msg += "<li>该程序包中缺少文件：jdingcyt.config。</li>";
        }
        
        if(isOK)
        {
            Response.Redirect("install.aspx");
        }
    }
</script>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><% = VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftName %>安装向导</title>
<link rel="stylesheet" href="main.css" type="text/css" />
</head>

<body>
<div id="pageWrapper">
    <div class="header">
	    <h2><img alt="<% = VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftName %>" src="images/logo.png"/> <span class="text"><b>v<% = VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftVesion %> 安装向导</b></span></h2>
    </div>
	<div class="main">
		<h1>基本系统环境检测</h1>
        <div class="content">
			<ul id="resultlist" class="list">
                 <%=msg %>
			</ul>
            <span style="color:Red; font-weight:bold">请排查并解决上述问题，然后重新尝试安装! </span>

		</div>
	</div>
	<div class="footer">
		Copyright &copy; <a href="http://www.jdingsoft.com" target="_blank"><% = VA.Modules.JDingCYT.Core.SystemInfo.SupportInfo.Company %> <% =DateTime.Now.Year.ToString() %></a>. 
	</div>
</div>
</body>
</html>