﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="login.aspx.cs" Inherits="VA.FX.Web.admin.login" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><% = base.webSiteConfig.WebSiteName %></title>
<link rel="stylesheet" type="text/css" href="/admin/app_themes/<% = webSiteConfig.ThemeName %>/css/main.css" />
<link rel="stylesheet" type="text/css" href="/admin/app_themes/<% = webSiteConfig.ThemeName %>/css/pages/login.css" />
<link rel="shortcut icon" type="image/x-icon" href="/logo.ico" />
<script type="text/javascript" src="/scripts/jquery/jquery-1.9.1.min.js"></script>
<script type="text/javascript">

    function setTheme(themeName) {
        window.location.href = "login.aspx?theme=" + themeName;
    }

    function setLayout() {
        var windowHeight = $(window).outerHeight();
        var mainHeight = $("#main").outerHeight();
        var mainTop = (windowHeight - mainHeight) / 2;
        $("#main").css("top", mainTop);
        $("#wrapper").height(windowHeight);
    }

    function isIE() {
        if (document.all) {
            return true;
        } else {
            return false;
        }
    }

    $(function () {       

        $("#txtUserID").focus();

        $("#txtUserID").keydown(function (e) {
            if (e.keyCode == 13) {
                $("#txtPassword").focus();
            }
        });

        $("#txtPassword").keydown(function (e) {
            if (e.keyCode == 13) {
                $("#btnSubmit").click();
                return false;
            }
        });

        setLayout();

        //绑定窗体resize事件；
        $(window).resize(function () {
            setLayout();
        });

        if (isIE()) {
            alert("提示：请使用谷歌、搜狗等非IE内核浏览器登录金鼎餐饮通！");
        }
    });

</script>      
</head>
<body>   
<form id="form1" runat="server">
<div id="wrapper">

<!--#include virtual="include/logo.aspx"--> 

<div id="loginNav"><a href="login_nav.aspx">登录导航</a></div>

<div id="main">    
    
    <p style="border:solid 0px red;text-align:center;line-height:50px;">
         <span style="font-size:30px;font-family:微软雅黑;color:#ffffff;text-shadow:1px 1px 1px #000;"><asp:Label ID="lblCompanyName" runat="server"></asp:Label></span>
    </p> 

    <div id="loginbox" class="loginbox qiantai">

    <p style="left:538px;top:50px;border:solid 0px red;position:absolute;"><span style="font-size:16px;font-family:黑体;">综合平台登录</span></p>

    <p style="left:330px;top:96px;border:solid 0px red;position:absolute;">
         <asp:TextBox ID="txtUserID" runat="server" 
             CssClass="input"
             Width="290px" />
        <asp:RequiredFieldValidator id="rfvUserID" runat="server" 
	         ErrorMessage="登录名错误." 
	         ControlToValidate="txtUserID" 
	         Display="None" />
	    <asp:RegularExpressionValidator id="revUserID" runat="server"
		     EnableViewState="False" 
		     ErrorMessage="帐号错误."
		     Display="None"
		     ControlToValidate="txtUserID" 
		     ValidationExpression="[a-zA-Z0-9_]{1,16}" />
    </p>

    <p style="left:330px;top:159px;border:solid 0px red;position:absolute;">
        <asp:TextBox ID="txtPassword" runat="server" 
             CssClass="input"
             TextMode="Password"
             Width="290px" />
        <asp:RequiredFieldValidator id="rfvPassword" runat="server" 
	         ErrorMessage="密码错误." 
	         ControlToValidate="txtPassword" 	         
	         Display="None" />
    </p>

    <p style="left:292px;top:220px;border:solid 0px red;position:absolute;">
        <asp:Button ID="btnSubmit" runat="server"
             Text=" 登录 "     
             CssClass="btn"        
             Width="150px"
             OnClick="btnSubmit_Click"
             />
        <asp:Label ID="lblLoginInfo" runat="server" ForeColor="Red"></asp:Label>
        <asp:ValidationSummary id="ValidationSummary1"  runat="server" 
	         ShowMessageBox="True" 
	         ShowSummary="False" />   
    </p>

    <p style="left:292px;top:330px;border:solid 0px red;position:absolute;color:#808080;text-align:right;width:390px;">
         版本号：<% = VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftVesion %>（<% = VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLevelName %>）
         <% if (VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLicenseType == VA.Modules.JDingCYT.Core.Enums.SoftLicenseType.Trial)
            {
                Response.Write("<span style='color:red;'>(" + VA.Modules.JDingCYT.Core.SystemInfo.SoftInfo.SoftLicenseTypeName + ")</span>");
            }       
         %>
    </p>

    </div>

    <div id="copyright">
        <p>(C)<% = DateTime.Now.Year.ToString() %> <a href="<% = VA.Modules.JDingCYT.Core.SystemInfo.SupportInfo.WebSite %>" target="_blank"><span style="color:#ffffff"><% = VA.Modules.JDingCYT.Core.SystemInfo.SupportInfo.Company %></span></a>. All rights reserved</p>
        <p style="font-size:12px;color:#eeeeee;margin-top:10px;">推荐使用谷歌、搜狗等非IE内核浏览器以获得较好的使用体验</p>
    </div>

</div>
</div><!--wrapper.END-->
</form>   
</body>  
</html>