#!/bin/bash


uninstall_type=$1
showtip=$2


#color
close="\033[0m"
red="\033[1;31m"
green="\033[1;32m"
yellow="\033[1;33m"
#display width
all_width=100

#0 uninstall
#1 clean install
if [ -z $uninstall_type ];then
	uninstall_type=0
fi

#0 no show
#1 show wait for install
if [ -z $showtip ];then
	showtip=0
fi


function GetPid()
{
        test $# -ne 1 && return 1
        prog=$1
        pids=$(ps aux|grep $prog|grep -v grep|awk '{print $2}')
        test -z "$pids" && return 2 || return 0
}



function output_ok()
{
	if [ -z "$1" ];then
		return
	fi

	len=$(($all_width-${#1}))
	string=$green"%"$len"s"$close"\n"
	printf $string "[ok]"
}

function output_fail()
{
	if [ -z "$1" ];then
		return
	fi
	
	len=$(($all_width-${#1}+3))
	string=$red"%"$len"s"$close"\n"
	printf $string "[error]"
}

#####################################################################################
#		uninstall start
#####################################################################################
#check user
userid=`id -u`
if [ "$?" == "0" -a "$userid" != "0" ];then
	echo  -e  $red"Permission denied!You need 'root' privilege to uninstall this software!"$close
	exit 1
fi


runDir=`pwd`
scriptDir=`dirname $0`
cd $scriptDir
#echo "This script is used to remove ApacheSafeog!"
echo
if [ "$showtip" == "1" ];then
	read -p "Are you sure to remove ApacheSafedog?[Y/n]" remove
	if [ "$remove" != "Y" ] && [ "$remove" != "y" ];then
		exit 0
	fi
fi

uduninstall=""
#get LONG_BIT.
longbit=`getconf LONG_BIT`
lib_path="/etc/safedog/libs/apache"
if [ "$?" == "0" -a "$longbit" == "32" ];then
	uduninstall="sdauduninstall NF-7400LP"
else	
	uduninstall="sdauduninstall NF-7400LP64"
fi


###########################################################################
#
if [ ! -f /etc/apachesd.conf ];then
	echo  -e  $red"Apache defense module do not install,exit."$close
	if [ "$uninstall_type" == "0" ];then
		exit 1
	fi	
fi


installdir=`grep InstallDir /etc/apachesd.conf`
installdir=${installdir#*InstallDir=}

apconf=`grep ApacheConfPath /etc/apachesd.conf`
apconf=${apconf#*ApacheConfPath=}

apache_progname=`cat /etc/apachesd.conf | grep "HTTP_NAME"|awk -F = '{print $2}'`
apache_restartcmd=`cat /etc/apachesd.conf | grep "RESTART_COMMAND"|awk -F = '{print $2}'`


###########################################################################
#remove load information
install_log="remove load information in apache..."
echo -n -e $install_log

if [ -f $apconf ];then
	delstr="#Begin SafeDogSite-ApacheFilter edits - remove only on uninstall"	
	sed -i "/$delstr/d" $apconf
	sdconf=`grep SDConfPath /etc/apachesd.conf`
	sdconf=${sdconf#*SDConfPath=}
	sdconf=${sdconf//\//\\\/}
	sed -i "/Include \"$sdconf\"/d" $apconf
fi

output_ok "$install_log"


###########################################################################
#remove apache defense module
install_log="remove file of Apache Defense Module..."
echo -e -n $install_log

APACHE_BIN_PATH=/etc/safedog/apache/bin

$uduninstall >/dev/null 2>&1

if [ -f "$lib_path/libapache_safedog_2_2.so.0.0.0" ];then
	chattr -i $lib_path/libapache_safedog_2_2.so.0.0.0
	rm -f 	$lib_path/libapache_safedog_2_2.so.0.0.0
	rm -f 	$lib_path/libapache_safedog_2_2.so.0
	rm -f  $lib_path/libapache_safedog_2_2.so
fi


if [ -f "$lib_path/libapache_safedog_2_4.so.0.0.0" ];then
	chattr -i $lib_path/libapache_safedog_2_4.so.0.0.0
	rm -f 	$lib_path/libapache_safedog_2_4.so.0.0.0
	rm -f 	$lib_path/libapache_safedog_2_4.so.0
	rm -f  $lib_path/libapache_safedog_2_4.so
fi

#if [ ! -d "/etc/NginxSafedog" ];then
	killall sdalog>/dev/null 2>&1
	killall sdacm>/dev/null 2>&1

	rm -f /etc/rc2.d/S99sdaboot
	rm -f /etc/rc3.d/S99sdaboot
	rm -f /etc/rc4.d/S99sdaboot
	rm -f /etc/rc5.d/S99sdaboot
	rm -f /etc/init.d/sdaboot
	
	rm -f /usr/bin/sdaboot
	rm -f ${APACHE_BIN_PATH}/sdaboot
	rm -f /usr/bin/sdacm
	rm -f ${APACHE_BIN_PATH}/sdacm
	rm -f /usr/bin/sdalog
	rm -f ${APACHE_BIN_PATH}/sdalog
	rm -f /usr/bin/sdaudinstall
	rm -f ${APACHE_BIN_PATH}/sdaudinstall
	rm -f /usr/bin/sdauduninstall
	rm -f ${APACHE_BIN_PATH}/sdauduninstall
	
	chattr -i  $lib_path/libSPModule.so.0.0.0
	rm -f  $lib_path/libSPModule.so.0.0.0
	rm -f  $lib_path/libSPModule.so.0
	rm -f  $lib_path/libSPModule.so
	
	chattr -i  $lib_path/libWPCPlugin.so.0.0.0
	rm -f  $lib_path/libWPCPlugin.so.0.0.0
	rm -f  $lib_path/libWPCPlugin.so.0
	rm -f  $lib_path/libWPCPlugin.so
#fi

if [ -d ${lib_path} ];then
	rm -rf ${lib_path}
#	echo "remove apache libs install directory ok!"
fi


if [ -d $installdir ];then
	rm -rf $installdir
#	echo "remove apache safedog's install directory ok!"
fi

logdir=/var/log/apachesd
if [ -d $logdir ];then
	rm -rf $logdir
#	echo "remove log ok!"
fi

conf=/etc/apachesd.conf
if [ -f $conf ];then
	rm -f $conf
#	echo "remove configure file ok!"
fi

output_ok  "$install_log"
############################################################
#restart the apache server
############################################################
install_log=""
start_ret=0

GetPid "$apache_progname"

#echo  -e "\n $pids"
if [ ! -z "$pids"  ];then
	install_log="restart apache server..."
	echo -e -n  "$install_log" 

#	echo -e "\n restartcmd: $apache_restartcmd"
	$apache_restartcmd > /dev/null 2>&1
	start_ret=$?
fi

if [ $start_ret != 0 ];then
	output_fail "$install_log"
	echo -e $red"please restart apache server by youself."$close
else
	output_ok	"$install_log"
	echo -e $green"uninstall apache defense module succeed.."$close
fi






