﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.IO;
using SharpUtil.Util;

namespace ImageUtil
{
  public partial class form1 : Form
  {
    private string fontName;
    private float fontSize;

    public form1()
    {
      InitializeComponent();
    }

    private void Form1_Load(object sender, EventArgs e)
    {
      CombFont.DrawItem += new DrawItemEventHandler(CombFont_DrawItem);
      System.Drawing.Text.InstalledFontCollection ifc = new System.Drawing.Text.InstalledFontCollection();
      FontFamily[] ffs = ifc.Families;
      foreach (FontFamily ff in ffs)
        //在这里的样式里表示Regular可能使用的字体   
        if (ff.IsStyleAvailable(FontStyle.Regular))
          CombFont.Items.Add(ff.Name);
      CombFont.SelectedIndex = 0;
      fontName = CombFont.Text;
    }

    private void RunUtil_Click(object sender, EventArgs e)
    {
      if (!string.IsNullOrEmpty(txtImgWater.Text))
      {
        RunWaterImage(sender, e);
        return;
      }
      if (!string.IsNullOrEmpty(WmText.Text))
      {
        RunWaterText(sender, e);
        return;
      }
      MessageBox.Show("请选择生成水印的字体或图片");
    }

    private void RunWaterImage(object sender, EventArgs e)
    {
      if (ControlValadate())
      {
        ImgStart(SrcPath.Text);
        MessageBox.Show("图片水印加载完成");
      }
    }

    private void ImgStart(string currPath)
    {
      string[] files = Directory.GetFiles(currPath);
      string tdir = currPath.Replace(SrcPath.Text, TarPath.Text);
      if (!Directory.Exists(tdir))
      {
        FileUtil.FolderCreate(tdir);
      }
      for (int i = 0; i < files.Length; i++)
      {
        FileInfo info = new FileInfo(files[i]);
        string fName = info.FullName;
        string tfName = info.FullName.Replace(SrcPath.Text, TarPath.Text);
        GenImageWaterImg(fName, tfName);
      }
      string[] dirs = Directory.GetDirectories(currPath);
      for (int i = 0; i < dirs.Length; i++)
      {
        Start(dirs[i]);
      }
    }

    private void GenImageWaterImg(string srcImgPath, string tarImgPath)
    {
      WaterImageManage wim = new WaterImageManage();
      wim.DrawImage(srcImgPath, txtImgWater.Text, 0.92f, ImagePosition.BottomMiddle, tarImgPath);
    }

    private void RunWaterText(object sender, EventArgs e)
    {
      if (string.IsNullOrEmpty(fontName))
      {
        MessageBox.Show("请选择字体");
        return;
      }
      if (ControlValadate())
      {
        Start(SrcPath.Text);
        MessageBox.Show("文字水印加载完成");
      }
    }

    private bool ControlValadate()
    {
      if (SrcBrowse.Text.Equals("") && !Directory.Exists(SrcBrowse.Text))
      {
        MessageBox.Show("请选择图片源文件夹");
        return false;
      }
      else
      {
        if (!SrcPath.Text.EndsWith("\\"))
        {
          SrcPath.Text += "\\";
        }
      }
      if (TarBrowse.Text.Equals("") && !Directory.Exists(TarBrowse.Text))
      {
        MessageBox.Show("请选择合成图片输出文件夹");
        return false;
      }
      else
      {
        if (!TarPath.Text.EndsWith("\\"))
        {
          TarPath.Text += "\\";
        }
      }
      return true;
    }

    private void Start(string currPath)
    {
      string[] files = Directory.GetFiles(currPath);
      string tdir = currPath.Replace(SrcPath.Text, TarPath.Text);
      if (!Directory.Exists(tdir))
      {
        FileUtil.FolderCreate(tdir);
      }
      for (int i = 0; i < files.Length; i++)
      {
        FileInfo info = new FileInfo(files[i]);
        string fName = info.FullName;
        string tfName = info.FullName.Replace(SrcPath.Text, TarPath.Text);
        GenTextWaterImg(fName, tfName);
      }
      string[] dirs = Directory.GetDirectories(currPath);
      for (int i = 0; i < dirs.Length; i++)
      {
        Start(dirs[i]);
      }
    }

    private void GenTextWaterImg(string srcImgPath, string tarImgPath)
    { 
      WaterImageManage wim = new WaterImageManage();
      wim.DrawWords(srcImgPath, WmText.Text, fontName, 0.5f, ImagePosition.Center, tarImgPath);
    }

    private void CombFont_DrawItem(object sender, DrawItemEventArgs e)
    {
      e.DrawBackground();
      ComboBox cmb = (ComboBox)sender;
      string txt = e.Index > -1 ? cmb.Items[e.Index].ToString() : cmb.Text;
      Font f = new Font(txt, cmb.Font.Size);
      //使用格式刷   
      Brush b = new SolidBrush(e.ForeColor);
      //字符串描绘   
      float ym =
          (e.Bounds.Height - e.Graphics.MeasureString(txt, f).Height) / 2;
      e.Graphics.DrawString(txt, f, b, e.Bounds.X, e.Bounds.Y + ym);

      f.Dispose();
      b.Dispose();

      //描绘四角表示焦点的形状   
      e.DrawFocusRectangle();
    }

    private void SrcBrowse_Click(object sender, EventArgs e)
    {
      if (Diafolder.ShowDialog() == DialogResult.OK)
      {
        SrcPath.Text = Diafolder.SelectedPath;
      }
    }

    private void TarBrowse_Click(object sender, EventArgs e)
    {
      if (Diafolder.ShowDialog() == DialogResult.OK)
      {
        TarPath.Text = Diafolder.SelectedPath;
      }
    }

    private void CombFont_SelectedIndexChanged(object sender, EventArgs e)
    {
      fontName = CombFont.Text;
    }

    private void AuthorLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
    {
      string url = "http://www.yiklan.com";
      System.Diagnostics.Process.Start(url); 
    }

    private void imgWater_Click(object sender, EventArgs e)
    {
      if (diaFile.ShowDialog() == DialogResult.OK)
      {
        txtImgWater.Text = diaFile.FileName;
      }
    }
  }
}
