-- Released under GPL v3
--------------------------------------------------------------
include("IGE_API_All");
include("InfoTooltipInclude");
print("IGE_CitiesPanel");
IGE = nil;

local normalBuildings = {};
local normalBuildingManager = nil;
local normalGroupInstance = nil;
local buildingItemManagers = {};

local wonderBuildings = {};
local wonderBuildingManager = nil;
local wonderGroupInstance = nil;
local wonderItemManagers = {};

local harmonyBuildings = {};
local harmonyBuildingManager = nil;
local harmonyGroupInstance = nil;
local harmonyItemManagers = {};

local supremacyBuildings = {};
local supremacyBuildingManager = nil;
local supremacyGroupInstance = nil;
local supremacyItemManagers = {};

local purityBuildings = {};
local purityBuildingManager = nil;
local purityGroupInstance = nil;
local purityItemManagers = {};

local groupInstances = {};
local eraItemManager = CreateInstanceManager("BuildingGroupInstance", "Stack", Controls.BuildingEraList );
local unitsManager = CreateInstanceManager("ListItemInstance", "Button", Controls.UnitsOnPlotList );




local data = {};
local isVisible = false;
local isTeleporting = false;
local currentPlot = nil;
local currentCity = nil;
local currentUnit = nil;
local currentUnitIndex = 0;
local currentReligion = 0;
local teleportationStartPlot = nil;
g_IGESelectedUpgrade = nil;
g_IGESelectedPerk = nil;

--===============================================================================================
-- CORE EVENTS
--===============================================================================================
local function OnSharingGlobalAndOptions(_IGE)
	IGE = _IGE;
end
LuaEvents.IGE_SharingGlobalAndOptions.Add(OnSharingGlobalAndOptions);

-------------------------------------------------------------------------------------------------
function OnInitialize()
	SetUnitsData(data, {});
	SetBuildingsData(data, {});	

	Resize(Controls.Container);
	Resize(Controls.ScrollPanel);
	Resize(Controls.OuterContainer);

	normalGroupInstance = eraItemManager:GetInstance();
	if normalGroupInstance then
		normalBuildingManager = CreateInstanceManager("ListItemInstance", "Button", normalGroupInstance.List );
		normalGroupInstance.Header:SetText(L("TXT_KEY_ENERGY_BUILDINGS_HEADING3_TITLE"));		
	end

	harmonyGroupInstance = eraItemManager:GetInstance();
	if harmonyGroupInstance then
		harmonyBuildingManager = CreateInstanceManager("ListItemInstance", "Button", harmonyGroupInstance.List );
		harmonyGroupInstance.Header:SetText(L("TXT_KEY_AFFINITY_HARMONY_HEADING2_TITLE"));
	end

	supremacyGroupInstance = eraItemManager:GetInstance();
	if supremacyGroupInstance then
		supremacyBuildingManager = CreateInstanceManager("ListItemInstance", "Button", supremacyGroupInstance.List );
		supremacyGroupInstance.Header:SetText(L("TXT_KEY_AFFINITY_SUPREMACY_HEADING2_TITLE"));
	end

	purityGroupInstance = eraItemManager:GetInstance();
	if purityGroupInstance then
		purityBuildingManager = CreateInstanceManager("ListItemInstance", "Button", purityGroupInstance.List );
		purityGroupInstance.Header:SetText(L("TXT_KEY_AFFINITY_PURITY_HEADING2_TITLE"));
	end
	
	wonderGroupInstance = eraItemManager:GetInstance();
	if wonderGroupInstance then
		wonderBuildingManager = CreateInstanceManager("ListItemInstance", "Button", wonderGroupInstance.List );
		wonderGroupInstance.Header:SetText(L("TXT_KEY_ENERGY_WONDERS_HEADING3_TITLE"));
	end

	--Extract wonders
	for _, era in ipairs(data.eras) do
		local k = 1;
		local wonders0 = era.wonders;
		while true do
			if not wonders0[k] then break end
			local wonder = wonders0[k];
			if wonder.isWonder then				
				table.remove(wonders0, k);
				table.insert(wonderBuildings, wonder);
				if wonder.isWonder then wonder.priority = 100 end
			else
				k = k + 1;
			end
		end
	end
	

	--Extract buildings and separate by affinity
	for _, era in ipairs(data.eras) do
		local i = 1;
		local buildings0 = era.buildings;
		while true do
			if not buildings0[i] then break end
			local building = buildings0[i];
			if building.affinity == nil and not isWonder then
				table.remove(buildings0, i);
				table.insert(normalBuildings, building);			
			elseif building.affinity == "AFFINITY_TYPE_HARMONY" then
				table.remove(buildings0, i);
				table.insert(harmonyBuildings, building);				
			elseif building.affinity == "AFFINITY_TYPE_SUPREMACY" then
				table.remove(buildings0, i);
				table.insert(supremacyBuildings, building);
			elseif building.affinity == "AFFINITY_TYPE_PURITY" then
				table.remove(buildings0, i);
				table.insert(purityBuildings, building);
			else
				i = i + 1;
			end
		end
	end
	
	local tt = L("TXT_KEY_IGE_CITIES_AND_UNITS_PANEL_HELP");
	LuaEvents.IGE_RegisterTab("CITIES_AND_UNITS",  L("TXT_KEY_IGE_CITIES_AND_UNITS_PANEL"), 1, "edit",  tt)
end
LuaEvents.IGE_Initialize.Add(OnInitialize);

-------------------------------------------------------------------------------------------------
function OnSelectedPanel(ID)
	isVisible = (ID == "CITIES_AND_UNITS");
	OnMoveUnitCancelButtonClick();
end
LuaEvents.IGE_SelectedPanel.Add(OnSelectedPanel);

-------------------------------------------------------------------------------------------------
function OnSelectedPlot(plot)
	currentUnitIndex = 0;
	currentPlot = plot;
end
LuaEvents.IGE_SelectedPlot.Add(OnSelectedPlot);


--===============================================================================================
-- UPDATE
--===============================================================================================
local function UpdateUnits()
	local count = currentPlot:GetNumUnits();
	Controls.UnitEdition:SetHide(count == 0);
	Controls.NoUnitOnPlot:SetHide(count ~= 0);
	if count == 0 then return end

	-- Update units list
	units = {};
	currentUnit = currentPlot:GetUnit(0);
	for i = 0, count - 1 do
		local pUnit = currentPlot:GetUnit(i);
		local unitID = pUnit:GetUnitType();
		local unit = data.unitsByID[unitID];
		local pOwner = Players[pUnit:GetOwner()];

		local item = {};

		-- Label
		if (pUnit:HasName()) then
			local desc = L("TXT_KEY_PLOTROLL_UNIT_DESCRIPTION_CIV", pOwner:GetCivilizationAdjectiveKey(), pUnit:GetNameKey());
			item.label = string.format("%s (%s)", pUnit:GetNameNoDesc(), desc); 
		else
			item.label = L("TXT_KEY_PLOTROLL_UNIT_DESCRIPTION_CIV", pOwner:GetCivilizationAdjectiveKey(), pUnit:GetNameKey());
		end

		local strength = pUnit:GetCombatStrength();
		if (strength > 0) then
			item.label = item.label..", [ICON_STRENGTH]" .. pUnit:GetCombatStrength();
		end
			
		local damage = pUnit:GetDamage();
		if (damage > 0) then
			item.label = item.label..", " .. L("TXT_KEY_PLOTROLL_UNIT_HP", GameDefines["MAX_HIT_POINTS"] - damage);
		end

		-- Other unit
		item.actor = pUnit;
		item.name = unit.name;
		item.subtitle = pOwner:GetCivilizationShortDescription();
		item.textureOffset = unit.textureOffset;
		item.texture = unit.texture;
		item.help = unit.help;
		item.selected = (i == currentUnitIndex);
		item.visible = true;
		item.enabled = true;
		item.index = i;

		-- Insertion
		table.insert(units, item);
		if item.selected then
			currentUnit = pUnit;
		end
	end

	UpdateList(units, unitsManager, UnitClickHandler);
end

function InvalidateCity()
	if currentCity then
		local cityID = currentCity:GetID();
		local playerID = currentCity:GetOwner();
		Events.SpecificCityInfoDirty(playerID, cityID, CityUpdateTypes.CITY_UPDATE_TYPE_BANNER);
		Events.SpecificCityInfoDirty(playerID, cityID, CityUpdateTypes.CITY_UPDATE_TYPE_PRODUCTION);
	end
	Events.SerialEventGameDataDirty();
	OnUpdate();
end

-------------------------------------------------------------------------------------------------
function UpdateBuildingList(buildings, manager, instance, prefix)
	for _, v in ipairs(buildings) do
		local count = currentCity:GetNumRealBuilding(v.ID);
		v.label = (count > 1) and prefix..v.name.." x"..count or v.name;
		v.enabled = currentCity:CanConstruct(v.ID, 1, 1, 1) or count ~= 0;
		v.selected = count ~= 0;
	end

	UpdateHierarchizedList(buildings, manager, BuildingClickHandler);
end

-------------------------------------------------------------------------------------------------
local function UpdateCityUI()
	currentCity = currentPlot:GetPlotCity();
	Controls.CityEdition:SetHide(currentCity == nil);
	Controls.NoCityOnPlot:SetHide(currentCity ~= nil);
	if not currentCity then return end

	UpdatePopulation(currentCity:GetPopulation());
	Controls.PuppetCityCB:SetCheck(false);
	Controls.MartialLawCB:SetCheck(false);
	Controls.NeverLostCityCB:SetCheck(false);
	Controls.ReconqueredCityCB:SetCheck(false);

	if currentCity:IsPuppet() then
		Controls.PuppetCityCB:SetCheck(true);
	elseif currentCity:IsMartialLaw() then
		Controls.MartialLawCB:SetCheck(true);
	elseif currentCity:IsNeverLost() then
		Controls.NeverLostCityCB:SetCheck(true);
	else
		Controls.ReconqueredCityCB:SetCheck(true);
	end

	Controls.CaptureCityButton:SetDisabled(IGE.currentPlayerID == currentCity:GetOwner());
	Controls.CityNameBox:SetText(currentCity:GetName());

	UpdateBuildingList(normalBuildings, normalBuildingManager, normalGroupInstance, "");
	normalGroupInstance.BottomStack:CalculateSize();
	local width = normalGroupInstance.BottomStack:GetSizeX();
	normalGroupInstance.HeaderBackground:SetSizeX(width + 10);

	UpdateBuildingList(harmonyBuildings, harmonyBuildingManager, harmonyGroupInstance, "");
	harmonyGroupInstance.BottomStack:CalculateSize();
	local width = harmonyGroupInstance.BottomStack:GetSizeX();
	harmonyGroupInstance.HeaderBackground:SetSizeX(width + 10);

	UpdateBuildingList(supremacyBuildings, supremacyBuildingManager, supremacyGroupInstance, "");
	supremacyGroupInstance.BottomStack:CalculateSize();
	local width = supremacyGroupInstance.BottomStack:GetSizeX();
	supremacyGroupInstance.HeaderBackground:SetSizeX(width + 10);

	UpdateBuildingList(purityBuildings, purityBuildingManager, purityGroupInstance, "");
	purityGroupInstance.BottomStack:CalculateSize();
	local width = purityGroupInstance.BottomStack:GetSizeX();
	purityGroupInstance.HeaderBackground:SetSizeX(width + 10);

	UpdateBuildingList(wonderBuildings, wonderBuildingManager, wonderGroupInstance, "");
	wonderGroupInstance.BottomStack:CalculateSize();
	local width = wonderGroupInstance.BottomStack:GetSizeX();
	wonderGroupInstance.HeaderBackground:SetSizeX(width + 10);

	-- Resize top border
	--Controls.BuildingEraList:CalculateSize();
	--local width = Controls.BuildingEraList:GetSizeX();
	Controls.BuildingContainer:SetSizeX(width);
end

-------------------------------------------------------------------------------------------------
function OnUpdate()
	Controls.OuterContainer:SetHide(not isVisible);
	if not isVisible then return end

	if isTeleporting then
		LuaEvents.IGE_SetMouseMode(IGE_MODE_PLOP);
		Controls.MoveUnitPromptStack:SetHide(false);
		Controls.PlotSelectionPrompt:SetHide(true);
		Controls.Container:SetHide(true);
	else
		LuaEvents.IGE_SetMouseMode(IGE_MODE_EDIT_AND_PLOP);
		Controls.MoveUnitPromptStack:SetHide(true);
		Controls.PlotSelectionPrompt:SetHide(currentPlot ~= nil);
		Controls.Container:SetHide(currentPlot == nil);
	end
	if (currentPlot ~= nil) and (not isTeleporting) then 
		UpdateUnits();
		UpdateCityUI();
	end

	Controls.CityEdition:CalculateSize();
	Controls.Stack:CalculateSize();
    Controls.ScrollPanel:CalculateInternalSize();
	Controls.ScrollBar:SetSizeX(Controls.ScrollPanel:GetSizeX() - 36);
end
LuaEvents.IGE_Update.Add(OnUpdate);

-------------------------------------------------------------------------------------------------
function UnitClickHandler(unit)
	for _, v in ipairs(units) do
		v.selected = (v == unit);
		if v.selected then currentUnitIndex = unit.index end
	end
	OnUpdate();
end

-------------------------------------------------------------------------------------------------
function BuildingClickHandler(building)
	local count = currentCity:GetNumRealBuilding(building.ID);
	if building.noLimit then
		currentCity:SetNumRealBuilding(building.ID, count + 1);
	else
		currentCity:SetNumRealBuilding(building.ID, count == 1 and 0 or 1);
	end
	InvalidateCity();

	-- Wonder splash screen
	if building.isWonder then
		if Game == nil or Game.GetGameTurn() <= Game.GetStartTurn() then
			LuaEvents.IGE_WonderPopup(building.ID);
		end
	end
end

-------------------------------------------------------------------------------------------------
function BuildingRightClickHandler(building)
	local count = currentCity:GetNumRealBuilding(building.ID);
	if count ~= 0 then
		currentCity:SetNumRealBuilding(building.ID, count - 1);
	end

	InvalidateCity();
end

-------------------------------------------------------------------------------------------------
function OnDisbandUnitClick()
	currentUnit:Kill();	
	Events.SerialEventGameDataDirty();
	OnUpdate();
end
Controls.DisbandUnitButton:RegisterCallback(Mouse.eLClick, OnDisbandUnitClick);

-------------------------------------------------------------------------------------------------
function OnPromoteUnitClick()
	local level = GetLevelFromXP(currentUnit:GetExperience());
	local xp = GetXPForLevel(level + 1);
	currentUnit:SetExperience(xp);
	currentUnit:SetPromotionReady(true);
	Events.SerialEventGameDataDirty();
	OnUpdate();
end
Controls.PromoteUnitButton:RegisterCallback(Mouse.eLClick, OnPromoteUnitClick);

-------------------------------------------------------------------------------------------------
function OnHealUnitClick()
	currentUnit:SetDamage(0);
	OnUpdate();
end
Controls.HealUnitButton:RegisterCallback(Mouse.eLClick, OnHealUnitClick);

-------------------------------------------------------------------------------------------------
function OnCityNameChange(name)
	currentCity:SetName(name);
	OnUpdate();
end
Controls.CityNameBox:RegisterCallback(OnCityNameChange);

-------------------------------------------------------------------------------------------------
function OnDisbandCityClick()
	local playerID = currentCity:GetOwner();
	local pPlayer = Players[playerID];
	--pPlayer:Disband(currentCity);	
	local plot = currentCity:Plot()
	local hexpos = ToHexFromGrid(Vector2(plot:GetX(), plot:GetY()));
	local cityID = currentCity:GetID()
	currentCity:Kill();
	Events.SerialEventCityDestroyed(hexpos, playerID, cityID, -1)
	Events.SerialEventGameDataDirty();
	OnUpdate();
end
Controls.DisbandCityButton:RegisterCallback(Mouse.eLClick, OnDisbandCityClick);

-------------------------------------------------------------------------------------------------
function OnCaptureCityClick()
	if IGE.currentPlayerID ~= currentCity:GetOwner() then
		local pPlayer = Players[IGE.currentPlayerID];
		pPlayer:AcquireCity(currentCity);	
	end
	InvalidateCity();
end
Controls.CaptureCityButton:RegisterCallback(Mouse.eLClick, OnCaptureCityClick);

-------------------------------------------------------------------------------------------------
function OnHealCityClick()
	currentCity:SetDamage(0);
	InvalidateCity();
end
Controls.HealCityButton:RegisterCallback(Mouse.eLClick, OnHealCityClick);

-------------------------------------------------------------------------------------------------
function OnHurryProductionCityClick()
	local prod = currentCity:GetProductionNeeded();
	currentCity:SetProduction(prod);
	InvalidateCity();
end
Controls.HurryCityButton:RegisterCallback(Mouse.eLClick, OnHurryProductionCityClick);

-------------------------------------------------------------------------------------------------
function OnExpandBordersCityClick()
	local playerTeamID = IGE.currentPlayer:GetTeam()
	local currentCulture = currentCity:GetCultureStored();
	local cultureNeeded = currentCity:GetCultureThreshold();
	local nextCulture = 0;

	-- Store revealed plots
	local revealed = {}
	for i = 0, Map.GetNumPlots()-1, 1 do
		local plot = Map.GetPlotByIndex(i)
		revealed[i] = plot:IsRevealed(playerTeamID, false)
	end	

	-- Looks like this command doesn't work in BE
	--currentCity:DoJONSCultureLevelIncrease();

	local cultureDiff = cultureNeeded - currentCulture;
	nextCulture = currentCulture + cultureDiff;
	currentCity:SetCultureStored(nextCulture);	
	--print("CurrentCulture: ",currentCulture,"Culture Needed: ",cultureNeeded," NextCulture: ", nextCulture);

	-- Update fog on plots that have just been revealed
	for i = 0, Map.GetNumPlots()-1, 1 do
		local plot = Map.GetPlotByIndex(i);
		if plot:IsRevealed(playerTeamID, false) ~= revealed[i] then
			plot:UpdateFog();
			local hexpos = ToHexFromGrid(Vector2(plot:GetX(), plot:GetY()));
			Events.HexFOWStateChanged(hexpos, true, false);
		end
	end

	-- Invalidate UI for the city
	InvalidateCity();
end
Controls.ExpandCityButton:RegisterCallback(Mouse.eLClick, OnExpandBordersCityClick);

-------------------------------------------------------------------------------------------------
function OnPuppetCityCBChanged()
	currentCity:SetNeverLost(false);
	currentCity:IsMartialLaw(true);
	currentCity:SetPuppet(true);
	currentCity:SetProductionAutomated(true);
	InvalidateCity();
end
Controls.PuppetCityCB:RegisterCallback(Mouse.eLClick, OnPuppetCityCBChanged);

-------------------------------------------------------------------------------------------------
function OnMartialLawCBChanged()
	currentCity:SetNeverLost(false);
	currentCity:SetPuppet(false);
	currentCity:IsMartialLaw(true);
	InvalidateCity();
end
Controls.MartialLawCB:RegisterCallback(Mouse.eLClick, OnMartialLawCBChanged);

-------------------------------------------------------------------------------------------------
function OnNeverLostCityCBChanged()
	currentCity:SetPuppet(false);
	currentCity:IsMartialLaw(false);
	currentCity:SetNeverLost(true);
	InvalidateCity();
end
Controls.NeverLostCityCB:RegisterCallback(Mouse.eLClick, OnNeverLostCityCBChanged);

-------------------------------------------------------------------------------------------------
function OnReconqueredCityCBChanged()
	currentCity:SetPuppet(false);
	currentCity:IsMartialLaw(false);
	currentCity:SetNeverLost(false);
	InvalidateCity();
end
Controls.ReconqueredCityCB:RegisterCallback(Mouse.eLClick, OnReconqueredCityCBChanged);

-------------------------------------------------------------------------------------------------
function OnMoveUnitButtonClick()
	teleportationStartPlot = currentPlot;
	isTeleporting = true;
	OnUpdate();
end
Controls.MoveUnitButton:RegisterCallback(Mouse.eLClick, OnMoveUnitButtonClick);

-------------------------------------------------------------------------------------------------
function OnMoveUnitCancelButtonClick()
	teleportationStartPlot = nil;
	isTeleporting = false;
	OnUpdate();
end
Controls.MoveUnitCancelButton:RegisterCallback(Mouse.eLClick, OnMoveUnitCancelButtonClick);

-------------------------------------------------------------------------------------------------
function OnPlop(button, plot)
	if not isVisible then return end

	if isTeleporting then
		if plot:GetX() ~= currentUnit:GetX() or plot:GetY() ~= currentUnit:GetY() then
			currentUnit:SetXY(plot:GetX(), plot:GetY());
		end
		isTeleporting = false;
		OnUpdate();
	else
		if plot:GetPlotCity() == nil then
			IGE.currentPlayer:InitCity(plot:GetX(), plot:GetY());
			Events.SerialEventGameDataDirty();
		end
	end
end
LuaEvents.IGE_Plop.Add(OnPlop);

-------------------------------------------------------------------------------------------------
function InputHandler(uiMsg, wParam, lParam)
	if isVisible and isTeleporting then
		if uiMsg == KeyEvents.KeyDown and wParam == Keys.VK_ESCAPE then
			OnMoveUnitCancelButtonClick();
			return true;
		end
	end

	return false;
end
ContextPtr:SetInputHandler(InputHandler);

------------------------------------------------------------------------------------------------
UpdatePopulation = HookNumericBox("Population", 
	function() return currentCity:GetPopulation() end, 
	function(amount) 
		if amount ~= currentCity:GetPopulation() then
			currentCity:SetPopulation(amount, true)
			LuaEvents.IGE_Update();
		end
	end, 
	0, nil, 1);
