/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;

/**
 * @author Thomas Singer
 */
public interface ILocalFileReader {

	void transmitTextFile(FsFilePath fsFile, ICvsCommandStopper commandStopper, IConnectionStreams connectionStreams) throws IOException;

	void transmitBinaryFile(FsFilePath fsFile, ICvsCommandStopper commandStopper, IConnectionStreams connectionStreams) throws IOException;

	void listFilesAndDirectories(FsDirectoryPath fsDirectory, Collection<String> fileNames, Collection<String> directoryNames);

	boolean exists(FsPath fsEntry);

	FilePermissions getFilePermissions(FsFilePath fsFile);

	boolean isModified(FsFilePath fsFile, Date entryLastModified);

	long getFileTime(FsFilePath fsFile);
}