package org.netbeans.lib.cvsclient.file;

/**
 * @author Thomas Singer
 */
public class FsPathUtils {

	// Static =================================================================

	public static boolean isRoot(FsDirectoryPath fsDirectoryPath) {
		return fsDirectoryPath.getPath().equals("/");
	}

	public static FsDirectoryPath getCommonDirectory(FsPath fsPath1, FsPath fsPath2) {
		final String parentPath1 = getDirectory(fsPath1).getPath();
		final String parentPath2 = getDirectory(fsPath2).getPath();

		final int parentPathLength1 = parentPath1.length();
		final int parentPathLength2 = parentPath2.length();
		final int length = Math.min(parentPathLength1, parentPathLength2);
		int lastSlashIndex = 1;
		for (int i = 1; i < length; i++) {
			final char chr1 = parentPath1.charAt(i);
			final char chr2 = parentPath2.charAt(i);
			if (chr1 != chr2) {
				return FsDirectoryPath.createAbsoluteInstance(parentPath1.substring(0, lastSlashIndex));
			}

			if (chr1 == '/') {
				lastSlashIndex = i;
			}
		}

		if (parentPathLength1 == parentPathLength2) {
			return FsDirectoryPath.createAbsoluteInstance(parentPath1);
		}

		if (parentPathLength1 > parentPathLength2) {
			if (parentPath1.charAt(parentPathLength2) == '/') {
				return FsDirectoryPath.createAbsoluteInstance(parentPath2);
			}
			return FsDirectoryPath.createAbsoluteInstance(parentPath1.substring(0, lastSlashIndex));
		}

		if (parentPath2.charAt(parentPathLength1) == '/') {
			return FsDirectoryPath.createAbsoluteInstance(parentPath1);
		}

		return FsDirectoryPath.createAbsoluteInstance(parentPath1.substring(0, lastSlashIndex));
	}

	public static boolean isParentOf(FsDirectoryPath fsDirectoryPath, FsPath fsPath) {
		final String directoryPath = fsDirectoryPath.getPath();
		final String path = fsPath.getPath();
		if (path.length() <= directoryPath.length()) {
			return false;
		}
		return path.startsWith(directoryPath);
	}

	public static FsFilePath unixFilePathToFsFile(String unixFilePath) {
		if (unixFilePath.startsWith("./")) {
			unixFilePath = unixFilePath.substring(1);
		}
		else if (!unixFilePath.startsWith("/")) {
			unixFilePath = '/' + unixFilePath;
		}
		return FsFilePath.createInstance(unixFilePath);
	}

	public static FsDirectoryPath unixDirectoryPathToFsFile(String unixDirectoryPath) {
		unixDirectoryPath = removeMultipleSlashs(unixDirectoryPath);
		unixDirectoryPath = FileUtils.ensureTrailingSlash(unixDirectoryPath);
		if (unixDirectoryPath.startsWith("./")) {
			unixDirectoryPath = unixDirectoryPath.substring(1);
		}
		else if (!unixDirectoryPath.startsWith("/")) {
			unixDirectoryPath = '/' + unixDirectoryPath;
		}
		return FsDirectoryPath.createAbsoluteInstance(unixDirectoryPath);
	}

	public static String removeMultipleSlashs(String path) {
		final int doubleSlashIndex = path.indexOf("//");
		if (doubleSlashIndex < 0) {
			return path;
		}

		final StringBuilder builder = new StringBuilder(path);
		boolean previousWasSlash = false;
		int i = 0;
		while (i < builder.length()) {
			final char chr = builder.charAt(i);
			if (chr == '/') {
				if (previousWasSlash) {
					builder.delete(i, i + 1);
					continue;
				}

				previousWasSlash = true;
			}
			else {
				previousWasSlash = false;
			}
			i++;
		}
		return builder.toString();
	}

	// Utils ==================================================================

	private static FsDirectoryPath getDirectory(FsPath fsPath) {
		if (fsPath.isDirectory()) {
			return (FsDirectoryPath)fsPath;
		}
		return fsPath.getParent();
	}
}
