/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

import org.netbeans.lib.cvsclient.util.*;

/**
 * Thiz represents a relative file name relative to an root entry (normally directory).
 *
 * @author Thomas Singer
 */
public abstract class FsPath {

	// Abstract ===============================================================

	public abstract boolean isDirectory();

	// Fields =================================================================

	private final String path;

	// Setup ==================================================================

	protected FsPath(String path) {
		BugLog.assertNotNull(path);
		BugLog.assertTrue(path.startsWith("/"), "'" + path + "' must start with a /");
		BugLog.assertTrue(path.length() == 1 || !path.endsWith("/"), "'" + path + "' must not end with a /");
		BugLog.assertTrue(path.indexOf("//") < 0, "Path '" + path + "' must not contain double slashs.");

		this.path = path;
	}

	// Implemented ============================================================

	@Override
	public final String toString() {
		return path;
	}

	@Override
	public final int hashCode() {
		return path.hashCode();
	}

	@Override
	public final boolean equals(Object obj) {
		if (obj == null || obj.getClass() != getClass()) {
			return false;
		}

		final FsPath fsEntry = (FsPath)obj;
		return path.equals(fsEntry.path);
	}

	// Accessing ==============================================================

	public final String getName() {
		final int lastSlashIndex = path.lastIndexOf('/');
		if (lastSlashIndex < 0) {
			return path;
		}
		return path.substring(lastSlashIndex + 1);
	}

	public final String getPath() {
		return path;
	}

	public final FsDirectoryPath getParent() {
		if (path.equals("/")) {
			return null;
		}

		final int lastSlashIndex = path.lastIndexOf('/');
		if (lastSlashIndex == 0) {
			return FsDirectoryPath.ROOT;
		}

		return FsDirectoryPath.createAbsoluteInstance(path.substring(0, lastSlashIndex));
	}

	public final String getParentPath() {
		if (path.equals("/")) {
			return null;
		}

		final int lastSlashIndex = path.lastIndexOf('/');
		if (lastSlashIndex == 0) {
			return "/";
		}

		return path.substring(0, lastSlashIndex);
	}
}
