/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

import org.netbeans.lib.cvsclient.util.*;

/**
 * Thiz represents a relative file name relative to an root entry (normally directory).
 *
 * @author Thomas Singer
 */
public final class FsFilePath extends FsPath {

	// Static =================================================================

	public static FsFilePath createInstance(String absoluteFileName) {
		return new FsFilePath(absoluteFileName);
	}

	public static FsFilePath createInstance(FsDirectoryPath fsDirectory, String filePathRelativeToFsDirectory) {
		return createInstance(FileUtils.ensureTrailingSlash(fsDirectory.getPath())
				+ FileUtils.removeLeadingSlash(filePathRelativeToFsDirectory));
	}

	// Setup ==================================================================

	private FsFilePath(String path) {
		super(path);
		BugLog.assertTrue(!path.endsWith("/"), "'" + path + "' must not end with a /");
	}

	// Implemented ============================================================

	@Override
	public boolean isDirectory() {
		return false;
	}
}
