package org.netbeans.lib.cvsclient.event;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public class DualListener
		implements ICvsListener {

	// Static =================================================================

	public static ICvsListener getInstance(ICvsListener parser1, ICvsListener parser2) {
		if (parser1 == null) {
			return parser2;
		}
		if (parser2 == null) {
			return parser1;
		}
		return new DualListener(parser1, parser2);
	}

	// Fields =================================================================

	private final ICvsListener parser1;
	private final ICvsListener parser2;

	// Setup ==================================================================

	private DualListener(ICvsListener parser1, ICvsListener parser2) {
		BugLog.assertNotNull(parser1);
		BugLog.assertNotNull(parser2);

		this.parser1 = parser1;
		this.parser2 = parser2;
	}

	// Implemented ============================================================

	public void registerListeners(ICvsListenerRegistry listenerRegistry) {
		parser1.registerListeners(listenerRegistry);
		parser2.registerListeners(listenerRegistry);
	}

	public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
		parser2.unregisterListeners(listenerRegistry);
		parser1.unregisterListeners(listenerRegistry);
	}
}
