/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Thomas Singer. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command.watch;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.request.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
final class WatchRequestFactory extends AbstractRequestFactory implements ICommandRequestFactory {

	// Fields =================================================================

	private final ICvsFiles cvsFiles;
	private final WatchMode watchMode;
	private final Watch watch;
	private final Collection<? extends FsPath> fsPaths;

	// Setup ==================================================================

	public WatchRequestFactory(ICvsFiles cvsFiles, Collection<? extends FsPath> fsPaths, WatchMode watchMode, Watch watch) {
		this.cvsFiles = cvsFiles;
		this.fsPaths = fsPaths;
		this.watchMode = watchMode;
		this.watch = watch;
	}

	// Implemented ============================================================

	public ResponseExpectingRequest getResponseExpectingRequest() {
		return watchMode.getCommand();
	}

	public void sendCommandRequests(IRequestSender requestSender, IClientEnvironment clientEnvironment) throws CommandAbortedException, IOException {
		if (watchMode.isWatchOptionAllowed()) {
			final String[] arguments = watch.getArguments();
			for (String argument : arguments) {
				Requests.addArgumentRequest("-a", argument, requestSender);
			}
		}
		Requests.addArgumentRequest("--", requestSender);
		addFileRequests(cvsFiles, IgnoreFileFilter.IGNORE_ALL, clientEnvironment, requestSender);
		Requests.addLocalPathDirectoryRequest(clientEnvironment.getAdminReader(), clientEnvironment.getCvsFileSystem(), requestSender);
		Requests.addArgumentRequests(fsPaths, requestSender);
	}
}
