/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Thomas Singer. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command.reservedcheckout;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.progress.*;
import org.netbeans.lib.cvsclient.progress.sending.*;

/**
 * @author Thomas Singer
 */
public final class EditorsCommand extends AbstractCommand {

	// Static =================================================================

	public static AbstractCommand createInstance(FsDirectoryPath fsDirectory) {
		return new EditorsCommand(Collections.singleton(fsDirectory));
	}

	public static AbstractCommand createInstance(Collection<FsFilePath> fsFiles) {
		return new EditorsCommand(fsFiles);
	}

	// Fields =================================================================

	private final Collection<? extends FsPath> fsPaths;
	private boolean recursive = true;

	// Setup ==================================================================

	private EditorsCommand(Collection<? extends FsPath> fsPaths) {
		this.fsPaths = fsPaths;
	}

	// Implemented ============================================================

	@Override
	public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException {
		final ICvsFiles cvsFiles;
		try {
			cvsFiles = FileSystemScanner.scan(fsPaths, recursive, clientEnvironment);
		}
		catch (IOException ex) {
			throw new IOCommandException(ex);
		}

		final IRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.5), cvsFiles);

		final ICvsListener builder = new EditorsMessageParser(eventSender, clientEnvironment.getLocalFileSystem(), cvsFiles);
		builder.registerListeners(listenerRegistry);
		try {
			return requestProcessor.communicateWithServer(new EditorsRequestFactory(cvsFiles, fsPaths),
			                                              requestsProgressHandler, clientEnvironment, getGlobalOptions());
		}
		finally {
			builder.unregisterListeners(listenerRegistry);
		}
	}

	@Override
	public String getCvsCommandLine() {
		final StringBuilder cvsCommandLine = new StringBuilder("editors ");
		if (!recursive) {
			cvsCommandLine.append("-l ");
		}
		CommandUtils.appendFileArguments(fsPaths, cvsCommandLine);
		return cvsCommandLine.toString();
	}

	// Accessing ==============================================================

}
