/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.admin;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.file.*;

/**
 * @author Thomas Singer
 */
public interface IAdminWriter {

	void setEntry(FsFilePath fsFile, Entry entry) throws IOException;

	void setEntries(Collection<Entry> entries, FsDirectoryPath fsDirectory) throws IOException;

	boolean modifyEntry(FsFilePath fsFile, IEntryHandler entryHandler) throws IOException;

	void removeEntryForFile(FsPath fsEntry) throws IOException;

	void pruneDirectory(FsDirectoryPath fsDirectory);

	void editFile(FsFilePath fsFile, Entry entry) throws IOException;

	void uneditFile(FsFilePath fsFile) throws IOException;

	void setStickyTagForDirectory(FsDirectoryPath fsDirectory, String tag) throws IOException;

	void setEntriesDotStatic(FsDirectoryPath fsDirectory, boolean set) throws IOException;

	void writeTemplateFile(FsDirectoryPath fsDirectory, int fileLength, InputStream inputStream, IReaderFactory readerFactory, ILocalFileWriter localFileWriter) throws IOException;

	void directoryAdded(FsDirectoryPath directory) throws IOException;

	void ensureCvsDirectory(FsDirectoryPath fsDirectory, String relativeRepositoryPath, CvsRoot cvsRoot) throws IOException;
}
