/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Thomas Singer.
 * Portions created by Robert Greig are Copyright (C) 2001.
 * All Rights Reserved.
 *
 * Contributor(s): Thomas Singer.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.admin;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.file.*;

/**
 * @author Thomas Singer
 */
public interface IAdminReader {

	Entry getEntry(FsPath fsEntry) throws IOException;

	Collection<Entry> getEntries(FsDirectoryPath fsDirectory) throws IOException;

	FsDirectoryPath getRelativeRepositoryPathForDirectory(FsDirectoryPath fsDirectory, String absoluteRepositoryRootPath) throws IOException;

	String getStickyTagForDirectory(FsDirectoryPath fsDirectory);

	boolean hasCvsDirectory(FsDirectoryPath fsDirectory);

	boolean isStaticDirectory(FsDirectoryPath fsDirectory);

	String getCvsRootFileContent(FsDirectoryPath fsDirectory) throws IOException;
}