/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.
 *
 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.response;

import java.util.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public final class ValidRequestsResponseHandler implements IResponseHandler {
	private final ValidRequests validRequests;

	// Static =================================================================

	public static IResponseHandler createInstance(ValidRequests validRequests) {
		return new ValidRequestsResponseHandler(validRequests);
	}

	// Setup ==================================================================

	private ValidRequestsResponseHandler(ValidRequests validRequests) {
		BugLog.assertNotNull(validRequests);

		this.validRequests = validRequests;
	}

	// Implemented ============================================================

	public void processOkResponse() {
	}

	public void processErrorResponse(String message) {
	}

	public void processErrorMessageResponse(String message) {
	}

	public void processMessageResponse(String message) {
	}

	public void processMessageTaggedResponse(String message) {
	}

	public void processCheckedInResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine) {
	}

	public void processNewEntryResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine) {
	}

	public void processSetStaticDirectoryResponse(String relativeLocalDirectory, String repositoryFilePath) {
	}

	public void processClearStaticDirectoryResponse(String relativeLocalDirectory, String repositoryDirectoryPath) {
	}

	public void processSetStickyResponse(String relativeLocalDirectory, String repositoryFilePath, String tag) {
	}

	public void processClearStickyResponse(String relativeLocalDirectory, String repositoryFilePath) {
	}

	public void processNotifiedResponse(String relativeLocalDirectory, String repositoryFilePath) {
	}

	public void processRemovedResponse(String relativeLocalDirectory, String repositoryFilePath) {
	}

	public void processRemoveEntryResponse(String relativeLocalDirectory, String repositoryFilePath) {
	}

	public void processCopyFileResponse(String relativeLocalDirectory, String repositoryFilePath, String newName) {
	}

	public void processModTimeResponse(Date modifiedDate) {
	}

	public void processModeResponse(String mode) {
	}

	public void processTemplateResponse(String relativeLocalDirectory, String repositoryFilePath, int length, IConnectionStreams connectionStreams) {
	}

	public void processModuleExpansionResponse(String localPath) {
	}

	public void processUpdatedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IConnectionStreams connectionStreams) {
	}

	public void processMergedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IConnectionStreams connectionStreams) {
	}

	public void processValidRequestsResponse(String validRequests) {
		this.validRequests.setValidRequests(validRequests);
	}
}
