package org.netbeans.lib.cvsclient.request;

import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public abstract class AbstractFileStateRequest extends AbstractRequest {

	// Fields =================================================================

	private final FsFilePath fsFile;

	// Setup ==================================================================

	protected AbstractFileStateRequest(FsFilePath fsFile) {
		BugLog.assertNotNull(fsFile);

		this.fsFile = fsFile;
	}

	// Accessing ==============================================================

	protected final String getFileName() {
		return fsFile.getName();
	}

	public final FsFilePath getFsFile() {
		return fsFile;
	}
}
