package org.netbeans.lib.cvsclient.progress;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public final class RangeProgressViewer
		implements IProgressViewer {

	// Fields =================================================================

	private final IProgressViewer parentProgressViewer;
	private final double lowerBound;
	private final double upperBound;

	// Setup ==================================================================

	public RangeProgressViewer(IProgressViewer parentProgressViewer, double lowerBound, double upperBound) {
		BugLog.assertNotNull(parentProgressViewer);

		this.parentProgressViewer = parentProgressViewer;
		this.lowerBound = lowerBound;
		this.upperBound = upperBound;
	}

	// Implemented ============================================================

	public void setProgress(double value) {
		final double boundedValue = (1.0 - value) * lowerBound + value * upperBound;
		parentProgressViewer.setProgress(boundedValue);
	}
}
