/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.io;

import java.io.*;

/**
 * 0x0000..0x007F = 0*******
 * 0x0080..0x07FF = 110***** 10******
 * 0x0800..0xFFFF = 1110**** 10****** 10******
 *
 * @author Thomas Singer
 */
public final class Utf8OutputStreamWriter extends AbstractOutputStreamWriter {

	// Setup ==================================================================

	public Utf8OutputStreamWriter(OutputStream outputStream) {
		super(outputStream);
	}

	// Implemented ============================================================

	@Override
	protected void writeChar(char chr, OutputStream outputStream) throws IOException {
		if (chr < 0x0080) {
			outputStream.write(chr);
		}
		else if (chr < 0x0800) {
			outputStream.write(chr >> 6 | 0xC0);
			outputStream.write(chr & 0x3F | 0x80);
		}
		else {
			outputStream.write(chr >> 12 | 0xE0);
			outputStream.write(chr >> 6 & 0x3F | 0x80);
			outputStream.write(chr & 0x3F | 0x80);
		}
	}
}
