/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

/**
 * Thiz represents a relative file name relative to an root entry (normally directory).
 *
 * @author Thomas Singer
 */
public final class FsDirectoryPath extends FsPath {

	// Constants ==============================================================

	public static final FsDirectoryPath ROOT = new FsDirectoryPath("/");

	// Static =================================================================

	public static FsDirectoryPath createAbsoluteInstance(String absoluteDirectoryName) {
		if (absoluteDirectoryName.length() > 1) {
			absoluteDirectoryName = FileUtils.removeTrailingSlash(absoluteDirectoryName);
		}
		return new FsDirectoryPath(absoluteDirectoryName);
	}

	public static FsDirectoryPath createRelativeInstance(FsDirectoryPath fsDirectory, String directoryPathRelativeToFsDirectory) {
		final String relativeFileName = FileUtils.concatPaths(fsDirectory.getPath(), directoryPathRelativeToFsDirectory);
		return new FsDirectoryPath(relativeFileName);
	}

	// Setup ==================================================================

	private FsDirectoryPath(String relativeFileName) {
		super(relativeFileName);
	}

	// Implemented ============================================================

	@Override
	public boolean isDirectory() {
		return true;
	}
}
