/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh1;

import com.maverick.crypto.digests.Hash;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.SshTunnel;
import com.maverick.ssh.message.SshMessage;
import com.maverick.ssh1.A;
import com.maverick.ssh1.E;
import com.maverick.ssh1.Ssh1RhostsRsaAuthentication;
import com.maverick.ssh1.Ssh1RsaPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class Ssh1Client
implements SshClient {
    static final int O = 9;
    static final int E = 6;
    static final int N = 7;
    static final int L = 8;
    static final int F = 29;
    static final int K = 28;
    static final int H = 35;
    String D;
    boolean J = false;
    boolean C;
    A I;
    E M;
    String G;
    SshAuthentication A;
    SshConnector B;

    public void connect(SshTransport sshTransport, SshContext sshContext, SshConnector sshConnector, String string, String string2, String string3, boolean bl) throws SshException {
        if (sshConnector == null || !sshConnector.isLicensed()) {
            throw new SshException("You cannot create Ssh1Client instances directly", 4);
        }
        this.M = new E(sshTransport, sshContext);
        this.D = string;
        this.C = bl;
        this.B = sshConnector;
        this.G = string3;
        if (string == null) {
            throw new SshException("You must supply a valid username!", 4);
        }
        this.M.A();
        this.M.F();
        this.J = this.M.A(string);
    }

    public String getRemoteIdentification() {
        return this.G;
    }

    public boolean isAuthenticated() {
        return this.J;
    }

    public int authenticate(SshAuthentication sshAuthentication) throws SshException {
        try {
            if (this.J) {
                throw new SshException("The connection has already been authenticated!", 4);
            }
            if (sshAuthentication.getUsername() == null) {
                sshAuthentication.setUsername(this.D);
            }
            if (sshAuthentication instanceof PasswordAuthentication) {
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.write(9);
                byteArrayWriter.writeString(((PasswordAuthentication)sshAuthentication).getPassword());
                this.M.B(byteArrayWriter.toByteArray());
                this.J = this.M.E();
                if (this.J) {
                    this.A = sshAuthentication;
                    return 1;
                }
                return 2;
            }
            if (sshAuthentication instanceof Ssh1RhostsRsaAuthentication) {
                Ssh1RhostsRsaAuthentication ssh1RhostsRsaAuthentication = (Ssh1RhostsRsaAuthentication)sshAuthentication;
                if (ssh1RhostsRsaAuthentication.getPublicKey() instanceof Ssh1RsaPublicKey && ssh1RhostsRsaAuthentication.getPrivateKey() instanceof RsaPrivateCrtKey) {
                    RsaPublicKey rsaPublicKey = (RsaPublicKey)ssh1RhostsRsaAuthentication.getPublicKey();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.write(35);
                    byteArrayWriter.writeString(ssh1RhostsRsaAuthentication.getClientUsername());
                    byteArrayWriter.writeInt(rsaPublicKey.getBitLength());
                    byteArrayWriter.writeMPINT(rsaPublicKey.getPublicExponent());
                    byteArrayWriter.writeMPINT(rsaPublicKey.getModulus());
                    this.M.B(byteArrayWriter.toByteArray());
                    this.J = this.A(true, (RsaPrivateCrtKey)ssh1RhostsRsaAuthentication.getPrivateKey());
                    if (this.J) {
                        this.A = sshAuthentication;
                        return 1;
                    }
                    return 2;
                }
                throw new SshException("Only SSH1 RSA keys are suitable for SSH1 hostbased authentication", 4);
            }
            if (sshAuthentication instanceof PublicKeyAuthentication) {
                PublicKeyAuthentication publicKeyAuthentication = (PublicKeyAuthentication)sshAuthentication;
                if (publicKeyAuthentication.getPublicKey() instanceof Ssh1RsaPublicKey) {
                    RsaPublicKey rsaPublicKey = (RsaPublicKey)publicKeyAuthentication.getPublicKey();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.write(6);
                    byteArrayWriter.writeMPINT(rsaPublicKey.getModulus());
                    this.M.B(byteArrayWriter.toByteArray());
                    this.J = this.A(publicKeyAuthentication.isAuthenticating(), (RsaPrivateCrtKey)publicKeyAuthentication.getPrivateKey());
                    if (publicKeyAuthentication.isAuthenticating()) {
                        if (this.J) {
                            this.A = sshAuthentication;
                            return 1;
                        }
                        return 2;
                    }
                    return 5;
                }
                throw new SshException("Only SSH1 RSA private keys are acceptable for SSH1 RSA Authentication", 4);
            }
            throw new SshException("Unsupported SSH1 authentication type!", 4);
        }
        catch (IOException iOException) {
            throw new SshException("Ssh1Client.authenticate caught an IOException: " + iOException.getMessage(), 5);
        }
    }

    private boolean A(boolean bl, RsaPrivateCrtKey rsaPrivateCrtKey) throws SshException {
        try {
            SshMessage sshMessage = new SshMessage(this.M.nextMessage());
            if (sshMessage.getMessageId() == 7) {
                Object object;
                byte[] byArray = new byte[16];
                if (bl && rsaPrivateCrtKey != null) {
                    object = sshMessage.readMPINT();
                    object = Rsa.doPrivateCrt((BigInteger)object, (BigInteger)rsaPrivateCrtKey.getPrivateExponent(), (BigInteger)rsaPrivateCrtKey.getPrimeP(), (BigInteger)rsaPrivateCrtKey.getPrimeQ(), (BigInteger)rsaPrivateCrtKey.getCrtCoefficient());
                    object = Rsa.removePKCS1((BigInteger)object, (int)2);
                    byArray = ((BigInteger)object).toByteArray();
                    Hash hash = new Hash("MD5");
                    if (byArray[0] == 0) {
                        hash.putBytes(byArray, 1, 32);
                    } else {
                        hash.putBytes(byArray, 0, 32);
                    }
                    hash.putBytes(this.M.X);
                    byArray = hash.doFinal();
                }
                object = new ByteArrayWriter();
                ((ByteArrayOutputStream)object).write(8);
                ((OutputStream)object).write(byArray);
                this.M.B(((ByteArrayOutputStream)object).toByteArray());
                return this.M.E();
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException("Ssh1Client.performRSAChallenge() caught an IOException: " + iOException.getMessage(), 5);
        }
    }

    public SshSession openSessionChannel() throws SshException, ChannelOpenException {
        return this.openSessionChannel(null);
    }

    public SshSession openSessionChannel(ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        if (!this.J) {
            throw new SshException("The connection must be authenticated first!", 4);
        }
        if (this.I == null) {
            this.I = new A(this.M, this, channelEventListener, this.C);
            if (this.M.B.getX11Display() != null && !this.I.\u00c4) {
                this.I.A(this.M.B.getX11Display(), this.M.B.getX11RequestListener());
            }
            return this.I;
        }
        return this.duplicate().openSessionChannel(channelEventListener);
    }

    public SshTunnel openForwardingChannel(String string, int n, String string2, int n2, String string3, int n3, SshTransport sshTransport, ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        if (this.I == null || !this.I.m) {
            throw new SshException("SSH1 forwarding channels can only be opened after the user's shell has been started!", 4);
        }
        return this.I.A(string, n, string2, n2, string3, n3, sshTransport, channelEventListener);
    }

    public SshClient openRemoteClient(String string, int n, String string2, SshConnector sshConnector) throws SshException, ChannelOpenException {
        SshTunnel sshTunnel = this.openForwardingChannel(string, n, "127.0.0.1", 22, "127.0.0.1", 22, null, null);
        return sshConnector.connect((SshTransport)sshTunnel, string2);
    }

    public SshClient openRemoteClient(String string, int n, String string2) throws SshException, ChannelOpenException {
        return this.openRemoteClient(string, n, string2, this.B);
    }

    public boolean requestXForwarding(String string, ForwardingRequestListener forwardingRequestListener) throws SshException {
        if (this.I != null && this.I.m) {
            throw new SshException("SSH1 X forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        if (this.I == null) {
            throw new SshException("SSH1 X forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        this.M.B.setX11Display(string);
        this.M.B.setX11RequestListener(forwardingRequestListener);
        this.I.A(string, forwardingRequestListener);
        return this.I.\u00c4;
    }

    public boolean requestRemoteForwarding(String string, int n, String string2, int n2, ForwardingRequestListener forwardingRequestListener) throws SshException {
        if (this.I != null && this.I.m) {
            throw new SshException("SSH1 forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        if (this.I == null) {
            throw new SshException("SSH1 forwarding requests must be made after opening the session but before starting the shell!", 4);
        }
        return this.I.A(n, string2, n2, forwardingRequestListener);
    }

    public boolean cancelRemoteForwarding(String string, int n) throws SshException {
        return false;
    }

    public void disconnect() {
        try {
            if (this.I != null) {
                this.I.signalClosingState();
            }
            this.M.B("The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.M.D() == 2;
    }

    public String getUsername() {
        return this.D;
    }

    public SshClient duplicate() throws SshException {
        if (this.D == null || this.A == null) {
            throw new SshException("Cannot duplicate! The existing connection does not have a set of credentials", 4);
        }
        try {
            SshClient sshClient = this.B.connect(this.M.Z.duplicate(), this.D, this.C, (SshContext)this.M.B);
            if (sshClient.authenticate(this.A) != 1) {
                throw new SshException("Duplication attempt failed to authenicate user!", 5);
            }
            return sshClient;
        }
        catch (IOException iOException) {
            throw new SshException("Failed to duplicate SshClient", 10);
        }
    }

    public SshContext getContext() {
        return this.M.B;
    }

    public int getChannelCount() {
        if (this.I == null) {
            return 0;
        }
        return this.I.getChannelCount();
    }

    public int getVersion() {
        return 1;
    }

    public boolean isBuffered() {
        return this.C;
    }

    public String toString() {
        return "SSH1 " + this.M.Z.getHost() + ":" + this.M.Z.getPort() + "[" + "cipher=" + (this.M.e == null ? "none" : this.M.e.getAlgorithm()) + "]";
    }
}

