/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.scp;

import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshSession;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ScpClientIO {
    protected SshClient ssh;

    public ScpClientIO(SshClient sshClient) {
        this.ssh = sshClient;
    }

    public void put(InputStream inputStream, long l, String string, String string2) throws SshException, ChannelOpenException {
        ScpEngineIO scpEngineIO = new ScpEngineIO("scp -t " + string2, this.ssh.openSessionChannel());
        try {
            scpEngineIO.waitForResponse();
            scpEngineIO.writeStreamToRemote(inputStream, l, string);
            scpEngineIO.close();
        }
        catch (IOException iOException) {
            scpEngineIO.close();
            throw new SshException(iOException.getMessage(), 6);
        }
    }

    public InputStream get(String string) throws SshException, ChannelOpenException {
        ScpEngineIO scpEngineIO = new ScpEngineIO("scp -f " + string, this.ssh.openSessionChannel());
        try {
            return scpEngineIO.readStreamFromRemote();
        }
        catch (IOException iOException) {
            scpEngineIO.close();
            throw new SshException(iOException.getMessage(), 6);
        }
    }

    class _A
    extends InputStream {
        long D;
        InputStream A;
        long C;
        ScpEngineIO B;

        _A(long l, InputStream inputStream, ScpEngineIO scpEngineIO) {
            this.D = l;
            this.A = inputStream;
            this.B = scpEngineIO;
        }

        public int read() throws IOException {
            if (this.C == this.D) {
                return -1;
            }
            if (this.C >= this.D) {
                throw new EOFException("End of file.");
            }
            int n = this.A.read();
            if (n == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            ++this.C;
            if (this.C == this.D) {
                this.B.waitForResponse();
                this.B.writeOk();
            }
            return n;
        }

        public void close() throws IOException {
            try {
                this.B.close();
            }
            catch (SshException sshException) {
                throw new SshIOException(sshException);
            }
        }
    }

    public class ScpEngineIO {
        protected byte[] buffer = new byte[16384];
        protected String cmd;
        protected SshSession session;
        protected OutputStream out;
        protected InputStream in;

        protected ScpEngineIO(String string, SshSession sshSession) throws SshException {
            try {
                this.session = sshSession;
                this.cmd = string;
                this.in = sshSession.getInputStream();
                this.out = sshSession.getOutputStream();
                if (!sshSession.executeCommand(string)) {
                    sshSession.close();
                    throw new SshException("Failed to execute the command " + string, 6);
                }
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
        }

        public void close() throws SshException {
            try {
                this.session.getOutputStream().close();
            }
            catch (IOException iOException) {
                throw new SshException((Throwable)iOException);
            }
            this.session.close();
        }

        protected void writeStreamToRemote(InputStream inputStream, long l, String string) throws IOException {
            String string2 = "C0644 " + l + " " + string + "\n";
            this.out.write(string2.getBytes());
            this.waitForResponse();
            this.writeCompleteFile(inputStream, l);
            this.writeOk();
            this.waitForResponse();
        }

        protected InputStream readStreamFromRemote() throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.writeOk();
            try {
                string = this.readString();
            }
            catch (EOFException eOFException) {
                return null;
            }
            char c = string.charAt(0);
            switch (c) {
                case 'E': {
                    this.writeOk();
                    return null;
                }
                case 'T': {
                    throw new IOException("SCP time not supported: " + string);
                }
                case 'D': {
                    throw new IOException("Directories cannot be copied to a stream");
                }
                case 'C': {
                    this.parseCommand(string, stringArray);
                    this.writeOk();
                    long l = Long.parseLong(stringArray[1]);
                    return new _A(l, this.in, this);
                }
            }
            this.writeError("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        protected void parseCommand(String string, String[] stringArray) throws IOException {
            int n = string.indexOf(32);
            int n2 = string.indexOf(32, n + 1);
            if (n == -1 || n2 == -1) {
                this.writeError("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            stringArray[0] = string.substring(1, n);
            stringArray[1] = string.substring(n + 1, n2);
            stringArray[2] = string.substring(n2 + 1);
        }

        protected String readString() throws IOException {
            int n;
            int n2 = 0;
            while ((n = this.in.read()) != 10 && n >= 0) {
                this.buffer[n2++] = (byte)n;
            }
            if (n == -1) {
                throw new EOFException("Unexpected EOF");
            }
            if (this.buffer[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.buffer[0] == 2 || this.buffer[0] == 1) {
                String string = new String(this.buffer, 1, n2 - 1);
                if (this.buffer[0] == 2) {
                    throw new IOException(string);
                }
                throw new IOException("SCP returned an unexpected error: " + string);
            }
            return new String(this.buffer, 0, n2);
        }

        public void waitForResponse() throws IOException {
            int n = this.in.read();
            if (n == 0) {
                return;
            }
            if (n == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String string = this.readString();
            if (n == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }

        protected void writeOk() throws IOException {
            this.out.write(0);
        }

        protected void writeError(String string) throws IOException {
            this.out.write(1);
            this.out.write(string.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeCompleteFile(InputStream inputStream, long l) throws IOException {
            try {
                int n;
                for (long i = 0L; i < l; i += (long)n) {
                    n = inputStream.read(this.buffer, 0, (int)(l - i < (long)this.buffer.length ? l - i : (long)this.buffer.length));
                    if (n == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    this.out.write(this.buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readCompleteFile(OutputStream outputStream, long l) throws IOException {
            try {
                int n;
                for (long i = 0L; i < l; i += (long)n) {
                    n = this.in.read(this.buffer, 0, (int)(l - i < (long)this.buffer.length ? l - i : (long)this.buffer.length));
                    if (n == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    outputStream.write(this.buffer, 0, n);
                }
            }
            finally {
                outputStream.close();
            }
        }
    }
}

