/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util.regex;

import java.util.regex.Pattern;
import net.sf.retrotranslator.runtime.java.lang._String;

public class _Pattern {
    public static final int LITERAL = 16;
    private static final String[][] REPLACEMENTS = new String[][]{{"\\p{javaDefined}", "\\P{Cn}"}, {"\\p{javaDigit}", "\\p{Nd}"}, {"\\p{javaIdentifierIgnorable}", "[\\u0000-\\u0008\\u000E-\\u001B\\u007F-\\u009F\\p{Cf}]"}, {"\\p{javaISOControl}", "\\p{Cc}"}, {"\\p{javaJavaIdentifierPart}", "[\\u0000-\\u0008\\u000E-\\u001B\\u007F-\\u009F\\p{Cf}\\p{L}\\p{Sc}\\p{Pc}\\p{Nd}\\p{Nl}\\p{Mc}\\p{Mn}]"}, {"\\p{javaJavaIdentifierStart}", "[\\p{L}\\p{Sc}\\p{Pc}\\p{Nl}]"}, {"\\p{javaLetter}", "\\p{L}"}, {"\\p{javaLetterOrDigit}", "[\\p{L}\\p{Nd}]"}, {"\\p{javaLowerCase}", "\\p{Ll}"}, {"\\p{javaSpaceChar}", "\\p{Z}"}, {"\\p{javaTitleCase}", "\\p{Lt}"}, {"\\p{javaUnicodeIdentifierPart}", "[\\u0000-\\u0008\\u000E-\\u001B\\u007F-\\u009F\\p{Cf}\\p{L}\\p{Pc}\\p{Nd}\\p{Nl}\\p{Mc}\\p{Mn}]"}, {"\\p{javaUnicodeIdentifierStart}", "[\\p{L}\\p{Nl}]"}, {"\\p{javaUpperCase}", "\\p{Lu}"}, {"\\p{javaWhitespace}", "[\\u0009-\\u000D\\u001C-\\u001F\\p{Z}&&[^\\u00A0\\u2007\\u202F]]"}};

    public static Pattern compile(String regex) {
        return Pattern.compile(_Pattern.fix(regex));
    }

    public static Pattern compile(String regex, int flags) {
        if ((flags & 0x10) == 16) {
            flags ^= 0x10;
            regex = _Pattern.quote(regex);
        }
        return Pattern.compile(_Pattern.fix(regex), flags);
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.matches(_Pattern.fix(regex), input);
    }

    private static String fix(String regex) {
        String[][] arr$ = REPLACEMENTS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] replacement = arr$[i$];
            regex = _String.replace(regex, replacement[0], replacement[1]);
        }
        return regex;
    }

    public static String quote(String s) {
        int nextIndex;
        StringBuffer builder = new StringBuffer(s.length() + 4).append("\\Q");
        int lastIndex = 0;
        while ((nextIndex = s.indexOf("\\E", lastIndex)) >= 0) {
            builder.append(s.substring(lastIndex, nextIndex)).append("\\E\\\\E\\Q");
            lastIndex = nextIndex + 2;
        }
        return builder.append(s.substring(lastIndex)).append("\\E").toString();
    }
}

