/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.PublicKey;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaKey;
import java.io.IOException;
import java.math.BigInteger;

public class RsaPublicKey
extends RsaKey
implements PublicKey {
    protected BigInteger publicExponent;

    public RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger);
        this.publicExponent = bigInteger2;
    }

    public RsaPublicKey() {
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        try {
            BigInteger bigInteger = new BigInteger(1, byArray);
            bigInteger = Rsa.doPublic(bigInteger, this.modulus, this.publicExponent);
            bigInteger = Rsa.removePKCS1(bigInteger, 1);
            byArray = bigInteger.toByteArray();
            SHA1Digest sHA1Digest = new SHA1Digest();
            sHA1Digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray3, 0);
            if (byArray3.length != byArray.length - RsaKey.ASN_SHA1.length) {
                return false;
            }
            byte[] byArray4 = RsaKey.ASN_SHA1;
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                if (n == RsaKey.ASN_SHA1.length) {
                    byArray4 = byArray3;
                    n2 = 0;
                }
                if (byArray[n] != byArray4[n2]) {
                    return false;
                }
                ++n;
                ++n2;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

