/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaKey;
import com.maverick.crypto.publickey.RsaPrivateKey;
import com.maverick.crypto.security.SecureRandom;
import java.io.IOException;
import java.math.BigInteger;

public class RsaPrivateCrtKey
extends RsaPrivateKey {
    protected BigInteger publicExponent;
    protected BigInteger primeP;
    protected BigInteger primeQ;
    protected BigInteger primeExponentP;
    protected BigInteger primeExponentQ;
    protected BigInteger crtCoefficient;

    public RsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        super(bigInteger, bigInteger3);
        this.publicExponent = bigInteger2;
        this.primeP = bigInteger4;
        this.primeQ = bigInteger5;
        this.primeExponentP = bigInteger6;
        this.primeExponentQ = bigInteger7;
        this.crtCoefficient = bigInteger8;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public byte[] sign(byte[] byArray) throws IOException {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[byArray2.length + RsaKey.ASN_SHA1.length];
        System.arraycopy(RsaKey.ASN_SHA1, 0, byArray3, 0, RsaKey.ASN_SHA1.length);
        System.arraycopy(byArray2, 0, byArray3, RsaKey.ASN_SHA1.length, byArray2.length);
        byArray2 = byArray3;
        BigInteger bigInteger = new BigInteger(1, byArray2);
        int n = (this.getModulus().bitLength() + 7) / 8;
        bigInteger = Rsa.padPKCS1(bigInteger, 1, n, SecureRandom.getInstance());
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = this.getPrimeP();
        BigInteger bigInteger4 = this.getPrimeQ();
        BigInteger bigInteger5 = this.getPrimeExponentP();
        BigInteger bigInteger6 = this.getPrimeExponentQ();
        BigInteger bigInteger7 = this.getCrtCoefficient();
        bigInteger2 = Rsa.doPrivateCrt(bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
        byte[] byArray4 = RsaPrivateKey.unsignedBigIntToBytes(bigInteger2, n);
        return byArray4;
    }
}

