/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.GeneralDigest;

public class MD5Digest
extends GeneralDigest {
    private static final int Z = 16;
    private int M;
    private int L;
    private int K;
    private int J;
    private int[] E = new int[16];
    private int D;
    private static final int T = 7;
    private static final int R = 12;
    private static final int P = 17;
    private static final int N = 22;
    private static final int Y = 5;
    private static final int X = 9;
    private static final int W = 14;
    private static final int V = 20;
    private static final int I = 4;
    private static final int H = 11;
    private static final int G = 16;
    private static final int F = 23;
    private static final int U = 6;
    private static final int S = 10;
    private static final int Q = 15;
    private static final int O = 21;

    public MD5Digest() {
        this.reset();
    }

    public MD5Digest(MD5Digest mD5Digest) {
        super(mD5Digest);
        this.M = mD5Digest.M;
        this.L = mD5Digest.L;
        this.K = mD5Digest.K;
        this.J = mD5Digest.J;
        System.arraycopy(mD5Digest.E, 0, this.E, 0, mD5Digest.E.length);
        this.D = mD5Digest.D;
    }

    public String getAlgorithmName() {
        return "MD5";
    }

    public int getDigestSize() {
        return 16;
    }

    protected void processWord(byte[] byArray, int n) {
        this.E[this.D++] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        if (this.D == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l) {
        if (this.D > 14) {
            this.processBlock();
        }
        this.E[14] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.E[15] = (int)(l >>> 32);
    }

    private void A(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 3] = (byte)(n >>> 24);
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        this.A(this.M, byArray, n);
        this.A(this.L, byArray, n + 4);
        this.A(this.K, byArray, n + 8);
        this.A(this.J, byArray, n + 12);
        this.reset();
        return 16;
    }

    public void reset() {
        super.reset();
        this.M = 1732584193;
        this.L = -271733879;
        this.K = -1732584194;
        this.J = 271733878;
        this.D = 0;
        for (int i = 0; i != this.E.length; ++i) {
            this.E[i] = 0;
        }
    }

    private int A(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private int A(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int C(int n, int n2, int n3) {
        return n & n3 | n2 & ~n3;
    }

    private int B(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int D(int n, int n2, int n3) {
        return n2 ^ (n | ~n3);
    }

    protected void processBlock() {
        int n = this.M;
        int n2 = this.L;
        int n3 = this.K;
        int n4 = this.J;
        n = this.A(n + this.A(n2, n3, n4) + this.E[0] + -680876936, 7) + n2;
        n4 = this.A(n4 + this.A(n, n2, n3) + this.E[1] + -389564586, 12) + n;
        n3 = this.A(n3 + this.A(n4, n, n2) + this.E[2] + 606105819, 17) + n4;
        n2 = this.A(n2 + this.A(n3, n4, n) + this.E[3] + -1044525330, 22) + n3;
        n = this.A(n + this.A(n2, n3, n4) + this.E[4] + -176418897, 7) + n2;
        n4 = this.A(n4 + this.A(n, n2, n3) + this.E[5] + 1200080426, 12) + n;
        n3 = this.A(n3 + this.A(n4, n, n2) + this.E[6] + -1473231341, 17) + n4;
        n2 = this.A(n2 + this.A(n3, n4, n) + this.E[7] + -45705983, 22) + n3;
        n = this.A(n + this.A(n2, n3, n4) + this.E[8] + 1770035416, 7) + n2;
        n4 = this.A(n4 + this.A(n, n2, n3) + this.E[9] + -1958414417, 12) + n;
        n3 = this.A(n3 + this.A(n4, n, n2) + this.E[10] + -42063, 17) + n4;
        n2 = this.A(n2 + this.A(n3, n4, n) + this.E[11] + -1990404162, 22) + n3;
        n = this.A(n + this.A(n2, n3, n4) + this.E[12] + 1804603682, 7) + n2;
        n4 = this.A(n4 + this.A(n, n2, n3) + this.E[13] + -40341101, 12) + n;
        n3 = this.A(n3 + this.A(n4, n, n2) + this.E[14] + -1502002290, 17) + n4;
        n2 = this.A(n2 + this.A(n3, n4, n) + this.E[15] + 1236535329, 22) + n3;
        n = this.A(n + this.C(n2, n3, n4) + this.E[1] + -165796510, 5) + n2;
        n4 = this.A(n4 + this.C(n, n2, n3) + this.E[6] + -1069501632, 9) + n;
        n3 = this.A(n3 + this.C(n4, n, n2) + this.E[11] + 643717713, 14) + n4;
        n2 = this.A(n2 + this.C(n3, n4, n) + this.E[0] + -373897302, 20) + n3;
        n = this.A(n + this.C(n2, n3, n4) + this.E[5] + -701558691, 5) + n2;
        n4 = this.A(n4 + this.C(n, n2, n3) + this.E[10] + 38016083, 9) + n;
        n3 = this.A(n3 + this.C(n4, n, n2) + this.E[15] + -660478335, 14) + n4;
        n2 = this.A(n2 + this.C(n3, n4, n) + this.E[4] + -405537848, 20) + n3;
        n = this.A(n + this.C(n2, n3, n4) + this.E[9] + 568446438, 5) + n2;
        n4 = this.A(n4 + this.C(n, n2, n3) + this.E[14] + -1019803690, 9) + n;
        n3 = this.A(n3 + this.C(n4, n, n2) + this.E[3] + -187363961, 14) + n4;
        n2 = this.A(n2 + this.C(n3, n4, n) + this.E[8] + 1163531501, 20) + n3;
        n = this.A(n + this.C(n2, n3, n4) + this.E[13] + -1444681467, 5) + n2;
        n4 = this.A(n4 + this.C(n, n2, n3) + this.E[2] + -51403784, 9) + n;
        n3 = this.A(n3 + this.C(n4, n, n2) + this.E[7] + 1735328473, 14) + n4;
        n2 = this.A(n2 + this.C(n3, n4, n) + this.E[12] + -1926607734, 20) + n3;
        n = this.A(n + this.B(n2, n3, n4) + this.E[5] + -378558, 4) + n2;
        n4 = this.A(n4 + this.B(n, n2, n3) + this.E[8] + -2022574463, 11) + n;
        n3 = this.A(n3 + this.B(n4, n, n2) + this.E[11] + 1839030562, 16) + n4;
        n2 = this.A(n2 + this.B(n3, n4, n) + this.E[14] + -35309556, 23) + n3;
        n = this.A(n + this.B(n2, n3, n4) + this.E[1] + -1530992060, 4) + n2;
        n4 = this.A(n4 + this.B(n, n2, n3) + this.E[4] + 1272893353, 11) + n;
        n3 = this.A(n3 + this.B(n4, n, n2) + this.E[7] + -155497632, 16) + n4;
        n2 = this.A(n2 + this.B(n3, n4, n) + this.E[10] + -1094730640, 23) + n3;
        n = this.A(n + this.B(n2, n3, n4) + this.E[13] + 681279174, 4) + n2;
        n4 = this.A(n4 + this.B(n, n2, n3) + this.E[0] + -358537222, 11) + n;
        n3 = this.A(n3 + this.B(n4, n, n2) + this.E[3] + -722521979, 16) + n4;
        n2 = this.A(n2 + this.B(n3, n4, n) + this.E[6] + 76029189, 23) + n3;
        n = this.A(n + this.B(n2, n3, n4) + this.E[9] + -640364487, 4) + n2;
        n4 = this.A(n4 + this.B(n, n2, n3) + this.E[12] + -421815835, 11) + n;
        n3 = this.A(n3 + this.B(n4, n, n2) + this.E[15] + 530742520, 16) + n4;
        n2 = this.A(n2 + this.B(n3, n4, n) + this.E[2] + -995338651, 23) + n3;
        n = this.A(n + this.D(n2, n3, n4) + this.E[0] + -198630844, 6) + n2;
        n4 = this.A(n4 + this.D(n, n2, n3) + this.E[7] + 1126891415, 10) + n;
        n3 = this.A(n3 + this.D(n4, n, n2) + this.E[14] + -1416354905, 15) + n4;
        n2 = this.A(n2 + this.D(n3, n4, n) + this.E[5] + -57434055, 21) + n3;
        n = this.A(n + this.D(n2, n3, n4) + this.E[12] + 1700485571, 6) + n2;
        n4 = this.A(n4 + this.D(n, n2, n3) + this.E[3] + -1894986606, 10) + n;
        n3 = this.A(n3 + this.D(n4, n, n2) + this.E[10] + -1051523, 15) + n4;
        n2 = this.A(n2 + this.D(n3, n4, n) + this.E[1] + -2054922799, 21) + n3;
        n = this.A(n + this.D(n2, n3, n4) + this.E[8] + 1873313359, 6) + n2;
        n4 = this.A(n4 + this.D(n, n2, n3) + this.E[15] + -30611744, 10) + n;
        n3 = this.A(n3 + this.D(n4, n, n2) + this.E[6] + -1560198380, 15) + n4;
        n2 = this.A(n2 + this.D(n3, n4, n) + this.E[13] + 1309151649, 21) + n3;
        n = this.A(n + this.D(n2, n3, n4) + this.E[4] + -145523070, 6) + n2;
        n4 = this.A(n4 + this.D(n, n2, n3) + this.E[11] + -1120210379, 10) + n;
        n3 = this.A(n3 + this.D(n4, n, n2) + this.E[2] + 718787259, 15) + n4;
        n2 = this.A(n2 + this.D(n3, n4, n) + this.E[9] + -343485551, 21) + n3;
        this.M += n;
        this.L += n2;
        this.K += n3;
        this.J += n4;
        this.D = 0;
        for (int i = 0; i != this.E.length; ++i) {
            this.E[i] = 0;
        }
    }
}

