/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.Digest;
import com.maverick.crypto.digests.DigestFactory;
import com.maverick.crypto.io.ByteArrayWriter;
import java.math.BigInteger;

public class Hash {
    private Digest A;

    public Hash(String string) {
        this.A = DigestFactory.createDigest(string);
    }

    public Hash(Digest digest) {
        this.A = digest;
    }

    public void putBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        this.putInt(byArray.length);
        this.putBytes(byArray);
    }

    public void putByte(byte by) {
        this.A.update(by);
    }

    public void putBytes(byte[] byArray) {
        this.A.update(byArray, 0, byArray.length);
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        this.A.update(byArray, n, n2);
    }

    public void putInt(int n) {
        this.putBytes(ByteArrayWriter.encodeInt(n));
    }

    public void putString(String string) {
        this.putInt(string.length());
        this.putBytes(string.getBytes());
    }

    public void reset() {
        this.A.reset();
    }

    public byte[] doFinal() {
        byte[] byArray = new byte[this.A.getDigestSize()];
        this.A.doFinal(byArray, 0);
        return byArray;
    }
}

