/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBoolean;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.DERSequence;
import com.maverick.crypto.asn1.x509.X509Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Extensions
implements DEREncodable {
    public static final DERObjectIdentifier SubjectKeyIdentifier = new DERObjectIdentifier("2.5.29.14");
    public static final DERObjectIdentifier KeyUsage = new DERObjectIdentifier("2.5.29.15");
    public static final DERObjectIdentifier PrivateKeyUsagePeriod = new DERObjectIdentifier("2.5.29.16");
    public static final DERObjectIdentifier SubjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
    public static final DERObjectIdentifier IssuerAlternativeName = new DERObjectIdentifier("2.5.29.18");
    public static final DERObjectIdentifier BasicConstraints = new DERObjectIdentifier("2.5.29.19");
    public static final DERObjectIdentifier CRLNumber = new DERObjectIdentifier("2.5.29.20");
    public static final DERObjectIdentifier ReasonCode = new DERObjectIdentifier("2.5.29.21");
    public static final DERObjectIdentifier InstructionCode = new DERObjectIdentifier("2.5.29.23");
    public static final DERObjectIdentifier InvalidityDate = new DERObjectIdentifier("2.5.29.24");
    public static final DERObjectIdentifier DeltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
    public static final DERObjectIdentifier IssuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
    public static final DERObjectIdentifier CertificateIssuer = new DERObjectIdentifier("2.5.29.29");
    public static final DERObjectIdentifier NameConstraints = new DERObjectIdentifier("2.5.29.30");
    public static final DERObjectIdentifier CRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
    public static final DERObjectIdentifier CertificatePolicies = new DERObjectIdentifier("2.5.29.32");
    public static final DERObjectIdentifier PolicyMappings = new DERObjectIdentifier("2.5.29.33");
    public static final DERObjectIdentifier AuthorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
    public static final DERObjectIdentifier PolicyConstraints = new DERObjectIdentifier("2.5.29.36");
    public static final DERObjectIdentifier ExtendedKeyUsage = new DERObjectIdentifier("2.5.29.37");
    public static final DERObjectIdentifier InhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
    public static final DERObjectIdentifier AuthorityInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
    private Hashtable d = new Hashtable();
    private Vector e = new Vector();

    public static X509Extensions getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509Extensions.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static X509Extensions getInstance(Object object) {
        if (object == null || object instanceof X509Extensions) {
            return (X509Extensions)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Extensions((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return X509Extensions.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public X509Extensions(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
            if (aSN1Sequence2.size() == 3) {
                this.d.put(aSN1Sequence2.getObjectAt(0), new X509Extension((DERBoolean)aSN1Sequence2.getObjectAt(1), (ASN1OctetString)aSN1Sequence2.getObjectAt(2)));
            } else {
                this.d.put(aSN1Sequence2.getObjectAt(0), new X509Extension(false, (ASN1OctetString)aSN1Sequence2.getObjectAt(1)));
            }
            this.e.addElement(aSN1Sequence2.getObjectAt(0));
        }
    }

    public X509Extensions(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Extensions(Vector vector, Hashtable hashtable) {
        Enumeration<Object> enumeration = vector == null ? hashtable.keys() : vector.elements();
        while (enumeration.hasMoreElements()) {
            this.e.addElement(enumeration.nextElement());
        }
        enumeration = this.e.elements();
        while (enumeration.hasMoreElements()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
            X509Extension x509Extension = (X509Extension)hashtable.get(dERObjectIdentifier);
            this.d.put(dERObjectIdentifier, x509Extension);
        }
    }

    public Enumeration oids() {
        return this.e.elements();
    }

    public X509Extension getExtension(DERObjectIdentifier dERObjectIdentifier) {
        return (X509Extension)this.d.get(dERObjectIdentifier);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.e.elements();
        while (enumeration.hasMoreElements()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
            X509Extension x509Extension = (X509Extension)this.d.get(dERObjectIdentifier);
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(dERObjectIdentifier);
            if (x509Extension.isCritical()) {
                aSN1EncodableVector2.add(new DERBoolean(true));
            }
            aSN1EncodableVector2.add(x509Extension.getValue());
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public int hashCode() {
        Enumeration enumeration = this.d.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            n ^= k.hashCode();
            n ^= this.d.get(k).hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof X509Extensions)) {
            return false;
        }
        X509Extensions x509Extensions = (X509Extensions)object;
        Enumeration enumeration = this.d.keys();
        Enumeration enumeration2 = x509Extensions.d.keys();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Object k;
            Object k2 = enumeration.nextElement();
            if (k2.equals(k = enumeration2.nextElement())) continue;
            return false;
        }
        return !enumeration.hasMoreElements() && !enumeration2.hasMoreElements();
    }
}

