/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBitString;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERTaggedObject;
import com.maverick.crypto.asn1.pkcs.PKCSObjectIdentifiers;
import com.maverick.crypto.asn1.x509.AlgorithmIdentifier;
import com.maverick.crypto.asn1.x509.SubjectPublicKeyInfo;
import com.maverick.crypto.asn1.x509.Time;
import com.maverick.crypto.asn1.x509.X509Extensions;
import com.maverick.crypto.asn1.x509.X509Name;
import com.maverick.crypto.asn1.x509.X509ObjectIdentifiers;

public class TBSCertificateStructure
implements DEREncodable,
X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    ASN1Sequence R;
    DERInteger N;
    DERInteger I;
    AlgorithmIdentifier H;
    X509Name M;
    Time G;
    Time K;
    X509Name Q;
    SubjectPublicKeyInfo D;
    DERBitString F;
    DERBitString J;
    X509Extensions P;

    public static TBSCertificateStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertificateStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertificateStructure getInstance(Object object) {
        if (object instanceof TBSCertificateStructure) {
            return (TBSCertificateStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new TBSCertificateStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public TBSCertificateStructure(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.R = aSN1Sequence;
        if (aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject) {
            this.N = DERInteger.getInstance(aSN1Sequence.getObjectAt(0));
        } else {
            n = -1;
            this.N = new DERInteger(0);
        }
        this.I = DERInteger.getInstance(aSN1Sequence.getObjectAt(n + 1));
        this.H = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n + 2));
        this.M = X509Name.getInstance(aSN1Sequence.getObjectAt(n + 3));
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n + 4);
        this.G = Time.getInstance(aSN1Sequence2.getObjectAt(0));
        this.K = Time.getInstance(aSN1Sequence2.getObjectAt(1));
        this.Q = X509Name.getInstance(aSN1Sequence.getObjectAt(n + 5));
        this.D = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(n + 6));
        block5: for (int i = aSN1Sequence.size() - (n + 6) - 1; i > 0; --i) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(n + 6 + i);
            switch (dERTaggedObject.getTagNo()) {
                case 1: {
                    this.F = DERBitString.getInstance(dERTaggedObject);
                    continue block5;
                }
                case 2: {
                    this.J = DERBitString.getInstance(dERTaggedObject);
                    continue block5;
                }
                case 3: {
                    this.P = X509Extensions.getInstance(dERTaggedObject);
                }
            }
        }
    }

    public int getVersion() {
        return this.N.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.N;
    }

    public DERInteger getSerialNumber() {
        return this.I;
    }

    public AlgorithmIdentifier getSignature() {
        return this.H;
    }

    public X509Name getIssuer() {
        return this.M;
    }

    public Time getStartDate() {
        return this.G;
    }

    public Time getEndDate() {
        return this.K;
    }

    public X509Name getSubject() {
        return this.Q;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.D;
    }

    public DERBitString getIssuerUniqueId() {
        return this.F;
    }

    public DERBitString getSubjectUniqueId() {
        return this.J;
    }

    public X509Extensions getExtensions() {
        return this.P;
    }

    public DERObject getDERObject() {
        return this.R;
    }
}

